/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.JarMemoryLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.MemoryResource;
import com.intellij.util.lang.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JarLoader
extends Loader {
    private static final List<Pair<Resource.Attribute, Attributes.Name>> PACKAGE_FIELDS = Arrays.asList(Pair.pair(Resource.Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), Pair.pair(Resource.Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), Pair.pair(Resource.Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), Pair.pair(Resource.Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), Pair.pair(Resource.Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), Pair.pair(Resource.Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR));
    private final File myCanonicalFile;
    private final boolean myCanLockJar;
    private SoftReference<JarMemoryLoader> myMemoryLoader;
    private volatile SoftReference<ZipFile> myZipFileSoftReference;
    private final Map<Resource.Attribute, String> myAttributes;
    private static final AtomicInteger myGetResourceRequests = new AtomicInteger();
    private static final AtomicLong myOpenTime = new AtomicLong();
    private static final AtomicLong myCloseTime = new AtomicLong();
    private static final Object ourLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarLoader(URL url, boolean canLockJar, int index2, boolean preloadJarContents) throws IOException {
        super(new URL("jar", "", -1, url + "!/"), index2);
        this.myCanonicalFile = new File(FileUtil.unquote(url.getFile())).getCanonicalFile();
        this.myCanLockJar = canLockJar;
        ZipFile zipFile = this.getZipFile();
        try {
            JarMemoryLoader loader;
            this.myAttributes = JarLoader.getAttributes(zipFile);
            if (preloadJarContents && (loader = JarMemoryLoader.load(zipFile, this.getBaseURL(), this.myAttributes)) != null) {
                this.myMemoryLoader = new SoftReference<JarMemoryLoader>(loader);
            }
        }
        finally {
            this.releaseZipFile(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Map<Resource.Attribute, String> getAttributes(ZipFile zipFile) {
        ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            return null;
        }
        EnumMap<Resource.Attribute, String> map2 = null;
        try {
            InputStream stream2 = zipFile.getInputStream(entry);
            try {
                Attributes attributes = new Manifest(stream2).getMainAttributes();
                for (Pair<Resource.Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
                    String value = attributes.getValue((Attributes.Name)p.second);
                    if (value == null) continue;
                    if (map2 == null) {
                        map2 = new EnumMap<Resource.Attribute, String>(Resource.Attribute.class);
                    }
                    map2.put((Resource.Attribute)((Object)p.first), value);
                }
            }
            finally {
                stream2.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        ZipFile zipFile = this.getZipFile();
        ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            loaderData.addResourceEntry(name);
            loaderData.addNameEntry(name);
        }
        ClasspathCache.LoaderData loaderData2 = loaderData;
        ClasspathCache.LoaderData loaderData3 = loaderData2;
        if (loaderData3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/lang/JarLoader", "buildData"));
        }
        return loaderData3;
        finally {
            this.releaseZipFile(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    Resource getResource(String name, boolean flag) {
        Resource resource;
        JarMemoryLoader loader;
        JarMemoryLoader jarMemoryLoader = loader = this.myMemoryLoader != null ? this.myMemoryLoader.get() : null;
        if (loader != null && (resource = loader.getResource(name)) != null) {
            return resource;
        }
        try {
            ZipFile zipFile = this.getZipFile();
            try {
                ZipEntry entry = zipFile.getEntry(name);
                if (entry == null) return null;
                MemoryResource memoryResource = MemoryResource.load(this.getBaseURL(), zipFile, entry, this.myAttributes);
                return memoryResource;
            }
            finally {
                this.releaseZipFile(zipFile);
            }
        }
        catch (Exception e) {
            this.error("file: " + this.myCanonicalFile, e);
        }
        return null;
    }

    protected void error(String message, Throwable t) {
        Logger.getInstance(JarLoader.class).error(message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseZipFile(ZipFile zipFile) throws IOException {
        long started = System.nanoTime();
        try {
            if (!this.myCanLockJar) {
                zipFile.close();
            }
        }
        finally {
            myCloseTime.addAndGet(System.nanoTime() - started);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ZipFile getZipFile() throws IOException {
        block12: {
            requests = JarLoader.myGetResourceRequests.incrementAndGet();
            started = System.nanoTime();
            try {
                if (!this.myCanLockJar) break block12;
                zipFileSoftReference = this.myZipFileSoftReference;
                if (zipFileSoftReference != null && (existingZipFile = zipFileSoftReference.get()) != null) {
                    var6_6 = existingZipFile;
                    JarLoader.myOpenTime.addAndGet(System.nanoTime() - started);
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var9_10) {
                JarLoader.myOpenTime.addAndGet(System.nanoTime() - started);
                throw var9_10;
            }
            v0 = var6_6;
            if (v0 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/util/lang/JarLoader", "getZipFile"}));
            }
            return v0;
lbl-1000:
            // 1 sources

            {
                var5_5 = JarLoader.ourLock;
                synchronized (var5_5) {
                    zipFileSoftReference = this.myZipFileSoftReference;
                    if (zipFileSoftReference == null || (existingZipFile = zipFileSoftReference.get()) == null) ** break block13
                    var7_8 = existingZipFile;
                }
                JarLoader.myOpenTime.addAndGet(System.nanoTime() - started);
            }
            v1 = var7_8;
            if (v1 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/util/lang/JarLoader", "getZipFile"}));
            }
            return v1;
            {
                zipFile = new ZipFile(this.myCanonicalFile);
                this.myZipFileSoftReference = new SoftReference<ZipFile>(zipFile);
                var7_9 = zipFile;
            }
            JarLoader.myOpenTime.addAndGet(System.nanoTime() - started);
            v2 = var7_9;
            if (v2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/util/lang/JarLoader", "getZipFile"}));
            }
            return v2;
        }
        var4_4 = new ZipFile(this.myCanonicalFile);
        JarLoader.myOpenTime.addAndGet(System.nanoTime() - started);
        v3 = var4_4;
        if (v3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/util/lang/JarLoader", "getZipFile"}));
        }
        return v3;
    }

    public String toString() {
        return "JarLoader [" + this.myCanonicalFile + "]";
    }
}

