/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleExperimentalSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final GradleExperimentalSettings mySettings;
    private JPanel myPanel;
    private JCheckBox myEnableModuleSelectionOnImportCheckBox;
    private JSpinner myModuleNumberSpinner;
    private JCheckBox mySkipSourceGenOnSyncCheckbox;

    public GradleExperimentalSettingsConfigurable() {
        this.$$$setupUI$$$();
        this.mySettings = GradleExperimentalSettings.getInstance();
    }

    @NotNull
    public String getId() {
        if ("gradle.experimental" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleExperimentalSettingsConfigurable", "getId"));
        }
        return "gradle.experimental";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Experimental";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleExperimentalSettingsConfigurable", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        if (this.mySettings.SELECT_MODULES_ON_PROJECT_IMPORT != this.isModuleSelectionOnImportEnabled() || this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC != this.isSkipSourceGenOnSync()) {
            return true;
        }
        Integer value = this.getMaxModuleCountForSourceGen();
        return value != null && this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN != value;
    }

    public void apply() throws ConfigurationException {
        this.mySettings.SELECT_MODULES_ON_PROJECT_IMPORT = this.isModuleSelectionOnImportEnabled();
        this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC = this.isSkipSourceGenOnSync();
        Integer value = this.getMaxModuleCountForSourceGen();
        if (value != null) {
            this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN = value;
        }
    }

    @Nullable
    private Integer getMaxModuleCountForSourceGen() {
        Object value = this.myModuleNumberSpinner.getValue();
        return value instanceof Integer ? (Integer)value : null;
    }

    private boolean isModuleSelectionOnImportEnabled() {
        return this.myEnableModuleSelectionOnImportCheckBox.isSelected();
    }

    private boolean isSkipSourceGenOnSync() {
        return this.mySkipSourceGenOnSyncCheckbox.isSelected();
    }

    public void reset() {
        this.myEnableModuleSelectionOnImportCheckBox.setSelected(this.mySettings.SELECT_MODULES_ON_PROJECT_IMPORT);
        this.mySkipSourceGenOnSyncCheckbox.setSelected(this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC);
        this.myModuleNumberSpinner.setValue(this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN);
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        JFormattedTextField textField;
        JFormattedTextField.AbstractFormatter formatter;
        int value = GradleExperimentalSettings.getInstance().MAX_MODULE_COUNT_FOR_SOURCE_GEN;
        this.myModuleNumberSpinner = new JSpinner(new SpinnerNumberModel(value, 0, Integer.MAX_VALUE, 1));
        JComponent editor = this.myModuleNumberSpinner.getEditor();
        if (editor instanceof JSpinner.NumberEditor && (formatter = (textField = ((JSpinner.NumberEditor)editor).getTextField()).getFormatter()) instanceof NumberFormatter) {
            ((NumberFormatter)formatter).setAllowsInvalid(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><b>Note:</b> This settings are for features that are considered <b>experimental</b>.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        this.myEnableModuleSelectionOnImportCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Allow Module selection on Project import");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JXLabel jXLabel = new JXLabel();
        jXLabel.setText("When importing a project, select the Modules to be visible in the IDE (helps improve IDE performance when working on big projects.)");
        jXLabel.setLineWrap(true);
        jPanel.add((Component)jXLabel, new GridConstraints(3, 0, 1, 3, 0, 1, 1, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("<html><br></html>");
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        this.mySkipSourceGenOnSyncCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Skip source generation on Gradle sync if a Project has more than");
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner = this.myModuleNumberSpinner;
        jPanel.add((Component)jSpinner, new GridConstraints(5, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Modules.");
        jPanel.add((Component)jBLabel4, new GridConstraints(5, 2, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

