/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.AbstractModelAction;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBasedNodeInitializer<T, S extends T>
implements NodeInitializer {
    private final InstanceFactory<T> instanceFactory;
    private final ModelType<S> type;

    public FactoryBasedNodeInitializer(InstanceFactory<T> instanceFactory, ModelType<S> type) {
        this.instanceFactory = instanceFactory;
        this.type = type;
    }

    @Override
    public List<? extends ModelReference<?>> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
        S item = this.instanceFactory.create(this.type, modelNode, modelNode.getPath().getName());
        modelNode.setPrivateData(this.type, item);
    }

    @Override
    public List<? extends ModelProjection> getProjections() {
        return Collections.singletonList(UnmanagedModelProjection.of(this.type));
    }

    @Override
    @Nullable
    public ModelAction getProjector(ModelPath path, ModelRuleDescriptor descriptor) {
        return new AbstractModelAction<Object>(ModelReference.of(path), descriptor, new ModelReference[0]){

            @Override
            public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                for (ModelType<?> internalView : FactoryBasedNodeInitializer.this.instanceFactory.getInternalViews(FactoryBasedNodeInitializer.this.type)) {
                    modelNode.addProjection(UnmanagedModelProjection.of(internalView));
                }
            }
        };
    }
}

