/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopes
extends GlobalSearchScopesCore {
    public static final String OPEN_FILES_SCOPE_NAME = "Open Files";

    private GlobalSearchScopes() {
    }

    @NotNull
    public static GlobalSearchScope openFilesScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopes", "openFilesScope"));
        }
        Object[] files = FileEditorManager.getInstance(project).getOpenFiles();
        if (ArrayUtil.isEmpty((Object[])files)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(project, null, OPEN_FILES_SCOPE_NAME);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopes", "openFilesScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, Arrays.asList(files), OPEN_FILES_SCOPE_NAME);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopes", "openFilesScope"));
        }
        return globalSearchScope;
    }
}

