/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleParameters;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.idea.decompiler.common.ProtoBufUtilKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DeserializerForDecompilerBase;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.PackageFragmentProviderForMissingDependencies;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolverForDecompiler;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005H\u0004J.\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0004J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202H\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DeserializerForDecompilerBase;", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/ResolverForDecompiler;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)V", "deserializationComponents", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "getPackageFragmentProvider", "()Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "getStorageManager", "()Lorg/jetbrains/kotlin/storage/StorageManager;", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "createDummyModule", "name", "", "createDummyPackageFragment", "Lorg/jetbrains/kotlin/descriptors/impl/MutablePackageFragmentDescriptor;", "fqName", "getDescriptorsFromPackageFile", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "packageFqName", "paths", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "resolveTopLevelClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "idea-analysis"})
public abstract class DeserializerForDecompilerBase
implements ResolverForDecompiler {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ModuleDescriptorImpl moduleDescriptor;
    @NotNull
    private final PackageFragmentProvider packageFragmentProvider;
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final FqName directoryPackageFqName;

    @NotNull
    protected abstract DeserializationComponents getDeserializationComponents();

    @NotNull
    protected abstract TargetPlatform getTargetPlatform();

    @NotNull
    protected final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    protected final ModuleDescriptorImpl getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    protected final PackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    @Override
    @Nullable
    public ClassDescriptor resolveTopLevelClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return this.getDeserializationComponents().deserializeClass(classId);
    }

    @NotNull
    protected final MutablePackageFragmentDescriptor createDummyPackageFragment(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return new MutablePackageFragmentDescriptor(this.moduleDescriptor, fqName2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<DeclarationDescriptor> getDescriptorsFromPackageFile(@NotNull FqName packageFqName, @NotNull SerializedResourcePaths paths, @NotNull Logger log, @NotNull NameResolver nameResolver) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        boolean bl = Intrinsics.areEqual((Object)packageFqName, (Object)this.directoryPackageFqName);
        if (_Assertions.ENABLED) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "Was called for " + packageFqName + "; only members of " + this.directoryPackageFqName + " package are expected.";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        String packageFilePath = StringsKt.substringAfterLast$default((String)paths.getPackageFilePath(this.directoryPackageFqName), (String)"/", null, (int)2, null);
        VirtualFile file = this.packageDirectory.findChild(packageFilePath);
        if (file == null) {
            log.error("Could not read data for package " + packageFqName + "; " + packageFilePath + " absent in " + this.packageDirectory);
            return CollectionsKt.emptyList();
        }
        byte[] content2 = file.contentsToByteArray(false);
        ProtoBuf.Package packageProto = ProtoBufUtilKt.toPackageProto(content2, paths.getExtensionRegistry());
        DeserializedPackageMemberScope membersScope2 = new DeserializedPackageMemberScope(this.createDummyPackageFragment(packageFqName), packageProto, nameResolver, null, this.getDeserializationComponents(), (Function0<? extends Collection<Name>>)((Function0)getDescriptorsFromPackageFile.membersScope.1.INSTANCE));
        return CollectionsKt.toList((Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(membersScope2, null, null, 3, null));
    }

    private final ModuleDescriptorImpl createDummyModule(String name2) {
        Name name3 = Name.special("<" + name2 + ">");
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.special(\"<$name>\")");
        return new ModuleDescriptorImpl(name3, this.storageManager, ModuleParameters.Empty.INSTANCE, this.getTargetPlatform().getBuiltIns(), null, 16, null);
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    public DeserializerForDecompilerBase(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkParameterIsNotNull((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkExpressionValueIsNotNull((Object)storageManager, (String)"LockBasedStorageManager.NO_LOCKS");
        this.storageManager = storageManager;
        this.moduleDescriptor = this.createDummyModule("module for building decompiled sources");
        this.packageFragmentProvider = new PackageFragmentProvider(this){
            final /* synthetic */ DeserializerForDecompilerBase this$0;

            @NotNull
            public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
                Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                return CollectionsKt.listOf((Object)this.this$0.createDummyPackageFragment(fqName2));
            }

            @NotNull
            public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
                Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                Intrinsics.checkParameterIsNotNull(nameFilter2, (String)"nameFilter");
                throw (Throwable)new UnsupportedOperationException("This method is not supposed to be called.");
            }
            {
                this.this$0 = $outer;
            }
        };
        this.moduleDescriptor.initialize(this.packageFragmentProvider);
        ModuleDescriptorImpl moduleContainingMissingDependencies = this.createDummyModule("module containing missing dependencies for decompiled sources");
        moduleContainingMissingDependencies.setDependencies(moduleContainingMissingDependencies);
        moduleContainingMissingDependencies.initialize(new PackageFragmentProviderForMissingDependencies(moduleContainingMissingDependencies));
        ModuleDescriptorImpl[] moduleDescriptorImplArray = new ModuleDescriptorImpl[3];
        moduleDescriptorImplArray[0] = this.moduleDescriptor;
        ModuleDescriptorImpl moduleDescriptorImpl = this.getTargetPlatform().getBuiltIns().getBuiltInsModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptorImpl, (String)"targetPlatform.builtIns.builtInsModule");
        moduleDescriptorImplArray[1] = moduleDescriptorImpl;
        moduleDescriptorImplArray[2] = moduleContainingMissingDependencies;
        this.moduleDescriptor.setDependencies(moduleDescriptorImplArray);
    }
}

