/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChoosePathDialog
extends DialogWrapper {
    private final Project myProject;
    private final String defaultPath;
    private final String description;
    private TextFieldWithBrowseButton myPathField;

    public ChoosePathDialog(@Nullable Project project, @NotNull String title, @NotNull String defaultPath, @Nullable String description) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/framework/ui/ChoosePathDialog", "<init>"));
        }
        if (defaultPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPath", "org/jetbrains/kotlin/idea/framework/ui/ChoosePathDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.defaultPath = defaultPath;
        this.description = description;
        this.setTitle(title);
        this.init();
    }

    protected JComponent createCenterPanel() {
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setGap(3);
        JPanel panel = new JPanel((LayoutManager)verticalLayout);
        if (this.description != null) {
            panel.add(new JLabel(this.description));
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        FileTextField field2 = FileChooserFactory.getInstance().createFileTextField(descriptor2, this.myDisposable);
        field2.getField().setColumns(25);
        this.myPathField = new TextFieldWithBrowseButton(field2.getField());
        this.myPathField.addBrowseFolderListener("Choose Destination Folder", "Choose folder", this.myProject, descriptor2);
        this.myPathField.setText(this.defaultPath);
        panel.add((Component)this.myPathField);
        return panel;
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    @NotNull
    public String getPath() {
        String string = this.myPathField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/ui/ChoosePathDialog", "getPath"));
        }
        return string;
    }
}

