/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionTable;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForExistingElement;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinFileChooserDialog;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

public class MoveKotlinTopLevelDeclarationsDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = "MoveKotlinTopLevelDeclarationsDialog.RECENTS_KEY";
    private JCheckBox cbSearchInComments;
    private JCheckBox cbSearchTextOccurrences;
    private JPanel mainPanel;
    private ReferenceEditorComboWithBrowseButton classPackageChooser;
    private ComboboxWithBrowseButton destinationFolderCB;
    private JPanel targetPanel;
    private JRadioButton rbMoveToPackage;
    private JRadioButton rbMoveToFile;
    private TextFieldWithBrowseButton fileChooser;
    private JPanel memberInfoPanel;
    private JTextField tfFileNameInPackage;
    private JCheckBox cbSpecifyFileNameInPackage;
    private JCheckBox cbUpdatePackageDirective;
    private KotlinMemberSelectionTable memberTable;
    private final MoveCallback moveCallback;

    public MoveKotlinTopLevelDeclarationsDialog(@NotNull Project project, @NotNull Set<KtNamedDeclaration> elementsToMove, @Nullable String targetPackageName, @Nullable PsiDirectory targetDirectory, @Nullable KtFile targetFile, boolean moveToPackage, boolean searchInComments, boolean searchForTextOccurences, @Nullable MoveCallback moveCallback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "<init>"));
        }
        if (elementsToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToMove", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "<init>"));
        }
        super(project, true);
        this.$$$setupUI$$$();
        List<KtFile> sourceFiles = MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(elementsToMove);
        this.moveCallback = moveCallback;
        this.init();
        this.setTitle(MoveHandler.REFACTORING_NAME);
        this.initSearchOptions(searchInComments, searchForTextOccurences);
        this.initPackageChooser(targetPackageName, targetDirectory, sourceFiles);
        this.initFileChooser(targetFile, elementsToMove, sourceFiles);
        this.initMoveToButtons(moveToPackage);
        this.initMemberInfo(elementsToMove, sourceFiles);
        this.updateControls();
    }

    private static List<KtFile> getSourceFiles(@NotNull Collection<KtNamedDeclaration> elementsToMove) {
        if (elementsToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToMove", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "getSourceFiles"));
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.map(elementsToMove, (Function1)new Function1<KtNamedDeclaration, KtFile>(){

            public KtFile invoke(KtNamedDeclaration declaration) {
                return declaration.getContainingKtFile();
            }
        }));
    }

    @NotNull
    private static PsiDirectory getSourceDirectory(@NotNull Collection<KtFile> sourceFiles) {
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "getSourceDirectory"));
        }
        PsiDirectory psiDirectory = (PsiDirectory)CollectionsKt.single((List)CollectionsKt.distinct((Iterable)CollectionsKt.map(sourceFiles, (Function1)new Function1<KtFile, PsiDirectory>(){

            public PsiDirectory invoke(KtFile jetFile) {
                return jetFile.getParent();
            }
        })));
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "getSourceDirectory"));
        }
        return psiDirectory;
    }

    private static List<KtNamedDeclaration> getAllDeclarations(Collection<KtFile> sourceFiles) {
        return CollectionsKt.filterIsInstance((Iterable)CollectionsKt.flatMap(sourceFiles, (Function1)new Function1<KtFile, Iterable<?>>(){

            public Iterable<?> invoke(KtFile jetFile) {
                return jetFile.getDeclarations();
            }
        }), KtNamedDeclaration.class);
    }

    private static boolean arePackagesAndDirectoryMatched(List<KtFile> sourceFiles) {
        for (KtFile sourceFile : sourceFiles) {
            if (PackageUtilsKt.packageMatchesDirectory(sourceFile)) continue;
            return false;
        }
        return true;
    }

    private void initMemberInfo(final @NotNull Set<KtNamedDeclaration> elementsToMove, @NotNull List<KtFile> sourceFiles) {
        if (elementsToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToMove", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "initMemberInfo"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "initMemberInfo"));
        }
        final List memberInfos = CollectionsKt.map(MoveKotlinTopLevelDeclarationsDialog.getAllDeclarations(sourceFiles), (Function1)new Function1<KtNamedDeclaration, KotlinMemberInfo>(){

            public KotlinMemberInfo invoke(KtNamedDeclaration declaration) {
                KotlinMemberInfo memberInfo = new KotlinMemberInfo(declaration, false);
                memberInfo.setChecked(elementsToMove.contains(declaration));
                return memberInfo;
            }
        });
        KotlinMemberSelectionPanel selectionPanel = new KotlinMemberSelectionPanel(this.getTitle(), memberInfos, null);
        this.memberTable = selectionPanel.getTable();
        MemberInfoModelImpl memberInfoModel = new MemberInfoModelImpl();
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)memberInfos));
        selectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)new MemberInfoChangeListener<KtNamedDeclaration, KotlinMemberInfo>(){

            private boolean shouldUpdateFileNameField(final Collection<KotlinMemberInfo> changedMembers) {
                if (!MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.isEnabled()) {
                    return true;
                }
                List previousDeclarations = CollectionsKt.filterNotNull((Iterable)CollectionsKt.map((Iterable)memberInfos, (Function1)new Function1<KotlinMemberInfo, KtNamedDeclaration>(){

                    public KtNamedDeclaration invoke(KotlinMemberInfo info) {
                        return changedMembers.contains((Object)info) != info.isChecked() ? (KtNamedDeclaration)info.getMember() : null;
                    }
                }));
                String suggestedText = previousDeclarations.isEmpty() ? "" : MoveUtilsKt.guessNewFileName(previousDeclarations);
                return MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.getText().equals(suggestedText);
            }

            public void memberInfoChanged(MemberInfoChange<KtNamedDeclaration, KotlinMemberInfo> event) {
                MoveKotlinTopLevelDeclarationsDialog.this.updatePackageDirectiveCheckBox();
                MoveKotlinTopLevelDeclarationsDialog.this.updateFileNameInPackageField();
                if (this.shouldUpdateFileNameField(event.getChangedMembers())) {
                    MoveKotlinTopLevelDeclarationsDialog.this.updateSuggestedFileName();
                }
            }
        });
        this.memberInfoPanel.add((Component)((Object)selectionPanel), "Center");
    }

    private void updateSuggestedFileName() {
        this.tfFileNameInPackage.setText(MoveUtilsKt.guessNewFileName(this.getSelectedElementsToMove()));
    }

    private void updateFileNameInPackageField() {
        boolean movingSingleFileToPackage = this.isMoveToPackage() && MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(this.getSelectedElementsToMove()).size() == 1;
        this.cbSpecifyFileNameInPackage.setEnabled(movingSingleFileToPackage);
        this.tfFileNameInPackage.setEnabled(movingSingleFileToPackage && this.cbSpecifyFileNameInPackage.isSelected());
    }

    private void initPackageChooser(String targetPackageName, PsiDirectory targetDirectory, List<KtFile> sourceFiles) {
        if (targetPackageName != null) {
            this.classPackageChooser.prependItem(targetPackageName);
        }
        ((DestinationFolderComboBox)this.destinationFolderCB).setData(this.myProject, targetDirectory, (Pass)new Pass<String>(){

            public void pass(String s) {
                MoveKotlinTopLevelDeclarationsDialog.this.setErrorText(s);
            }
        }, (EditorComboBox)this.classPackageChooser.getChildComponent());
        this.cbSpecifyFileNameInPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$7", "actionPerformed"));
                }
                MoveKotlinTopLevelDeclarationsDialog.this.updateFileNameInPackageField();
            }
        });
        this.cbUpdatePackageDirective.setSelected(MoveKotlinTopLevelDeclarationsDialog.arePackagesAndDirectoryMatched(sourceFiles));
    }

    private void initSearchOptions(boolean searchInComments, boolean searchForTextOccurences) {
        this.cbSearchInComments.setSelected(searchInComments);
        this.cbSearchTextOccurrences.setSelected(searchForTextOccurences);
    }

    private void initMoveToButtons(boolean moveToPackage) {
        if (moveToPackage) {
            this.rbMoveToPackage.setSelected(true);
        } else {
            this.rbMoveToFile.setSelected(true);
        }
        this.rbMoveToPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$8", "actionPerformed"));
                }
                MoveKotlinTopLevelDeclarationsDialog.this.classPackageChooser.requestFocus();
                MoveKotlinTopLevelDeclarationsDialog.this.updateControls();
            }
        });
        this.rbMoveToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$9", "actionPerformed"));
                }
                MoveKotlinTopLevelDeclarationsDialog.this.fileChooser.requestFocus();
                MoveKotlinTopLevelDeclarationsDialog.this.updateControls();
            }
        });
    }

    private void initFileChooser(@Nullable KtFile targetFile, @NotNull Set<KtNamedDeclaration> elementsToMove, @NotNull List<KtFile> sourceFiles) {
        if (elementsToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToMove", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "initFileChooser"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "initFileChooser"));
        }
        final PsiDirectory sourceDir = sourceFiles.get(0).getParent();
        assert (sourceDir != null) : sourceFiles.get(0).getVirtualFile().getPath();
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KtFile selectedFile;
                KotlinFileChooserDialog dialog2 = new KotlinFileChooserDialog("Choose Containing File", MoveKotlinTopLevelDeclarationsDialog.this.myProject);
                File targetFile = new File(MoveKotlinTopLevelDeclarationsDialog.this.getTargetFilePath());
                PsiFile targetPsiFile = JetRefactoringUtilKt.toPsiFile(targetFile, MoveKotlinTopLevelDeclarationsDialog.this.myProject);
                if (targetPsiFile instanceof KtFile) {
                    dialog2.select((KtFile)targetPsiFile);
                } else {
                    PsiDirectory targetDir = JetRefactoringUtilKt.toPsiDirectory(targetFile.getParentFile(), MoveKotlinTopLevelDeclarationsDialog.this.myProject);
                    if (targetDir == null) {
                        targetDir = sourceDir;
                    }
                    dialog2.selectDirectory(targetDir);
                }
                dialog2.showDialog();
                KtFile ktFile = selectedFile = dialog2.isOK() ? (KtFile)dialog2.getSelected() : null;
                if (selectedFile != null) {
                    MoveKotlinTopLevelDeclarationsDialog.this.fileChooser.setText(selectedFile.getVirtualFile().getPath());
                }
            }
        });
        String initialTargetPath = targetFile != null ? targetFile.getVirtualFile().getPath() : sourceFiles.get(0).getVirtualFile().getParent().getPath() + "/" + MoveUtilsKt.guessNewFileName(elementsToMove);
        this.fileChooser.setText(initialTargetPath);
    }

    private void createUIComponents() {
        this.classPackageChooser = this.createPackageChooser();
        this.destinationFolderCB = new DestinationFolderComboBox(){

            public String getTargetPackage() {
                return MoveKotlinTopLevelDeclarationsDialog.this.getTargetPackage();
            }
        };
    }

    private ReferenceEditorComboWithBrowseButton createPackageChooser() {
        PackageNameReferenceEditorCombo packageChooser = new PackageNameReferenceEditorCombo("", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)packageChooser.getChildComponent()).getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                MoveKotlinTopLevelDeclarationsDialog.this.validateButtons();
            }
        });
        return packageChooser;
    }

    private void updateControls() {
        boolean moveToPackage = this.isMoveToPackage();
        this.classPackageChooser.setEnabled(moveToPackage);
        this.updateFileNameInPackageField();
        this.fileChooser.setEnabled(!moveToPackage);
        this.updatePackageDirectiveCheckBox();
        UIUtil.setEnabled((Component)this.targetPanel, (moveToPackage && this.hasAnySourceRoots() ? 1 : 0) != 0, (boolean)true);
        this.updateSuggestedFileName();
        this.validateButtons();
    }

    private boolean isFullFileMove() {
        Map fileToElements = CollectionsKt.groupBy(this.getSelectedElementsToMove(), (Function1)new Function1<KtNamedDeclaration, KtFile>(){

            public KtFile invoke(KtNamedDeclaration declaration) {
                return declaration.getContainingKtFile();
            }
        });
        for (Map.Entry entry : fileToElements.entrySet()) {
            if (((KtFile)entry.getKey()).getDeclarations().size() == ((List)entry.getValue()).size()) continue;
            return false;
        }
        return true;
    }

    private void updatePackageDirectiveCheckBox() {
        this.cbUpdatePackageDirective.setEnabled(this.isMoveToPackage() && this.isFullFileMove());
    }

    private boolean hasAnySourceRoots() {
        return !JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)this.myProject).isEmpty();
    }

    private void saveRefactoringSettings() {
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = this.isSearchInComments();
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = this.isSearchInNonJavaFiles();
        refactoringSettings.MOVE_PREVIEW_USAGES = this.isPreviewUsages();
    }

    @Nullable
    private MoveDestination selectPackageBasedMoveDestination(boolean askIfDoesNotExist) {
        int ret;
        String packageName = this.getTargetPackage();
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        PackageWrapper targetPackage = new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName);
        if (!targetPackage.exists() && askIfDoesNotExist && (ret = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"package.does.not.exist", (Object[])new Object[]{packageName}), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) != 0) {
            return null;
        }
        return ((DestinationFolderComboBox)this.destinationFolderCB).selectDirectory(targetPackage, false);
    }

    private boolean checkTargetFileName(String fileName) {
        if (FileTypeManager.getInstance().getFileTypeByFileName(fileName) == KotlinFileType.INSTANCE) {
            return true;
        }
        this.setErrorText("Can't move to non-Kotlin file");
        return false;
    }

    @NotNull
    private static List<PsiFile> getFilesExistingInTargetDir(@NotNull List<KtFile> sourceFiles, @Nullable String targetFileName, final @Nullable PsiDirectory targetDirectory) {
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "getFilesExistingInTargetDir"));
        }
        if (targetDirectory == null) {
            List<PsiFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "getFilesExistingInTargetDir"));
            }
            return list2;
        }
        List fileNames = targetFileName != null ? Collections.singletonList(targetFileName) : CollectionsKt.map(sourceFiles, (Function1)new Function1<KtFile, String>(){

            public String invoke(KtFile jetFile) {
                return jetFile.getName();
            }
        });
        List list3 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.map((Iterable)fileNames, (Function1)new Function1<String, PsiFile>(){

            public PsiFile invoke(String s) {
                return targetDirectory.findFile(s);
            }
        }));
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "getFilesExistingInTargetDir"));
        }
        return list3;
    }

    @Nullable
    private KotlinMoveTarget selectMoveTarget() {
        PsiDirectory psiDirectory;
        String message2 = this.verifyBeforeRun();
        if (message2 != null) {
            this.setErrorText(message2);
            return null;
        }
        this.setErrorText(null);
        List<KtFile> sourceFiles = MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(this.getSelectedElementsToMove());
        PsiDirectory sourceDirectory = MoveKotlinTopLevelDeclarationsDialog.getSourceDirectory(sourceFiles);
        if (this.isMoveToPackage()) {
            String targetFileName;
            final MoveDestination moveDestination = this.selectPackageBasedMoveDestination(true);
            if (moveDestination == null) {
                return null;
            }
            String string = targetFileName = sourceFiles.size() > 1 ? null : this.tfFileNameInPackage.getText();
            if (targetFileName != null && !this.checkTargetFileName(targetFileName)) {
                return null;
            }
            PsiDirectory targetDirectory = moveDestination.getTargetIfExists(sourceDirectory);
            List<PsiFile> filesExistingInTargetDir = MoveKotlinTopLevelDeclarationsDialog.getFilesExistingInTargetDir(sourceFiles, targetFileName, targetDirectory);
            if (!filesExistingInTargetDir.isEmpty()) {
                if (!CollectionsKt.intersect(sourceFiles, filesExistingInTargetDir).isEmpty()) {
                    this.setErrorText("Can't move to the original file(s)");
                    return null;
                }
                if (filesExistingInTargetDir.size() > 1) {
                    String filePathsToReport = StringUtil.join(filesExistingInTargetDir, (Function)new Function<PsiFile, String>(){

                        public String fun(PsiFile file) {
                            return file.getVirtualFile().getPath();
                        }
                    }, (String)"\n");
                    Messages.showErrorDialog((Project)this.myProject, (String)("Cannot perform refactoring since the following files already exist:\n\n" + filePathsToReport), (String)RefactoringBundle.message((String)"move.title"));
                    return null;
                }
                String question = String.format("File '%s' already exists. Do you want to move selected declarations to this file?", filesExistingInTargetDir.get(0).getVirtualFile().getPath());
                int ret = Messages.showYesNoDialog((Project)this.myProject, (String)question, (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon());
                if (ret != 0) {
                    return null;
                }
            }
            return new KotlinMoveTargetForDeferredFile(new FqName(this.getTargetPackage()), moveDestination.getTargetIfExists((PsiFile)sourceFiles.get(0)), (Function1<? super KtFile, ? extends KtFile>)new Function1<KtFile, KtFile>(){

                public KtFile invoke(@NotNull KtFile originalFile) {
                    if (originalFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$17", "invoke"));
                    }
                    return JetRefactoringUtilKt.getOrCreateKotlinFile(targetFileName != null ? targetFileName : originalFile.getName(), moveDestination.getTargetDirectory((PsiFile)originalFile));
                }
            });
        }
        final File targetFile = new File(this.getTargetFilePath());
        if (!this.checkTargetFileName(targetFile.getName())) {
            return null;
        }
        KtFile jetFile = (KtFile)JetRefactoringUtilKt.toPsiFile(targetFile, this.myProject);
        if (jetFile != null) {
            if (sourceFiles.size() == 1 && sourceFiles.contains(jetFile)) {
                this.setErrorText("Can't move to the original file");
                return null;
            }
            return new KotlinMoveTargetForExistingElement(jetFile);
        }
        File targetDir = targetFile.getParentFile();
        PsiDirectory psiDirectory2 = psiDirectory = targetDir != null ? JetRefactoringUtilKt.toPsiDirectory(targetDir, this.myProject) : null;
        if (psiDirectory == null) {
            this.setErrorText("No directory found for file: " + targetFile.getPath());
            return null;
        }
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
        if (psiPackage == null) {
            this.setErrorText("Could not find package corresponding to " + targetDir.getPath());
            return null;
        }
        return new KotlinMoveTargetForDeferredFile(new FqName(psiPackage.getQualifiedName()), psiDirectory, (Function1<? super KtFile, ? extends KtFile>)new Function1<KtFile, KtFile>(){

            public KtFile invoke(@NotNull KtFile originalFile) {
                if (originalFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$18", "invoke"));
                }
                return JetRefactoringUtilKt.getOrCreateKotlinFile(targetFile.getName(), psiDirectory);
            }
        });
    }

    @Nullable
    private String verifyBeforeRun() {
        if (this.memberTable.getSelectedMemberInfos().isEmpty()) {
            return "At least one member must be selected";
        }
        if (this.isMoveToPackage()) {
            String name2 = this.getTargetPackage();
            if (name2.length() != 0 && !PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(name2)) {
                return "'" + name2 + "' is invalid destination package name";
            }
        } else {
            PsiFile targetFile = JetRefactoringUtilKt.toPsiFile(new File(this.getTargetFilePath()), this.myProject);
            if (targetFile != null && !(targetFile instanceof KtFile)) {
                return KotlinRefactoringBundle.message("refactoring.move.non.kotlin.file", new Object[0]);
            }
        }
        if (MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(this.getSelectedElementsToMove()).size() == 1 && this.tfFileNameInPackage.getText().isEmpty()) {
            return "File name may not be empty";
        }
        return null;
    }

    private List<KtNamedDeclaration> getSelectedElementsToMove() {
        return CollectionsKt.map((Iterable)this.memberTable.getSelectedMemberInfos(), (Function1)new Function1<KotlinMemberInfo, KtNamedDeclaration>(){

            public KtNamedDeclaration invoke(KotlinMemberInfo info) {
                return (KtNamedDeclaration)info.getMember();
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    protected final String getTargetPackage() {
        return this.classPackageChooser.getText().trim();
    }

    protected final String getTargetFilePath() {
        return this.fileChooser.getText();
    }

    protected void canRun() throws ConfigurationException {
        String message2 = this.verifyBeforeRun();
        if (message2 != null) {
            throw new ConfigurationException(message2);
        }
    }

    protected void doAction() {
        KotlinMoveTarget target = this.selectMoveTarget();
        if (target == null) {
            return;
        }
        this.saveRefactoringSettings();
        List<KtNamedDeclaration> elementsToMove = this.getSelectedElementsToMove();
        final List<KtFile> sourceFiles = MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(elementsToMove);
        final PsiDirectory sourceDirectory = MoveKotlinTopLevelDeclarationsDialog.getSourceDirectory(sourceFiles);
        for (KtNamedDeclaration element2 : elementsToMove) {
            String message2 = target.verify(element2.getContainingFile());
            if (message2 == null) continue;
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)message2, null, (Project)this.myProject);
            return;
        }
        try {
            boolean deleteSourceFile = false;
            if (this.isFullFileMove()) {
                int ret;
                if (this.isMoveToPackage()) {
                    final MoveDestination moveDestination = this.selectPackageBasedMoveDestination(false);
                    PsiDirectory targetDir = moveDestination.getTargetIfExists(sourceDirectory);
                    final String targetFileName = sourceFiles.size() > 1 ? null : this.tfFileNameInPackage.getText();
                    List<PsiFile> filesExistingInTargetDir = MoveKotlinTopLevelDeclarationsDialog.getFilesExistingInTargetDir(sourceFiles, targetFileName, targetDir);
                    if (filesExistingInTargetDir.isEmpty()) {
                        PsiDirectory targetDirectory = ApplicationUtilsKt.runWriteAction(new Function0<PsiDirectory>(){

                            public PsiDirectory invoke() {
                                return moveDestination.getTargetDirectory(sourceDirectory);
                            }
                        });
                        for (KtFile sourceFile : sourceFiles) {
                            MoveUtilsKt.setUpdatePackageDirective(sourceFile, this.cbUpdatePackageDirective.isSelected());
                        }
                        this.invokeRefactoring((BaseRefactoringProcessor)new MoveFilesOrDirectoriesProcessor(this.myProject, sourceFiles.toArray(new PsiElement[sourceFiles.size()]), targetDirectory, true, this.isSearchInComments(), this.isSearchInNonJavaFiles(), new MoveCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void refactoringCompleted() {
                                try {
                                    if (targetFileName != null) {
                                        ((KtFile)CollectionsKt.single((List)sourceFiles)).setName(targetFileName);
                                    }
                                }
                                finally {
                                    if (MoveKotlinTopLevelDeclarationsDialog.this.moveCallback != null) {
                                        MoveKotlinTopLevelDeclarationsDialog.this.moveCallback.refactoringCompleted();
                                    }
                                }
                            }
                        }, EmptyRunnable.INSTANCE){

                            protected String getCommandName() {
                                return targetFileName != null ? "Move " + ((KtFile)CollectionsKt.single((List)sourceFiles)).getName() : "Move";
                            }

                            protected void performRefactoring(@NotNull UsageInfo[] usages2) {
                                if (usages2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$22", "performRefactoring"));
                                }
                                if (targetFileName != null) {
                                    KtFile sourceFile = (KtFile)CollectionsKt.single((List)sourceFiles);
                                    String temporaryName = UniqueNameGenerator.generateUniqueName((String)"temp", (String)"", (String)".kt", (Collection)ArraysKt.map((Object[])sourceFile.getContainingDirectory().getFiles(), (Function1)new Function1<PsiFile, String>(){

                                        public String invoke(PsiFile file) {
                                            return file.getName();
                                        }
                                    }));
                                    sourceFile.setName(temporaryName);
                                }
                                super.performRefactoring(usages2);
                            }
                        });
                        return;
                    }
                }
                if ((ret = Messages.showYesNoCancelDialog((Project)this.myProject, (String)"You are about to move all declarations out of the source file(s). Do you want to delete empty files?", (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) == 2) {
                    return;
                }
                deleteSourceFile = ret == 0;
            }
            MoveDeclarationsDescriptor options = new MoveDeclarationsDescriptor(elementsToMove, target, MoveDeclarationsDelegate.TopLevel.INSTANCE, this.isSearchInComments(), this.isSearchInNonJavaFiles(), true, deleteSourceFile, this.moveCallback, false);
            this.invokeRefactoring(new MoveKotlinDeclarationsProcessor(this.myProject, options, Mover.Default.INSTANCE));
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)this.myProject);
        }
    }

    private boolean isSearchInNonJavaFiles() {
        return this.cbSearchTextOccurrences.isSelected();
    }

    private boolean isSearchInComments() {
        return this.cbSearchInComments.isSelected();
    }

    private boolean isMoveToPackage() {
        return this.rbMoveToPackage.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classPackageChooser.getChildComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "Center");
        this.memberInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "South");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(6, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.classPackageChooser;
        jPanel6.add((Component)referenceEditorComboWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToPackage = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("To package:");
        jRadioButton2.setMnemonic('A');
        jRadioButton2.setDisplayedMnemonicIndex(4);
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.fileChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToFile = jRadioButton = new JRadioButton();
        jRadioButton.setText("To file:");
        jRadioButton.setMnemonic('F');
        jRadioButton.setDisplayedMnemonicIndex(3);
        jPanel6.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tfFileNameInPackage = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel6.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.cbSpecifyFileNameInPackage = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("File name:");
        jCheckBox2.setMnemonic('N');
        jCheckBox2.setDisplayedMnemonicIndex(5);
        jCheckBox2.setHorizontalAlignment(2);
        jCheckBox2.setHorizontalTextPosition(11);
        jPanel6.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 0, null, null, null, 5));
        this.targetPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 5));
        JLabel jLabel = new JLabel();
        jLabel.setText("Destination directory:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.destinationFolderCB;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.cbUpdatePackageDirective = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Update package directive");
        jCheckBox.setMnemonic('U');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null, 5));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.cbSearchInComments = nonFocusableCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        nonFocusableCheckBox.setSelected(true);
        jPanel7.add((Component)nonFocusableCheckBox, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.cbSearchTextOccurrences = nonFocusableCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        nonFocusableCheckBox2.setSelected(true);
        jPanel7.add((Component)nonFocusableCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MemberInfoModelImpl
    extends AbstractMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> {
        private MemberInfoModelImpl() {
        }
    }
}

