/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;

public class KtFileStubBuilder
extends DefaultStubBuilder {
    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/psi/stubs/elements/KtFileStubBuilder", "createStubForFile"));
        }
        if (!(file instanceof KtFile)) {
            StubElement stubElement = super.createStubForFile(file);
            if (stubElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtFileStubBuilder", "createStubForFile"));
            }
            return stubElement;
        }
        KotlinFileStub kotlinFileStub = StubIndexService.getInstance().createFileStub((KtFile)file);
        if (kotlinFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtFileStubBuilder", "createStubForFile"));
        }
        return kotlinFileStub;
    }
}

