/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;

public class TraceBasedRedeclarationHandler
implements RedeclarationHandler {
    private final BindingTrace trace;

    public TraceBasedRedeclarationHandler(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/TraceBasedRedeclarationHandler", "<init>"));
        }
        this.trace = trace;
    }

    @Override
    public void handleRedeclaration(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/resolve/TraceBasedRedeclarationHandler", "handleRedeclaration"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/kotlin/resolve/TraceBasedRedeclarationHandler", "handleRedeclaration"));
        }
        this.reportRedeclaration(first);
        this.reportRedeclaration(second);
    }

    @Override
    public void handleConflictingOverloads(@NotNull CallableMemberDescriptor first, @NotNull CallableMemberDescriptor second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/resolve/TraceBasedRedeclarationHandler", "handleConflictingOverloads"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/kotlin/resolve/TraceBasedRedeclarationHandler", "handleConflictingOverloads"));
        }
        this.reportConflictingOverloads(first, second.getContainingDeclaration());
        this.reportConflictingOverloads(second, first.getContainingDeclaration());
    }

    private void reportConflictingOverloads(CallableMemberDescriptor conflicting, DeclarationDescriptor withContainedIn) {
        PsiElement reportElement = DescriptorToSourceUtils.descriptorToDeclaration(conflicting);
        if (reportElement == null) {
            throw new IllegalStateException("No declaration found for " + conflicting);
        }
        this.trace.report(Errors.CONFLICTING_OVERLOADS.on(reportElement, conflicting, withContainedIn));
    }

    private void reportRedeclaration(DeclarationDescriptor descriptor2) {
        PsiElement firstElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (firstElement == null) {
            throw new IllegalStateException("No declaration found for " + descriptor2);
        }
        this.trace.report(Errors.REDECLARATION.on(firstElement, descriptor2.getName().asString()));
    }
}

