/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.JUnit4ReflectionUtil;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.Packet;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import java.util.ArrayList;
import org.junit.runner.Description;

public class JUnit4OutputObjectRegistry
extends OutputObjectRegistry {
    public JUnit4OutputObjectRegistry(PacketProcessor mainTransport, int lastIndex) {
        super(mainTransport, lastIndex);
    }

    protected int getTestCont(Object test) {
        return ((Description)test).testCount();
    }

    protected void addStringRepresentation(Object obj, Packet packet) {
        Description test = (Description)obj;
        if (test.isTest()) {
            String methodName = JUnit4ReflectionUtil.getMethodName(test);
            String className = JUnit4ReflectionUtil.getClassName(test);
            if (methodName != null && methodName.length() > 0) {
                OutputObjectRegistry.addTestMethod((Packet)packet, (String)methodName, (String)className);
            } else {
                OutputObjectRegistry.addTestClass((Packet)packet, (String)className);
            }
        } else if (test.isSuite()) {
            String fullName = JUnit4ReflectionUtil.getClassName(test);
            if (fullName == null) {
                this.addUnknownTest(packet, test);
                return;
            }
            OutputObjectRegistry.addTestClass((Packet)packet, (String)fullName);
        } else {
            this.addUnknownTest(packet, test);
        }
    }

    protected Object createObjectWrapper(Object object) {
        return new ObjectWrapper(object);
    }

    private static class ObjectWrapper {
        private Object myObject;

        private ObjectWrapper(Object object) {
            this.myObject = object;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectWrapper that = (ObjectWrapper)o;
            if (!this.myObject.equals(that.myObject)) {
                return false;
            }
            if (this.myObject instanceof Description && that.myObject instanceof Description) {
                ArrayList children = ((Description)this.myObject).getChildren();
                ArrayList thatChildren = ((Description)that.myObject).getChildren();
                if (children.size() != thatChildren.size()) {
                    return false;
                }
                int childrenSize = children.size();
                for (int i = 0; i < childrenSize; ++i) {
                    if (children.get(i).equals(thatChildren.get(i))) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int hash = this.myObject.hashCode();
            if (this.myObject instanceof Description) {
                ArrayList children = ((Description)this.myObject).getChildren();
                int childrenSize = children.size();
                for (int i = 0; i < childrenSize; ++i) {
                    hash = 31 * hash + children.get(i).hashCode();
                }
            }
            return hash;
        }
    }
}

