/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class TitlePanel
extends JPanel {
    public TitlePanel(String title, String description) {
        super(new BorderLayout());
        JLabel label = new JLabel(title);
        this.add((Component)label, "North");
        label.setOpaque(false);
        Font font = label.getFont();
        label.setFont(font.deriveFont(1, font.getSize() + 2));
        if (description != null) {
            label.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
            JLabel descriptionLabel = new JLabel(description);
            descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.add((Component)descriptionLabel, "Center");
        } else {
            label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getSize().width;
        int height = this.getSize().height;
        Object oldAntialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint((Paint)new JBColor((Color)Gray._247, UIUtil.getPanelBackground()));
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, 0.0, 0.0);
        g2.fill(rect);
        g2.setPaint((Paint)new JBColor(Color.GRAY, (Color)Gray._100));
        UIUtil.drawLine((Graphics)g2, (int)0, (int)(height - 1), (int)(width - 1), (int)(height - 1));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
    }
}

