/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.model.Property;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyWithNamespace
extends Property<RadViewComponent> {
    public PropertyWithNamespace(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/PropertyWithNamespace", "<init>"));
        }
        super(parent, name);
    }

    protected abstract String getAttributeName();

    public String getNamespace(RadViewComponent component, boolean createNamespaceIfNecessary) {
        String attributeName = this.getAttributeName();
        XmlTag tag = component.getTag();
        boolean isLayoutParam = attributeName.startsWith("layout_");
        if (isLayoutParam) {
            tag = tag.getParentTag();
        }
        if (tag != null) {
            AndroidFacet facet;
            String tagName = tag.getName();
            if ("view".equals(tagName)) {
                tagName = tag.getAttributeValue("class");
            }
            if (tagName != null && tagName.indexOf(46) != -1 && (facet = AndroidFacet.getInstance((PsiElement)tag)) != null) {
                StyleableDefinition styleable;
                LocalResourceManager resourceManager = facet.getLocalResourceManager();
                String styleableName = tagName.substring(tagName.lastIndexOf(46) + 1);
                if (isLayoutParam) {
                    styleableName = styleableName + "_Layout";
                }
                if ((styleable = resourceManager.getAttributeDefinitions().getStyleableByName(styleableName)) != null) {
                    for (AttributeDefinition def : styleable.getAttributes()) {
                        XmlFile file;
                        if (!def.getName().equals(attributeName)) continue;
                        String namespace = "http://schemas.android.com/apk/res-auto";
                        if (createNamespaceIfNecessary && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlFile.class)) != null) {
                            SuppressLintIntentionAction.ensureNamespaceImported(facet.getModule().getProject(), file, namespace);
                        }
                        return namespace;
                    }
                }
            }
        }
        return "http://schemas.android.com/apk/res/android";
    }
}

