/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class TypeParameterListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.TypeParameterListElement");
    private static final TokenSet TYPE_PARAMETER_SET = TokenSet.create(JavaElementType.TYPE_PARAMETER);

    public TypeParameterListElement() {
        super(JavaElementType.TYPE_PARAMETER_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType elType = child.getElementType();
        if (elType == JavaElementType.TYPE_PARAMETER) {
            return 244;
        }
        if (elType == JavaTokenType.COMMA) {
            return 23;
        }
        if (elType == JavaTokenType.LT) {
            return 121;
        }
        if (elType == JavaTokenType.GT) {
            return 122;
        }
        return 0;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        TreeElement gt;
        TreeElement lt = (TreeElement)this.findChildByRole(121);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (lt == null) {
            lt = Factory.createSingleLeafElement(JavaTokenType.LT, "<", 0, 1, treeCharTab, this.getManager());
            super.addInternal(lt, lt, this.getFirstChildNode(), Boolean.TRUE);
        }
        if ((gt = (TreeElement)this.findChildByRole(122)) == null) {
            gt = Factory.createSingleLeafElement(JavaTokenType.GT, ">", 0, 1, treeCharTab, this.getManager());
            super.addInternal(gt, gt, this.getLastChildNode(), Boolean.FALSE);
        }
        if (anchor2 == null) {
            if (before == null || before.booleanValue()) {
                anchor2 = gt;
                before = Boolean.TRUE;
            } else {
                anchor2 = lt;
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor2, before);
        if (first == last && first.getElementType() == JavaElementType.TYPE_PARAMETER) {
            JavaSourceUtil.addSeparatingComma(this, first, TYPE_PARAMETER_SET);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode lt;
        ASTNode next;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/TypeParameterListElement", "deleteChildInternal"));
        }
        if (child.getElementType() == JavaElementType.TYPE_PARAMETER) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        super.deleteChildInternal(child);
        if (child.getElementType() == JavaElementType.TYPE_PARAMETER && (next = PsiImplUtil.skipWhitespaceAndComments((lt = this.findChildByRole(121)).getTreeNext())) != null && next.getElementType() == JavaTokenType.GT) {
            this.deleteChildInternal(lt);
            this.deleteChildInternal(next);
        }
    }
}

