/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleChooserUtil {
    private static final String GROOVY_LAST_MODULE = "Groovy.Last.Module.Chosen";

    public static void selectModule(@NotNull Project project, Collection<Module> suitableModules, Function<Module, String> versionProvider, Consumer<Module> callback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/util/ModuleChooserUtil", "selectModule"));
        }
        ModuleChooserUtil.selectModule(project, suitableModules, versionProvider, callback, null);
    }

    public static void selectModule(@NotNull Project project, Collection<Module> suitableModules, Function<Module, String> versionProvider, final Consumer<Module> callback, @Nullable DataContext context) {
        int defaultOption;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/util/ModuleChooserUtil", "selectModule"));
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        final HashMap<Module, Object> versions = new HashMap<Module, Object>();
        for (Module module : suitableModules) {
            modules.add(module);
            versions.put(module, versionProvider.fun((Object)module));
        }
        if (modules.size() == 1) {
            callback.consume(modules.get(0));
            return;
        }
        Collections.sort(modules, ModulesAlphaComparator.INSTANCE);
        BaseListPopupStep<Module> step = new BaseListPopupStep<Module>("Which module to use classpath of?", modules, PlatformIcons.CONTENT_ROOT_ICON_CLOSED){

            @NotNull
            public String getTextFor(Module value) {
                String string = String.format("%s (%s)", value.getName(), versions.get(value));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/ModuleChooserUtil$1", "getTextFor"));
                }
                return string;
            }

            public String getIndexedString(Module value) {
                return value.getName();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(Module selectedValue, boolean finalChoice) {
                PropertiesComponent.getInstance((Project)selectedValue.getProject()).setValue(ModuleChooserUtil.GROOVY_LAST_MODULE, selectedValue.getName());
                callback.consume((Object)selectedValue);
                return null;
            }
        };
        final String lastModuleName = PropertiesComponent.getInstance((Project)project).getValue(GROOVY_LAST_MODULE);
        if (lastModuleName != null && (defaultOption = ContainerUtil.indexOf(modules, (Condition)new Condition<Module>(){

            public boolean value(Module module) {
                return module.getName().equals(lastModuleName);
            }
        })) >= 0) {
            step.setDefaultOptionIndex(defaultOption);
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (context == null) {
            listPopup.showCenteredInCurrentWindow(project);
        } else {
            listPopup.showInBestPositionFor(context);
        }
    }

    @NotNull
    private static Condition<Module> isGroovyCompatibleModule(final Condition<Module> condition) {
        Condition<Module> condition2 = new Condition<Module>(){

            public boolean value(Module module) {
                Sdk sdk;
                return condition.value((Object)module) && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && sdk.getSdkType() instanceof JavaSdkType;
            }
        };
        if (condition2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/ModuleChooserUtil", "isGroovyCompatibleModule"));
        }
        return condition2;
    }

    public static List<Module> filterGroovyCompatibleModules(Collection<Module> modules, Condition<Module> condition) {
        return ContainerUtil.filter(modules, ModuleChooserUtil.isGroovyCompatibleModule(condition));
    }

    public static boolean hasGroovyCompatibleModules(Collection<Module> modules, Condition<Module> condition) {
        return ContainerUtil.or(modules, ModuleChooserUtil.isGroovyCompatibleModule(condition));
    }
}

