/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RepositoryAuthenticationForm
extends DialogWrapper {
    private static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");
    private static final SimpleTextAttributes LINK_TEXT_ATTRIBUTES = new SimpleTextAttributes(128, (Color)JBColor.blue);
    private static final SimpleTextAttributes SMALL_TEXT_ATTRIBUTES = new SimpleTextAttributes(128, null);
    private JTextField tokenField;
    private SimpleColoredComponent noteComponent;
    private JPasswordField passwordField;
    private JPanel panel;
    private JLabel tokenLabel;
    private JLabel messageLabel;
    private final JComponent initialFocusedComponent;

    public RepositoryAuthenticationForm(@NotNull String message, @Nullable String token, @Nullable String password, @Nullable String note, boolean onlyPassword) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/settingsRepository/RepositoryAuthenticationForm", "<init>"));
        }
        super(false);
        this.$$$setupUI$$$();
        this.setTitle("Settings Repository");
        this.setResizable(false);
        this.messageLabel.setText(message);
        this.messageLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        if (onlyPassword) {
            this.tokenLabel.setVisible(false);
            this.tokenField.setVisible(false);
            this.passwordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    RepositoryAuthenticationForm.this.setOKActionEnabled(e.getDocument().getLength() != 0);
                }
            });
            this.initialFocusedComponent = this.passwordField;
            this.setOKActionEnabled(false);
        } else {
            this.tokenField.setText(token);
            this.passwordField.setText(password);
            JComponent jComponent = this.initialFocusedComponent = StringUtil.isEmpty((String)token) ? this.tokenField : this.passwordField;
        }
        if (note == null) {
            this.noteComponent.setVisible(false);
        } else {
            Matcher matcher = HREF_PATTERN.matcher(note);
            int prev = 0;
            if (matcher.find()) {
                do {
                    if (matcher.start() != prev) {
                        this.noteComponent.append(note.substring(prev, matcher.start()), SMALL_TEXT_ATTRIBUTES);
                    }
                    this.noteComponent.append(matcher.group(2), LINK_TEXT_ATTRIBUTES, (Object)new SimpleColoredComponent.BrowserLauncherTag(matcher.group(1)));
                    prev = matcher.end();
                } while (matcher.find());
                LinkMouseListenerBase.installSingleTagOn((SimpleColoredComponent)this.noteComponent);
            }
            if (prev < note.length()) {
                this.noteComponent.append(note.substring(prev), SMALL_TEXT_ATTRIBUTES);
            }
        }
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.initialFocusedComponent;
    }

    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @Nullable
    public String getUsername() {
        return StringUtil.nullize((String)this.tokenField.getText(), (boolean)true);
    }

    @Nullable
    public char[] getPassword() {
        char[] chars = this.passwordField.getPassword();
        return chars == null || chars.length == 0 ? null : chars;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        SimpleColoredComponent simpleColoredComponent;
        JPasswordField jPasswordField;
        JLabel jLabel2;
        JTextField jTextField;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.tokenField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.tokenLabel = jLabel2 = new JLabel();
        jLabel2.setText("Username:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Password:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.passwordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.noteComponent = simpleColoredComponent = new SimpleColoredComponent();
        simpleColoredComponent.setIpad(new Insets(5, 2, 1, 2));
        jPanel.add((Component)simpleColoredComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.messageLabel = jLabel = new JLabel();
        jLabel.setText("Message");
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        ((Component)jLabel).setEnabled(true);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

