/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0019\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkotlin/reflect/jvm/internal/ReflectionObjectRenderer;", "", "()V", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderCallable", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "renderFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "renderParameter", "parameter", "Lkotlin/reflect/jvm/internal/KParameterImpl;", "renderProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "renderType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "appendReceiverType", "", "Ljava/lang/StringBuilder;", "receiver", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "appendReceiversAndName", "callable", "kotlin-reflection"})
public final class ReflectionObjectRenderer {
    private static final DescriptorRenderer renderer;
    public static final ReflectionObjectRenderer INSTANCE;

    private final void appendReceiverType(StringBuilder $receiver, ReceiverParameterDescriptor receiver) {
        if (receiver != null) {
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiver.type");
            $receiver.append(this.renderType(kotlinType));
            $receiver.append(".");
        }
    }

    private final void appendReceiversAndName(StringBuilder $receiver, CallableDescriptor callable) {
        boolean addParentheses;
        ReceiverParameterDescriptor dispatchReceiver = callable.getDispatchReceiverParameter();
        ReceiverParameterDescriptor extensionReceiver = callable.getExtensionReceiverParameter();
        this.appendReceiverType($receiver, dispatchReceiver);
        boolean bl = addParentheses = dispatchReceiver != null && extensionReceiver != null;
        if (addParentheses) {
            $receiver.append("(");
        }
        this.appendReceiverType($receiver, extensionReceiver);
        if (addParentheses) {
            $receiver.append(")");
        }
        Name name = callable.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "callable.name");
        $receiver.append(renderer.renderName(name));
    }

    @NotNull
    public final String renderCallable(@NotNull CallableDescriptor descriptor2) {
        String string;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        CallableDescriptor callableDescriptor = descriptor2;
        if (callableDescriptor instanceof PropertyDescriptor) {
            string = this.renderProperty((PropertyDescriptor)descriptor2);
        } else if (callableDescriptor instanceof FunctionDescriptor) {
            string = this.renderFunction((FunctionDescriptor)descriptor2);
        } else {
            String message$iv = "Illegal callable: " + descriptor2;
            throw (Throwable)new IllegalStateException(message$iv.toString());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderProperty(@NotNull PropertyDescriptor descriptor2) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        $receiver.append(descriptor2.isVar() ? "var " : "val ");
        INSTANCE.appendReceiversAndName($receiver, descriptor2);
        $receiver.append(": ");
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.type");
        $receiver.append(INSTANCE.renderType(kotlinType));
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderFunction(@NotNull FunctionDescriptor descriptor2) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        $receiver.append("fun ");
        INSTANCE.appendReceiversAndName($receiver, descriptor2);
        CollectionsKt.joinTo$default(descriptor2.getValueParameters(), $receiver, ", ", "(", ")", 0, null, renderFunction.1.1.INSTANCE, 48, null);
        $receiver.append(": ");
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.returnType!!");
        $receiver.append(INSTANCE.renderType(kotlinType));
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderParameter(@NotNull KParameterImpl parameter) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        switch (ReflectionObjectRenderer$WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
            case 1: {
                $receiver.append("extension receiver");
                break;
            }
            case 2: {
                $receiver.append("instance");
                break;
            }
            case 3: {
                $receiver.append("parameter #" + parameter.getIndex() + " " + parameter.getName());
            }
        }
        $receiver.append(" of ");
        $receiver.append(INSTANCE.renderCallable(parameter.getCallable().getDescriptor()));
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return renderer.renderType(type2);
    }

    private ReflectionObjectRenderer() {
        INSTANCE = this;
        renderer = DescriptorRenderer.FQ_NAMES_IN_TYPES;
    }

    static {
        new ReflectionObjectRenderer();
    }
}

