/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseKotlinCompilerSettings<T>
implements PersistentStateComponent<Element> {
    public static final String KOTLIN_COMPILER_SETTINGS_PATH = "$PROJECT_CONFIG_DIR$/kotlinc.xml";
    private static final SkipDefaultValuesSerializationFilters SKIP_DEFAULT_VALUES = new SkipDefaultValuesSerializationFilters();
    @NotNull
    private T settings = this.createSettings();

    protected BaseKotlinCompilerSettings() {
    }

    @NotNull
    public T getSettings() {
        T t = this.settings;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/BaseKotlinCompilerSettings", "getSettings"));
        }
        return t;
    }

    @NotNull
    protected abstract T createSettings();

    public Element getState() {
        return XmlSerializer.serialize(this.settings, (SerializationFilter)SKIP_DEFAULT_VALUES);
    }

    public void loadState(Element state) {
        Object newSettings = XmlSerializer.deserialize((Element)state, this.settings.getClass());
        if (newSettings == null) {
            newSettings = this.createSettings();
        }
        this.settings = newSettings;
    }

    @Nullable
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

