/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ConfigureDeviceOptionsStep;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.SingleStepDialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.SingleStepWizard;
import com.intellij.openapi.ui.DialogWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceEditWizard
extends SingleStepWizard {
    public DeviceEditWizard(@Nullable Device deviceTemplate, boolean forceCreation) {
        super(null, null, new ConfigureDeviceOptionsStep(deviceTemplate, forceCreation, null), (DynamicWizardHost)new SingleStepDialogWrapperHost(null, DialogWrapper.IdeModalityType.PROJECT));
        this.setTitle("Hardware Profile Configuration");
    }

    @Override
    public void performFinishingActions() {
        Device device = this.getState().get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        if (device != null) {
            DeviceManagerConnection.getDefaultDeviceManagerConnection().createOrEditDevice(device);
        }
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Creating/Updating device..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceEditWizard", "getProgressTitle"));
        }
        return "Creating/Updating device...";
    }

    @Nullable
    public Device getEditedDevice() {
        return this.getState().get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
    }

    @Override
    protected String getWizardActionDescription() {
        return "Create or edit a virtual device hardware profile";
    }
}

