/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import com.android.tools.idea.editors.gfxtrace.widgets.CellWidget;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JScrollBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public abstract class CellList<T extends CellWidget.Data>
extends CellWidget<T, JBScrollPane> {
    @NotNull
    private final JBList myList;

    public CellList(Orientation orientation, String emptyText, CellRenderer.CellLoader<T> loader) {
        super(CellList.createComponent(orientation, emptyText), loader);
        this.myList = (JBList)((JBScrollPane)this.myComponent).getViewport().getView();
        this.myList.setCellRenderer((ListCellRenderer)this.myRenderer);
        Dimension cellSize = this.myRenderer.getInitialCellSize();
        this.myList.setFixedCellWidth(cellSize.width);
        this.myList.setFixedCellHeight(cellSize.height);
    }

    private static JBScrollPane createComponent(Orientation orientation, String emptyText) {
        JBList list = new JBList();
        list.setLayoutOrientation(orientation.listWrap);
        list.setExpandableItemsEnabled(false);
        list.setVisibleRowCount(1);
        list.getEmptyText().setText(emptyText);
        JBScrollPane scrollPane = orientation.createScrollPane();
        scrollPane.setViewportView((Component)list);
        return scrollPane;
    }

    @Override
    public void setData(@NotNull List<T> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/editors/gfxtrace/widgets/CellList", "setData"));
        }
        super.setData(data);
        DefaultListModel<CellWidget.Data> model = new DefaultListModel<CellWidget.Data>();
        model.ensureCapacity(data.size());
        for (CellWidget.Data item : data) {
            model.addElement(item);
        }
        this.myList.setModel(model);
        if (data.size() == 0) {
            this.myList.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        }
    }

    @Override
    public int getSelectedItem() {
        return this.myList.getSelectedIndex();
    }

    @Override
    protected void addSelectionListener(JBScrollPane component, final CellWidget.SelectionListener<T> selectionListener) {
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object selectedValue;
                if (!listSelectionEvent.getValueIsAdjusting() && (selectedValue = CellList.this.myList.getSelectedValue()) != null) {
                    selectionListener.selected((CellWidget.Data)selectedValue);
                }
            }
        });
    }

    @Override
    protected void setSelectedIndex(JBScrollPane component, int index) {
        this.myList.setSelectedIndex(index);
        this.myList.scrollRectToVisible(this.myList.getCellBounds(index, index));
    }

    public static enum Orientation {
        HORIZONTAL(2),
        VERTICAL(1);

        public final int listWrap;

        private Orientation(int listWrap) {
            this.listWrap = listWrap;
        }

        @NotNull
        public JBScrollPane createScrollPane() {
            JBScrollPane jBScrollPane = this == VERTICAL ? new JBScrollPane() : new JBScrollPane(){
                {
                    final JScrollBar scrollBar = this.getHorizontalScrollBar();
                    this.setWheelScrollingEnabled(false);
                    this.addMouseWheelListener(new MouseAdapter(){

                        @Override
                        public void mouseWheelMoved(MouseWheelEvent evt) {
                            int scrollAmount = evt.getScrollAmount() * evt.getWheelRotation() * scrollBar.getBlockIncrement();
                            int position = Math.max(scrollBar.getMinimum(), Math.min(scrollBar.getMaximum(), scrollBar.getValue() + scrollAmount));
                            scrollBar.setValue(position);
                        }
                    });
                }
            };
            if (jBScrollPane == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/widgets/CellList$Orientation", "createScrollPane"));
            }
            return jBScrollPane;
        }
    }
}

