/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ExternalDependenciesUsageTracker {
    @NotNull
    private final Project myProject;

    ExternalDependenciesUsageTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ExternalDependenciesUsageTracker", "<init>"));
        }
        this.myProject = project;
    }

    void trackExternalDependenciesInAndroidApps() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)ExternalDependenciesUsageTracker.this.myProject);
                ExternalDependenciesUsageTracker.trackExternalDependenciesInAndroidApps(moduleManager.getModules());
            }
        });
    }

    private static void trackExternalDependenciesInAndroidApps(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/ExternalDependenciesUsageTracker", "trackExternalDependenciesInAndroidApps"));
        }
        for (Module module : modules) {
            AndroidProject androidProject;
            AndroidGradleModel androidModel = AndroidGradleModel.get(module);
            if (androidModel == null || (androidProject = androidModel.getAndroidProject()).isLibrary()) continue;
            ExternalDependenciesUsageTracker.trackExternalDependenciesInAndroidApp(androidProject);
        }
    }

    private static void trackExternalDependenciesInAndroidApp(@NotNull AndroidProject model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/project/ExternalDependenciesUsageTracker", "trackExternalDependenciesInAndroidApp"));
        }
        Collection variants = model.getVariants();
        if (variants.isEmpty()) {
            return;
        }
        Variant chosen = null;
        for (Variant variant : variants) {
            if (!"release".equals(variant.getBuildType())) continue;
            chosen = variant;
            break;
        }
        if (chosen == null) {
            chosen = (Variant)ContainerUtil.getFirstItem((Collection)variants);
        }
        if (chosen != null) {
            ExternalDependenciesUsageTracker.trackLibraryCount(chosen);
        }
    }

    private static void trackLibraryCount(@NotNull Variant variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/project/ExternalDependenciesUsageTracker", "trackLibraryCount"));
        }
        DependencyFiles files = new DependencyFiles();
        AndroidArtifact artifact = variant.getMainArtifact();
        String applicationId = artifact.getApplicationId();
        String id = Hashing.sha256().hashString((CharSequence)applicationId, Charsets.UTF_8).toString();
        Dependencies dependencies = artifact.getDependencies();
        for (JavaLibrary javaLibrary : dependencies.getJavaLibraries()) {
            ExternalDependenciesUsageTracker.addJarLibraryAndDependencies(javaLibrary, files);
        }
        for (AndroidLibrary androidLibrary : dependencies.getLibraries()) {
            ExternalDependenciesUsageTracker.addAarLibraryAndDependencies(androidLibrary, files);
        }
        UsageTracker.getInstance().trackLibraryCount(id, files.jars.size(), files.aars.size());
    }

    private static void addJarLibraryAndDependencies(@NotNull JavaLibrary javaLibrary, @NotNull DependencyFiles files) {
        if (javaLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaLibrary", "com/android/tools/idea/gradle/project/ExternalDependenciesUsageTracker", "addJarLibraryAndDependencies"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/gradle/project/ExternalDependenciesUsageTracker", "addJarLibraryAndDependencies"));
        }
        File jarFile = javaLibrary.getJarFile();
        if (files.jars.contains(jarFile)) {
            return;
        }
        files.jars.add(jarFile);
        for (JavaLibrary dependency : javaLibrary.getDependencies()) {
            ExternalDependenciesUsageTracker.addJarLibraryAndDependencies(dependency, files);
        }
    }

    private static void addAarLibraryAndDependencies(@NotNull AndroidLibrary androidLibrary, @NotNull DependencyFiles files) {
        if (androidLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidLibrary", "com/android/tools/idea/gradle/project/ExternalDependenciesUsageTracker", "addAarLibraryAndDependencies"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/gradle/project/ExternalDependenciesUsageTracker", "addAarLibraryAndDependencies"));
        }
        String gradlePath = androidLibrary.getProject();
        if (StringUtil.isEmpty((String)gradlePath)) {
            File file = androidLibrary.getJarFile();
            if (files.aars.contains(file)) {
                return;
            }
            files.aars.add(file);
            for (AndroidLibrary library : androidLibrary.getLibraryDependencies()) {
                ExternalDependenciesUsageTracker.addAarLibraryAndDependencies(library, files);
            }
        }
    }

    private static class DependencyFiles {
        final Set<File> aars = Sets.newHashSet();
        final Set<File> jars = Sets.newHashSet();

        private DependencyFiles() {
        }
    }
}

