/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibiltyChecker;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class AndroidDeviceRenderer
extends ColoredListCellRenderer<AndroidDevice> {
    private final LaunchCompatibiltyChecker myCompatibilityChecker;

    public AndroidDeviceRenderer(@NotNull LaunchCompatibiltyChecker checker) {
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/android/tools/idea/run/AndroidDeviceRenderer", "<init>"));
        }
        this.myCompatibilityChecker = checker;
    }

    protected void customizeCellRenderer(JList list, AndroidDevice device, int index, boolean selected, boolean hasFocus) {
        if (this.myCompatibilityChecker.validate(device).isCompatible() == ThreeState.NO) {
            this.append("[not compatible] ", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        device.renderName((ColoredTextContainer)this);
    }
}

