/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeEvent;
import org.jetbrains.android.facet.AndroidFacet;

public class ExternalPSIChangeListener
extends com.intellij.designer.designSurface.ExternalPSIChangeListener {
    private VirtualFile[] myResourceDepends;

    public ExternalPSIChangeListener(DesignerEditorPanel designer, PsiFile file, int delayMillis, Runnable runnable) {
        super(designer, file, delayMillis, runnable);
    }

    public void deactivate() {
        super.deactivate();
        if (!this.myDesigner.isProjectClosed()) {
            AndroidFacet facet = AndroidFacet.getInstance(this.myDesigner.getModule());
            this.myResourceDepends = facet == null ? null : facet.getLocalResourceManager().getAllResourceDirs();
        }
    }

    protected void updatePsi(PsiTreeChangeEvent event) {
        boolean runState = this.myRunState;
        super.updatePsi(event);
        if (!runState && this.myResourceDepends != null && !this.myUpdateRenderer) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile file = psiFile.getVirtualFile();
            if (file == null) {
                return;
            }
            for (VirtualFile resourceDir : this.myResourceDepends) {
                if (!VfsUtilCore.isAncestor((VirtualFile)resourceDir, (VirtualFile)file, (boolean)false)) continue;
                this.myUpdateRenderer = true;
                break;
            }
        }
    }
}

