/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

public class OptimizationBasicInterpreter
extends BasicInterpreter {
    private static final BasicValue BOOLEAN_VALUE = new BasicValue(Type.BOOLEAN_TYPE);
    private static final BasicValue CHAR_VALUE = new BasicValue(Type.CHAR_TYPE);
    private static final BasicValue BYTE_VALUE = new BasicValue(Type.BYTE_TYPE);
    private static final BasicValue SHORT_VALUE = new BasicValue(Type.SHORT_TYPE);

    @Nullable
    public BasicValue newValue(@Nullable Type type2) {
        if (type2 == null) {
            return super.newValue(null);
        }
        switch (type2.getSort()) {
            case 0: {
                return null;
            }
            case 1: {
                return BOOLEAN_VALUE;
            }
            case 2: {
                return CHAR_VALUE;
            }
            case 3: {
                return BYTE_VALUE;
            }
            case 4: {
                return SHORT_VALUE;
            }
            case 10: {
                return new BasicValue(type2);
            }
        }
        return super.newValue(type2);
    }

    public BasicValue newOperation(@NotNull AbstractInsnNode insn) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "newOperation"));
        }
        if (insn.getOpcode() == 18) {
            Object cst = ((LdcInsnNode)insn).cst;
            if (cst instanceof Long) {
                return BasicValue.LONG_VALUE;
            }
            if (cst instanceof Boolean || cst instanceof Integer || cst instanceof Short || cst instanceof Byte || cst instanceof Character) {
                return BasicValue.INT_VALUE;
            }
            if (cst instanceof Float) {
                return BasicValue.FLOAT_VALUE;
            }
            if (cst instanceof Double) {
                return BasicValue.DOUBLE_VALUE;
            }
        }
        return super.newOperation(insn);
    }

    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
        }
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
        }
        if (v == BasicValue.UNINITIALIZED_VALUE || w == BasicValue.UNINITIALIZED_VALUE) {
            BasicValue basicValue = BasicValue.UNINITIALIZED_VALUE;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
            }
            return basicValue;
        }
        if (v.getType().getSort() == w.getType().getSort() && (v.getType().getSort() != 10 || v.equals((Object)w))) {
            BasicValue basicValue = v;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
            }
            return basicValue;
        }
        if (v.getType().getSort() == 10 && w.getType().getSort() == 10) {
            BasicValue basicValue = BasicValue.REFERENCE_VALUE;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
            }
            return basicValue;
        }
        assert (v.getType().getSort() != 9 && w.getType().getSort() != 9) : "There should not be arrays";
        if (v.getType().getOpcode(54) == 54 && w.getType().getOpcode(54) == 54) {
            BasicValue basicValue = BasicValue.INT_VALUE;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
            }
            return basicValue;
        }
        BasicValue basicValue = BasicValue.UNINITIALIZED_VALUE;
        if (basicValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
        }
        return basicValue;
    }
}

