/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CollectionsUtilityMethodsProvider;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InheritorsHolder;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.impl.BetterPrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNoVariantsDelegator
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        boolean empty;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaNoVariantsDelegator", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JavaNoVariantsDelegator", "fillCompletionVariants"));
        }
        final InheritorsHolder holder = new InheritorsHolder(result);
        ResultTracker tracker = new ResultTracker(result){

            @Override
            public void consume(CompletionResult plainResult) {
                super.consume(plainResult);
                LookupElement element = plainResult.getLookupElement();
                Object o = element.getObject();
                if (o instanceof PsiClass) {
                    holder.registerClass((PsiClass)o);
                }
                if (element instanceof TypeArgumentCompletionProvider.TypeArgsLookupElement) {
                    ((TypeArgumentCompletionProvider.TypeArgsLookupElement)element).registerSingleClass(holder);
                }
            }
        };
        result.runRemainingContributors(parameters, (Consumer)tracker);
        boolean bl = empty = tracker.containsOnlyPackages || JavaNoVariantsDelegator.suggestAllAnnotations(parameters);
        if (!empty && parameters.getInvocationCount() == 0) {
            result.restartCompletionWhenNothingMatches();
        }
        if (empty) {
            JavaNoVariantsDelegator.delegate(parameters, JavaCompletionSorting.addJavaSorting(parameters, result), holder);
        } else if (Registry.is((String)"ide.completion.show.better.matching.classes") && parameters.getCompletionType() == CompletionType.BASIC && parameters.getInvocationCount() <= 1 && JavaCompletionContributor.mayStartClassName(result) && JavaCompletionContributor.isClassNamePossible(parameters) && !JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)parameters.getPosition())) {
            JavaNoVariantsDelegator.suggestNonImportedClasses(parameters, JavaCompletionSorting.addJavaSorting(parameters, result.withPrefixMatcher((PrefixMatcher)tracker.betterMatcher)), holder);
        }
    }

    private static boolean suggestAllAnnotations(CompletionParameters parameters) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).accepts((Object)parameters.getPosition());
    }

    private static void delegate(CompletionParameters parameters, CompletionResultSet result, InheritorsHolder inheritorsHolder) {
        if (parameters.getCompletionType() == CompletionType.BASIC) {
            PsiElement position = parameters.getPosition();
            JavaNoVariantsDelegator.suggestCollectionUtilities(parameters, result, position);
            if (parameters.getInvocationCount() <= 1 && (JavaCompletionContributor.mayStartClassName(result) || JavaNoVariantsDelegator.suggestAllAnnotations(parameters)) && JavaCompletionContributor.isClassNamePossible(parameters)) {
                JavaNoVariantsDelegator.suggestNonImportedClasses(parameters, result, inheritorsHolder);
                return;
            }
            JavaNoVariantsDelegator.suggestChainedCalls(parameters, result, position);
        }
        if (parameters.getCompletionType() == CompletionType.SMART && parameters.getInvocationCount() == 2) {
            result.runRemainingContributors(parameters.withInvocationCount(3), true);
        }
    }

    private static void suggestCollectionUtilities(CompletionParameters parameters, CompletionResultSet result, PsiElement position) {
        if (StringUtil.isNotEmpty((String)result.getPrefixMatcher().getPrefix())) {
            for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
                new CollectionsUtilityMethodsProvider(position, info.getType(), info.getDefaultType(), (Consumer<LookupElement>)result).addCompletions(true);
            }
        }
    }

    private static void suggestChainedCalls(CompletionParameters parameters, CompletionResultSet result, PsiElement position) {
        PsiElement parent = position.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement) || parent.getParent() instanceof PsiImportStatementBase) {
            return;
        }
        PsiElement qualifier = ((PsiJavaCodeReferenceElement)parent).getQualifier();
        if (!(qualifier instanceof PsiJavaCodeReferenceElement) || ((PsiJavaCodeReferenceElement)qualifier).isQualified()) {
            return;
        }
        PsiElement target = ((PsiJavaCodeReferenceElement)qualifier).resolve();
        if (target != null && !(target instanceof PsiPackage)) {
            return;
        }
        PsiFile file2 = position.getContainingFile();
        if (file2 instanceof PsiJavaCodeReferenceCodeFragment) {
            return;
        }
        String fullPrefix = parent.getText().substring(0, parameters.getOffset() - parent.getTextRange().getStartOffset());
        CompletionResultSet qualifiedCollector = result.withPrefixMatcher(fullPrefix);
        ElementFilter filter = JavaCompletionContributor.getReferenceFilter(position);
        for (LookupElement base : JavaNoVariantsDelegator.suggestQualifierItems(parameters, (PsiJavaCodeReferenceElement)qualifier, filter)) {
            PsiReferenceExpression ref;
            PsiType type = JavaCompletionUtil.getLookupElementType(base);
            if (type == null || PsiType.VOID.equals((Object)type) || (ref = ReferenceExpressionCompletionContributor.createMockReference(position, type, base)) == null) continue;
            for (LookupElement item : JavaSmartCompletionContributor.completeReference(position, (PsiJavaCodeReferenceElement)ref, filter, true, true, parameters, result.getPrefixMatcher())) {
                qualifiedCollector.addElement(JavaCompletionUtil.highlightIfNeeded(null, (LookupElement)new JavaChainLookupElement(base, item), item.getObject(), position));
            }
        }
    }

    private static Set<LookupElement> suggestQualifierItems(CompletionParameters parameters, PsiJavaCodeReferenceElement qualifier, ElementFilter filter) {
        String referenceName = qualifier.getReferenceName();
        if (referenceName == null) {
            return Collections.emptySet();
        }
        CamelHumpMatcher qMatcher = new CamelHumpMatcher(referenceName);
        Set<LookupElement> plainVariants = JavaSmartCompletionContributor.completeReference((PsiElement)qualifier, qualifier, filter, true, true, parameters, qMatcher);
        for (PsiClass aClass : PsiShortNamesCache.getInstance((Project)qualifier.getProject()).getClassesByName(referenceName, qualifier.getResolveScope())) {
            plainVariants.add((LookupElement)JavaClassNameCompletionContributor.createClassLookupItem(aClass, true));
        }
        if (!plainVariants.isEmpty()) {
            return plainVariants;
        }
        LinkedHashSet<LookupElement> allClasses = new LinkedHashSet<LookupElement>();
        PsiElement qualifierName = qualifier.getReferenceNameElement();
        if (qualifierName != null) {
            JavaClassNameCompletionContributor.addAllClasses(parameters.withPosition(qualifierName, qualifierName.getTextRange().getEndOffset()), true, qMatcher, (Consumer<LookupElement>)new CollectConsumer(allClasses));
        }
        return allClasses;
    }

    private static void suggestNonImportedClasses(final CompletionParameters parameters, final CompletionResultSet result, final @Nullable InheritorsHolder inheritorsHolder) {
        JavaClassNameCompletionContributor.addAllClasses(parameters, true, result.getPrefixMatcher(), new Consumer<LookupElement>(){

            public void consume(LookupElement element) {
                if (inheritorsHolder != null && inheritorsHolder.alreadyProcessed(element)) {
                    return;
                }
                JavaPsiClassReferenceElement classElement = (JavaPsiClassReferenceElement)element.as(JavaPsiClassReferenceElement.CLASS_CONDITION_KEY);
                if (classElement != null) {
                    classElement.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                    element = JavaClassNameCompletionContributor.highlightIfNeeded(classElement, parameters);
                }
                result.addElement(element);
            }
        });
    }

    public static class ResultTracker
    implements Consumer<CompletionResult> {
        private final CompletionResultSet myResult;
        public boolean containsOnlyPackages = true;
        public BetterPrefixMatcher betterMatcher;

        public ResultTracker(CompletionResultSet result) {
            this.myResult = result;
            this.betterMatcher = new BetterPrefixMatcher(result);
        }

        public void consume(CompletionResult plainResult) {
            this.myResult.passResult(plainResult);
            LookupElement element = plainResult.getLookupElement();
            if (this.containsOnlyPackages && !(CompletionUtil.getTargetElement(element) instanceof PsiPackage)) {
                this.containsOnlyPackages = false;
            }
            this.betterMatcher = this.betterMatcher.improve(plainResult);
        }
    }
}

