/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GutterIntentionAction
extends AbstractIntentionAction
implements Comparable<IntentionAction>,
Iconable,
ShortcutProvider {
    private final AnAction myAction;
    private final int myOrder;
    private final Icon myIcon;
    private String myText;

    private GutterIntentionAction(AnAction action, int order, Icon icon) {
        this.myAction = action;
        this.myOrder = order;
        this.myIcon = icon;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "invoke"));
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        this.myAction.actionPerformed(new AnActionEvent((InputEvent)relativePoint.toMouseEvent(), ((EditorEx)editor).getDataContext(), this.myText, new Presentation(), ActionManager.getInstance(), 0));
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "isAvailable"));
        }
        if (this.myText == null) {
            AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((EditorEx)editor).getDataContext());
            this.myAction.update(event);
            this.myText = event.getPresentation().getText();
            if (this.myText == null) {
                this.myText = this.myAction.getTemplatePresentation().getText();
            }
            if (this.myText == null) {
                this.myText = "";
            }
        }
        return StringUtil.isNotEmpty((String)this.myText);
    }

    @NotNull
    public String getText() {
        String string = StringUtil.notNullize((String)this.myText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "getText"));
        }
        return string;
    }

    static void addActions(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull RangeHighlighterEx info, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        GutterIconRenderer renderer = info.getGutterIconRenderer();
        if (renderer == null || DumbService.isDumb((Project)project2) && !DumbService.isDumbAware((Object)renderer)) {
            return;
        }
        ArrayList<HighlightInfo.IntentionActionDescriptor> list = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        GutterIntentionAction.addActions(project2, editor, psiFile, renderer.getClickAction(), list, renderer, 0);
        GutterIntentionAction.addActions(project2, editor, psiFile, renderer.getMiddleButtonClickAction(), list, renderer, 0);
        GutterIntentionAction.addActions(project2, editor, psiFile, renderer.getRightButtonClickAction(), list, renderer, 0);
        GutterIntentionAction.addActions(project2, editor, psiFile, (AnAction)renderer.getPopupMenuActions(), list, renderer, 0);
        if (list.isEmpty()) {
            return;
        }
        if (list.size() == 1) {
            descriptors.addAll(list);
        } else {
            HighlightInfo.IntentionActionDescriptor first = (HighlightInfo.IntentionActionDescriptor)list.get(0);
            List options = ContainerUtil.map(list.subList(1, list.size()), (Function)new Function<HighlightInfo.IntentionActionDescriptor, IntentionAction>(){

                public IntentionAction fun(HighlightInfo.IntentionActionDescriptor descriptor) {
                    return descriptor.getAction();
                }
            });
            descriptors.add(new HighlightInfo.IntentionActionDescriptor(first.getAction(), options, null, first.getIcon()));
        }
    }

    private static void addActions(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile psiFile, @Nullable AnAction action, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull GutterIconRenderer renderer, int order) {
        GutterIntentionAction gutterAction;
        Icon icon;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (action == null) {
            return;
        }
        if (action instanceof ActionGroup) {
            AnAction[] children2 = ((ActionGroup)action).getChildren(null);
            for (int i = 0; i < children2.length; ++i) {
                AnAction child = children2[i];
                GutterIntentionAction.addActions(project2, editor, psiFile, child, descriptors, renderer, i + order);
            }
        }
        if ((icon = action.getTemplatePresentation().getIcon()) == null) {
            icon = renderer.getIcon();
        }
        if (icon.getIconWidth() < 16) {
            icon = IconUtil.toSize((Icon)icon, (int)16, (int)16);
        }
        if (!(gutterAction = new GutterIntentionAction(action, order, icon)).isAvailable(project2, editor, psiFile)) {
            return;
        }
        HighlightInfo.IntentionActionDescriptor descriptor = new HighlightInfo.IntentionActionDescriptor((IntentionAction)gutterAction, Collections.emptyList(), null, icon, (IntentionAction)gutterAction){
            final /* synthetic */ IntentionAction val$gutterAction;
            {
                this.val$gutterAction = intentionAction;
                super(arg0, arg1, arg2, arg3);
            }

            @Override
            @Nullable
            public String getDisplayName() {
                return this.val$gutterAction.getText();
            }
        };
        descriptors.add(descriptor);
    }

    @Override
    public int compareTo(@NotNull IntentionAction o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "compareTo"));
        }
        if (o instanceof GutterIntentionAction) {
            return this.myOrder - ((GutterIntentionAction)o).myOrder;
        }
        return 0;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.myIcon;
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction.getShortcutSet();
    }
}

