/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightControlFlowUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    private HighlightControlFlowUtil() {
    }

    @Nullable
    static HighlightInfo checkMissingReturnStatement(@Nullable PsiCodeBlock body, @Nullable PsiType returnType) {
        if (body == null || returnType == null || PsiType.VOID.equals((Object)returnType.getDeepComponentType())) {
            return null;
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body);
            if (!ControlFlowUtil.returnPresent(controlFlow)) {
                PsiJavaToken rBrace = body.getRBrace();
                PsiJavaToken context = rBrace == null ? body.getLastChild() : rBrace;
                String message = JavaErrorMessages.message("missing.return.statement", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(message).create();
                PsiElement parent = body.getParent();
                if (parent instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)parent;
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddReturnFix(method));
                    QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, (PsiType)PsiType.VOID, true));
                }
                return info;
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static ControlFlow getControlFlowNoConstantEvaluate(@NotNull PsiElement body) throws AnalysisCanceledException {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getControlFlowNoConstantEvaluate"));
        }
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        ControlFlow controlFlow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow(body, policy, false, false);
        if (controlFlow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getControlFlowNoConstantEvaluate"));
        }
        return controlFlow;
    }

    @NotNull
    private static ControlFlow getControlFlow(@NotNull PsiElement context) throws AnalysisCanceledException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getControlFlow"));
        }
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        ControlFlow controlFlow = ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, policy);
        if (controlFlow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getControlFlow"));
        }
        return controlFlow;
    }

    static HighlightInfo checkUnreachableStatement(@Nullable PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            return null;
        }
        try {
            AllVariablesControlFlowPolicy policy = AllVariablesControlFlowPolicy.getInstance();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(codeBlock.getProject()).getControlFlow((PsiElement)codeBlock, policy, false, false);
            PsiElement unreachableStatement = ControlFlowUtil.getUnreachableStatement(controlFlow);
            if (unreachableStatement != null) {
                String description = JavaErrorMessages.message("unreachable.statement", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(unreachableStatement).descriptionAndTooltip(description).create();
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isFieldInitializedAfterObjectConstruction(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isFieldInitializedAfterObjectConstruction"));
        }
        if (field.hasInitializer()) {
            return true;
        }
        boolean isFieldStatic = field.hasModifierProperty("static");
        PsiClass aClass = field.getContainingClass();
        if (aClass != null && HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, isFieldStatic)) {
            return true;
        }
        if (aClass == null) {
            return false;
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        for (PsiClassInitializer initializer : initializers) {
            if (initializer.hasModifierProperty("static") != isFieldStatic || !HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)initializer.getBody())) continue;
            return true;
        }
        if (isFieldStatic) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        block1: for (PsiMethod constructor : constructors) {
            PsiCodeBlock ctrBody = constructor.getBody();
            if (ctrBody == null) {
                return false;
            }
            List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
            for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                PsiCodeBlock body = redirectedConstructor.getBody();
                if (body != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body)) continue block1;
            }
            if (!ctrBody.isValid() || HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)ctrBody)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldInitializedInOtherFieldInitializer(@NotNull PsiClass aClass, @NotNull PsiField field, boolean fieldStatic) {
        PsiField[] fields;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isFieldInitializedInOtherFieldInitializer"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isFieldInitializedInOtherFieldInitializer"));
        }
        for (PsiField psiField : fields = aClass.getFields()) {
            if (psiField == field || psiField.hasModifierProperty("static") != fieldStatic || !HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)psiField)) continue;
            return true;
        }
        return false;
    }

    static boolean isRecursivelyCalledConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isRecursivelyCalledConstructor"));
        }
        JavaHighlightUtil.ConstructorVisitorInfo info = new JavaHighlightUtil.ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.recursivelyCalledConstructor == null) {
            return false;
        }
        return info.visitedConstructors.indexOf(info.recursivelyCalledConstructor) <= info.visitedConstructors.indexOf(constructor);
    }

    public static boolean isAssigned(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isAssigned"));
        }
        ParamWriteProcessor processor2 = new ParamWriteProcessor();
        ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(parameter.getDeclarationScope()), (boolean)true).forEach((Processor)processor2);
        return processor2.isWriteRefFound();
    }

    private static boolean variableDefinitelyAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "variableDefinitelyAssignedIn"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "variableDefinitelyAssignedIn"));
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    private static boolean variableDefinitelyNotAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "variableDefinitelyNotAssignedIn"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "variableDefinitelyNotAssignedIn"));
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyNotAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    @Nullable
    static HighlightInfo checkFinalFieldInitialized(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkFinalFieldInitialized"));
        }
        if (!field.hasModifierProperty("final")) {
            return null;
        }
        if (HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return null;
        }
        String description = JavaErrorMessages.message("variable.not.initialized", field.getName());
        TextRange range = HighlightNamesUtil.getFieldDeclarationTextRange(field);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)field), QUICK_FIX_FACTORY.createCreateConstructorParameterFromFieldFix(field));
        QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)field), QUICK_FIX_FACTORY.createInitializeFinalFieldInConstructorFix(field));
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !containingClass.isInterface()) {
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field, "final", false, false));
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddVariableInitializerFix((PsiVariable)field));
        return highlightInfo;
    }

    @Nullable
    public static HighlightInfo checkVariableInitializedBeforeUsage(@NotNull PsiReferenceExpression expression, @NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<PsiReferenceExpression>> uninitializedVarProblems, @NotNull PsiFile containingFile) {
        PsiElement topBlock;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkVariableInitializedBeforeUsage"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkVariableInitializedBeforeUsage"));
        }
        if (uninitializedVarProblems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uninitializedVarProblems", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkVariableInitializedBeforeUsage"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkVariableInitializedBeforeUsage"));
        }
        if (variable instanceof ImplicitVariable) {
            return null;
        }
        if (!PsiUtil.isAccessedForReading((PsiExpression)expression)) {
            return null;
        }
        int startOffset = expression.getTextRange().getStartOffset();
        if (variable.hasInitializer()) {
            topBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)variable);
            if (topBlock == null) {
                return null;
            }
        } else {
            PsiClass scope;
            Object object = variable instanceof PsiField ? ((PsiField)variable).getContainingClass() : (scope = variable.getParent() != null ? variable.getParent().getParent() : null);
            if (scope instanceof PsiCodeBlock && scope.getParent() instanceof PsiSwitchStatement) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)scope, PsiCodeBlock.class);
            }
            Object object2 = topBlock = FileTypeUtils.isInServerPageFile((PsiElement)scope) && scope instanceof PsiFile ? scope : PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, (PsiElement)scope);
            if (variable instanceof PsiField) {
                PsiClass aClass;
                PsiCodeBlock block;
                if (!variable.hasModifierProperty("final")) {
                    return null;
                }
                if (PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression) == null && HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression) == null) {
                    return null;
                }
                if (topBlock == null) {
                    return null;
                }
                PsiElement parent = topBlock.getParent();
                if (HighlightControlFlowUtil.inInnerClass((PsiElement)expression, ((PsiField)variable).getContainingClass(), containingFile)) {
                    return null;
                }
                if (parent instanceof PsiMethod) {
                    PsiMethod constructor = (PsiMethod)parent;
                    if (!containingFile.getManager().areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    if (variable.hasModifierProperty("static")) {
                        return null;
                    }
                    List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
                    for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                        PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                        PsiCodeBlock body = redirectedConstructor.getBody();
                        if (body == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body)) continue;
                        return null;
                    }
                    block = constructor.getBody();
                    aClass = constructor.getContainingClass();
                } else if (parent instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)parent;
                    if (!containingFile.getManager().areElementsEquivalent((PsiElement)classInitializer.getContainingClass(), (PsiElement)((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    block = classInitializer.getBody();
                    aClass = classInitializer.getContainingClass();
                } else {
                    PsiCodeBlock constructors;
                    PsiField field = (PsiField)variable;
                    aClass = field.getContainingClass();
                    if (aClass == null || HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, field.hasModifierProperty("static"))) {
                        return null;
                    }
                    PsiField anotherField = (PsiField)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, PsiField.class);
                    int offset = startOffset;
                    if (anotherField != null && anotherField.getContainingClass() == aClass && !field.hasModifierProperty("static")) {
                        offset = 0;
                    }
                    block = null;
                    for (PsiCodeBlock constructor : constructors = aClass.getConstructors()) {
                        if (offset < constructor.getTextRange().getStartOffset()) continue;
                        PsiCodeBlock body = constructor.getBody();
                        if (body != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body)) {
                            return null;
                        }
                        List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors((PsiMethod)constructor);
                        for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                            PsiCodeBlock redirectedBody;
                            PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                            if (offset < redirectedConstructor.getTextRange().getStartOffset() || (redirectedBody = redirectedConstructor.getBody()) == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)redirectedBody)) continue;
                            return null;
                        }
                    }
                }
                if (aClass != null) {
                    PsiClassInitializer initializer;
                    PsiCodeBlock body;
                    PsiClassInitializer[] initializers;
                    PsiClassInitializer[] psiClassInitializerArray = initializers = aClass.getInitializers();
                    int n = psiClassInitializerArray.length;
                    for (int i = 0; i < n && (body = (initializer = psiClassInitializerArray[i]).getBody()) != block; ++i) {
                        boolean shouldCheckInitializerOrder;
                        boolean bl = shouldCheckInitializerOrder = block == null || block.getParent() instanceof PsiClassInitializer;
                        if (shouldCheckInitializerOrder && startOffset < initializer.getTextRange().getStartOffset() || initializer.hasModifierProperty("static") != variable.hasModifierProperty("static") || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body)) continue;
                        return null;
                    }
                }
            }
        }
        if (topBlock == null) {
            return null;
        }
        Collection<PsiReferenceExpression> codeBlockProblems = uninitializedVarProblems.get(topBlock);
        if (codeBlockProblems == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(topBlock);
                codeBlockProblems = ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
            }
            catch (AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            catch (IndexNotReadyException e) {
                codeBlockProblems = Collections.emptyList();
            }
            uninitializedVarProblems.put(topBlock, codeBlockProblems);
        }
        if (codeBlockProblems.contains(expression)) {
            String name = expression.getElement().getText();
            String description = JavaErrorMessages.message("variable.not.initialized", name);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddVariableInitializerFix(variable));
            if (variable instanceof PsiField) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean inInnerClass(@NotNull PsiElement psiElement, @Nullable PsiClass containingClass, @NotNull PsiFile containingFile) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "inInnerClass"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "inInnerClass"));
        }
        for (PsiElement element = psiElement; element != null; element = element.getParent()) {
            if (element instanceof PsiLambdaExpression) {
                return false;
            }
            if (!(element instanceof PsiClass)) continue;
            return !containingFile.getManager().areElementsEquivalent(element, (PsiElement)containingClass);
        }
        return false;
    }

    public static boolean isReassigned(@NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isReassigned"));
        }
        if (finalVarProblems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalVarProblems", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isReassigned"));
        }
        if (variable instanceof PsiLocalVariable) {
            PsiElement parent = variable.getParent();
            if (parent == null) {
                return false;
            }
            PsiElement declarationScope = parent.getParent();
            if (declarationScope == null) {
                return false;
            }
            Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, declarationScope);
            return codeBlockProblems.contains(new ControlFlowUtil.VariableInfo(variable, null));
        }
        if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            return HighlightControlFlowUtil.isAssigned(parameter);
        }
        return false;
    }

    @Nullable
    public static HighlightInfo checkFinalVariableMightAlreadyHaveBeenAssignedTo(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression, @NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkFinalVariableMightAlreadyHaveBeenAssignedTo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkFinalVariableMightAlreadyHaveBeenAssignedTo"));
        }
        if (finalVarProblems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalVarProblems", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkFinalVariableMightAlreadyHaveBeenAssignedTo"));
        }
        if (!PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
            return null;
        }
        Object scope = variable instanceof PsiField ? variable.getParent() : (variable.getParent() == null ? null : variable.getParent().getParent());
        PsiElement codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, (PsiElement)scope);
        if (codeBlock == null) {
            return null;
        }
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, codeBlock);
        boolean alreadyAssigned = false;
        for (ControlFlowUtil.VariableInfo variableInfo : codeBlockProblems) {
            if (variableInfo.expression != expression) continue;
            alreadyAssigned = true;
            break;
        }
        if (!alreadyAssigned) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField[] fields = aClass.getFields();
            boolean isFieldStatic = field.hasModifierProperty("static");
            for (PsiField psiField : fields) {
                PsiExpression initializer = psiField.getInitializer();
                if (psiField == field || psiField.hasModifierProperty("static") != isFieldStatic || initializer == null || initializer == codeBlock || HighlightControlFlowUtil.variableDefinitelyNotAssignedIn((PsiVariable)field, (PsiElement)initializer)) continue;
                alreadyAssigned = true;
                break;
            }
            if (!alreadyAssigned) {
                PsiClassInitializer[] initializers;
                PsiMember enclosingConstructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression);
                if (enclosingConstructorOrInitializer == null || !aClass.getManager().areElementsEquivalent((PsiElement)enclosingConstructorOrInitializer.getContainingClass(), (PsiElement)aClass)) {
                    return null;
                }
                for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                    if (initializer.hasModifierProperty("static") != field.hasModifierProperty("static")) continue;
                    PsiCodeBlock body = initializer.getBody();
                    if (body == codeBlock) {
                        return null;
                    }
                    try {
                        ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow((PsiElement)body);
                        if (ControlFlowUtil.isVariableDefinitelyNotAssigned((PsiVariable)field, controlFlow)) continue;
                        alreadyAssigned = true;
                        break;
                    }
                    catch (AnalysisCanceledException e) {
                        return null;
                    }
                }
            }
            if (!alreadyAssigned && !field.hasModifierProperty("static")) {
                PsiMethod ctr = codeBlock.getParent() instanceof PsiMethod ? (PsiMethod)codeBlock.getParent() : null;
                List<PsiMethod> redirectedConstructors = ctr != null && ctr.isConstructor() ? JavaHighlightUtil.getChainedConstructors(ctr) : null;
                for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                    PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                    PsiCodeBlock body = redirectedConstructor.getBody();
                    if (body == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body)) continue;
                    alreadyAssigned = true;
                    break;
                }
            }
        }
        if (alreadyAssigned) {
            String description = JavaErrorMessages.message("variable.already.assigned", variable.getName());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false));
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeferFinalAssignmentFix(variable, expression));
            return highlightInfo;
        }
        return null;
    }

    @NotNull
    private static Collection<ControlFlowUtil.VariableInfo> getFinalVariableProblemsInBlock(@NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems, @NotNull PsiElement codeBlock) {
        if (finalVarProblems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalVarProblems", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getFinalVariableProblemsInBlock"));
        }
        if (codeBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeBlock", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getFinalVariableProblemsInBlock"));
        }
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = finalVarProblems.get(codeBlock);
        if (codeBlockProblems == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate(codeBlock);
                codeBlockProblems = ControlFlowUtil.getInitializedTwice(controlFlow);
            }
            catch (AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            finalVarProblems.put(codeBlock, codeBlockProblems);
        }
        Collection<ControlFlowUtil.VariableInfo> collection = codeBlockProblems;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getFinalVariableProblemsInBlock"));
        }
        return collection;
    }

    @Nullable
    static HighlightInfo checkFinalVariableInitializedInLoop(@NotNull PsiReferenceExpression expression, @NotNull PsiElement resolved) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkFinalVariableInitializedInLoop"));
        }
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkFinalVariableInitializedInLoop"));
        }
        if (ControlFlowUtil.isVariableAssignedInLoop(expression, resolved)) {
            String description = JavaErrorMessages.message("variable.assigned.in.loop", ((PsiVariable)resolved).getName());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)((PsiVariable)resolved), "final", false, false));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCannotWriteToFinal(@NotNull PsiExpression expression, @NotNull PsiFile containingFile) {
        boolean canWrite;
        PsiVariable variable;
        IElementType sign;
        PsiExpression operand;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkCannotWriteToFinal"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkCannotWriteToFinal"));
        }
        PsiReferenceExpression reference = null;
        boolean readBeforeWrite = false;
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
            if (left instanceof PsiReferenceExpression) {
                reference = (PsiReferenceExpression)left;
            }
            readBeforeWrite = assignmentExpression.getOperationTokenType() != JavaTokenType.EQ;
        } else if (expression instanceof PsiPostfixExpression) {
            operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiPostfixExpression)expression).getOperand());
            sign = ((PsiPostfixExpression)expression).getOperationTokenType();
            if (operand instanceof PsiReferenceExpression && (sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS)) {
                reference = (PsiReferenceExpression)operand;
            }
            readBeforeWrite = true;
        } else if (expression instanceof PsiPrefixExpression) {
            operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiPrefixExpression)expression).getOperand());
            sign = ((PsiPrefixExpression)expression).getOperationTokenType();
            if (operand instanceof PsiReferenceExpression && (sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS)) {
                reference = (PsiReferenceExpression)operand;
            }
            readBeforeWrite = true;
        }
        PsiElement resolved = reference == null ? null : reference.resolve();
        PsiVariable psiVariable = variable = resolved instanceof PsiVariable ? (PsiVariable)resolved : null;
        if (variable == null || !variable.hasModifierProperty("final")) {
            return null;
        }
        boolean bl = canWrite = HighlightControlFlowUtil.canWriteToFinal(variable, expression, reference, containingFile) && HighlightControlFlowUtil.checkWriteToFinalInsideLambda(variable, (PsiJavaCodeReferenceElement)reference) == null;
        if (readBeforeWrite || !canWrite) {
            String name = variable.getName();
            String description = canWrite ? JavaErrorMessages.message("variable.not.initialized", name) : JavaErrorMessages.message("assignment.to.final.variable", name);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(reference.getTextRange()).descriptionAndTooltip(description).create();
            PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression);
            if (innerClass == null || variable instanceof PsiField) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false));
            } else {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, innerClass));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean canWriteToFinal(@NotNull PsiVariable variable, @NotNull PsiExpression expression, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "canWriteToFinal"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "canWriteToFinal"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "canWriteToFinal"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "canWriteToFinal"));
        }
        if (variable.hasInitializer()) {
            return false;
        }
        if (variable instanceof PsiParameter) {
            return false;
        }
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression);
        if (variable instanceof PsiField) {
            if (HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression) != null) {
                return true;
            }
            PsiField field = (PsiField)variable;
            if (innerClass != null && !containingFile.getManager().areElementsEquivalent(innerClass, (PsiElement)field.getContainingClass())) {
                return false;
            }
            PsiMember enclosingCtrOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression);
            return enclosingCtrOrInitializer != null && HighlightControlFlowUtil.isSameField(enclosingCtrOrInitializer, field, reference, containingFile);
        }
        if (variable instanceof PsiLocalVariable) {
            boolean isAccessedFromOtherClass;
            boolean bl = isAccessedFromOtherClass = innerClass != null;
            if (isAccessedFromOtherClass) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSameField(@NotNull PsiMember enclosingCtrOrInitializer, @NotNull PsiField field, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (enclosingCtrOrInitializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingCtrOrInitializer", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isSameField"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isSameField"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isSameField"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isSameField"));
        }
        if (!containingFile.getManager().areElementsEquivalent((PsiElement)enclosingCtrOrInitializer.getContainingClass(), (PsiElement)field.getContainingClass())) {
            return false;
        }
        PsiExpression qualifierExpression = reference.getQualifierExpression();
        return qualifierExpression == null || qualifierExpression instanceof PsiThisExpression;
    }

    @Nullable
    static HighlightInfo checkVariableMustBeFinal(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context, @NotNull LanguageLevel languageLevel) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkVariableMustBeFinal"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkVariableMustBeFinal"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkVariableMustBeFinal"));
        }
        if (variable.hasModifierProperty("final")) {
            return null;
        }
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)context);
        if (innerClass instanceof PsiClass) {
            PsiElement parent;
            if (variable instanceof PsiParameter && (parent = variable.getParent()) instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression && HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(((PsiParameter)variable).getDeclarationScope()))) {
                return null;
            }
            boolean isToBeEffectivelyFinal = languageLevel.isAtLeast(LanguageLevel.JDK_1_8);
            if (isToBeEffectivelyFinal && HighlightControlFlowUtil.isEffectivelyFinal(variable, innerClass, context)) {
                return null;
            }
            String description = JavaErrorMessages.message(isToBeEffectivelyFinal ? "variable.must.be.final.or.effectively.final" : "variable.must.be.final", context.getText());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, innerClass));
            return highlightInfo;
        }
        return HighlightControlFlowUtil.checkWriteToFinalInsideLambda(variable, context);
    }

    private static HighlightInfo checkWriteToFinalInsideLambda(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkWriteToFinalInsideLambda"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkWriteToFinalInsideLambda"));
        }
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiLambdaExpression.class);
        if (lambdaExpression != null && !PsiTreeUtil.isAncestor((PsiElement)lambdaExpression, (PsiElement)variable, (boolean)true)) {
            PsiElement parent = variable.getParent();
            if (parent instanceof PsiParameterList && parent.getParent() == lambdaExpression) {
                return null;
            }
            if (!HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)lambdaExpression, context)) {
                String text = JavaErrorMessages.message("lambda.variable.must.be.final", new Object[0]);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(text).create();
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, (PsiElement)lambdaExpression));
                return highlightInfo;
            }
        }
        return null;
    }

    public static boolean isEffectivelyFinal(@NotNull PsiVariable variable, @NotNull PsiElement scope, @Nullable PsiJavaCodeReferenceElement context) {
        boolean effectivelyFinal;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isEffectivelyFinal"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "isEffectivelyFinal"));
        }
        if (variable instanceof PsiParameter) {
            effectivelyFinal = HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(((PsiParameter)variable).getDeclarationScope()));
        } else {
            ControlFlow controlFlow;
            try {
                PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)context);
                if (codeBlock == null) {
                    return true;
                }
                controlFlow = HighlightControlFlowUtil.getControlFlow(codeBlock);
            }
            catch (AnalysisCanceledException e) {
                return true;
            }
            List<PsiReferenceExpression> readBeforeWriteLocals = ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
            for (PsiReferenceExpression expression : readBeforeWriteLocals) {
                if (expression.resolve() != variable) continue;
                return PsiUtil.isAccessedForReading((PsiExpression)expression);
            }
            Collection<ControlFlowUtil.VariableInfo> initializedTwice = ControlFlowUtil.getInitializedTwice(controlFlow);
            boolean bl = effectivelyFinal = !initializedTwice.contains(new ControlFlowUtil.VariableInfo(variable, null));
            if (effectivelyFinal) {
                effectivelyFinal = HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(scope));
            }
        }
        return effectivelyFinal;
    }

    private static boolean notAccessedForWriting(@NotNull PsiVariable variable, @NotNull LocalSearchScope searchScope) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "notAccessedForWriting"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "notAccessedForWriting"));
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope)) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiElement getInnerClassVariableReferencedFrom(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        PsiElement parent;
        PsiElement[] scope;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getInnerClassVariableReferencedFrom"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "getInnerClassVariableReferencedFrom"));
        }
        if (variable instanceof PsiResourceVariable) {
            scope = ((PsiResourceVariable)variable).getDeclarationScope();
        } else if (variable instanceof PsiLocalVariable) {
            parent = variable.getParent();
            scope = new PsiElement[]{parent != null ? parent.getParent() : null};
        } else {
            scope = variable instanceof PsiParameter ? new PsiElement[]{((PsiParameter)variable).getDeclarationScope()} : new PsiElement[]{variable.getParent()};
        }
        if (scope.length < 1 || scope[0] == null || scope[0].getContainingFile() != context.getContainingFile()) {
            return null;
        }
        PsiElement prevParent = context;
        block0: for (parent = context.getParent(); parent != null; parent = parent.getParent()) {
            for (PsiElement scopeElement : scope) {
                if (parent.equals(scopeElement)) break block0;
            }
            if (!(!(parent instanceof PsiClass) || prevParent instanceof PsiExpressionList && parent instanceof PsiAnonymousClass)) {
                return parent;
            }
            if (parent instanceof PsiLambdaExpression) {
                return parent;
            }
            prevParent = parent;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInitializerCompleteNormally(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil", "checkInitializerCompleteNormally"));
        }
        PsiCodeBlock body = initializer.getBody();
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body);
            int completionReasons = ControlFlowUtil.getCompletionReasons(controlFlow, 0, controlFlow.getSize());
            if ((completionReasons & 1) == 0) {
                String description = JavaErrorMessages.message("initializer.must.be.able.to.complete.normally", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)body).descriptionAndTooltip(description).create();
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    private static class ParamWriteProcessor
    implements Processor<PsiReference> {
        private volatile boolean myIsWriteRefFound;

        private ParamWriteProcessor() {
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            if (element instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) {
                this.myIsWriteRefFound = true;
                return false;
            }
            return true;
        }

        private boolean isWriteRefFound() {
            return this.myIsWriteRefFound;
        }
    }
}

