/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.OptionGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class ExportToHTMLDialog
extends DialogWrapper {
    private final Project myProject;
    protected JCheckBox myCbOpenInBrowser;
    protected TextFieldWithBrowseButton myTargetDirectoryField;
    protected final boolean myCanBeOpenInBrowser;

    public ExportToHTMLDialog(Project project2, boolean canBeOpenInBrowser) {
        super(project2, true);
        this.myProject = project2;
        this.myCanBeOpenInBrowser = canBeOpenInBrowser;
        this.setOKButtonText(InspectionsBundle.message((String)"inspection.export.save.button", (Object[])new Object[0]));
        this.setTitle(InspectionsBundle.message((String)"inspection.export.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createNorthPanel() {
        OptionGroup optionGroup = new OptionGroup();
        this.myTargetDirectoryField = new TextFieldWithBrowseButton();
        optionGroup.add(com.intellij.codeEditor.printing.ExportToHTMLDialog.assignLabel(this.myTargetDirectoryField, this.myProject));
        return optionGroup.createPanel();
    }

    protected JComponent createCenterPanel() {
        if (!this.myCanBeOpenInBrowser) {
            return null;
        }
        OptionGroup optionGroup = new OptionGroup();
        this.addOptions(optionGroup);
        return optionGroup.createPanel();
    }

    protected void addOptions(OptionGroup optionGroup) {
        this.myCbOpenInBrowser = new JCheckBox();
        this.myCbOpenInBrowser.setText(InspectionsBundle.message((String)"inspection.export.open.option", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbOpenInBrowser);
    }

    public void reset() {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myProject);
        if (this.myCanBeOpenInBrowser) {
            this.myCbOpenInBrowser.setSelected(exportToHTMLSettings.OPEN_IN_BROWSER);
        }
        this.myTargetDirectoryField.setText(exportToHTMLSettings.OUTPUT_DIRECTORY);
    }

    public void apply() {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myProject);
        if (this.myCanBeOpenInBrowser) {
            exportToHTMLSettings.OPEN_IN_BROWSER = this.myCbOpenInBrowser.isSelected();
        }
        exportToHTMLSettings.OUTPUT_DIRECTORY = this.myTargetDirectoryField.getText();
    }
}

