/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.actions.SuppressActionWrapper;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManagerImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Browser
extends JPanel {
    private static final String UNDER_CONSTRUCTION = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
    private final List<ClickListener> myClickListeners;
    private RefEntity myCurrentEntity;
    private JEditorPane myHTMLViewer;
    private final InspectionResultsView myView;
    private final HyperlinkListener myHyperLinkListener;
    private CommonProblemDescriptor myCurrentDescriptor;

    public void dispose() {
        this.removeAll();
        if (this.myHTMLViewer != null) {
            this.myHTMLViewer.removeHyperlinkListener(this.myHyperLinkListener);
            this.myHTMLViewer = null;
        }
        this.myClickListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPageFromHistory(@NotNull RefEntity newEntity) {
        if (newEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEntity", "com/intellij/codeInspection/ui/Browser", "showPageFromHistory"));
        }
        InspectionToolWrapper toolWrapper = this.getToolWrapper(newEntity);
        try {
            String html = this.generateHTML(newEntity, toolWrapper);
            this.myHTMLViewer.read(new StringReader(html), null);
            this.setupStyle();
            this.myHTMLViewer.setCaretPosition(0);
        }
        catch (Exception e) {
            this.showEmpty();
        }
        finally {
            this.myCurrentEntity = newEntity;
            this.myCurrentDescriptor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPageFor(RefEntity refEntity, CommonProblemDescriptor descriptor) {
        try {
            String html = this.generateHTML(refEntity, descriptor);
            this.myHTMLViewer.read(new StringReader(html), null);
            this.setupStyle();
            this.myHTMLViewer.setCaretPosition(0);
        }
        catch (Exception e) {
            this.showEmpty();
        }
        finally {
            this.myCurrentEntity = refEntity;
            this.myCurrentDescriptor = descriptor;
        }
    }

    public void showPageFor(RefEntity newEntity) {
        if (newEntity == null) {
            this.showEmpty();
            return;
        }
        this.showPageFromHistory(newEntity.getRefManager().getRefinedElement(newEntity));
    }

    public Browser(@NotNull InspectionResultsView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/Browser", "<init>"));
        }
        super(new BorderLayout());
        this.myClickListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myView = view;
        this.myCurrentEntity = null;
        this.myCurrentDescriptor = null;
        this.myHTMLViewer = new JEditorPane("text/html", InspectionsBundle.message((String)"inspection.offline.view.empty.browser.text", (Object[])new Object[0]));
        this.myHTMLViewer.setEditable(false);
        this.myHyperLinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Browser.this.hyperlinkUpdate(e);
            }
        };
        this.myHTMLViewer.addHyperlinkListener(this.myHyperLinkListener);
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myHTMLViewer);
        pane.setBorder(null);
        this.add((Component)pane, "Center");
        this.setupStyle();
    }

    private void hyperlinkUpdate(HyperlinkEvent e) {
        block23: {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
                return;
            }
            URL url = null;
            try {
                url = e.getURL();
                String ref = url.getRef();
                if (ref.startsWith("pos:")) {
                    int delimeterPos = ref.indexOf(58, "pos:".length() + 1);
                    String startPosition = ref.substring("pos:".length(), delimeterPos);
                    String endPosition = ref.substring(delimeterPos + 1);
                    Integer textStartOffset = new Integer(startPosition);
                    Integer textEndOffset = new Integer(endPosition);
                    String fileURL = url.toExternalForm();
                    fileURL = fileURL.substring(0, fileURL.indexOf(35));
                    VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                    if (vFile != null) {
                        this.fireClickEvent(vFile, textStartOffset, textEndOffset);
                    }
                } else if (ref.startsWith("descr:")) {
                    if (this.myCurrentDescriptor instanceof ProblemDescriptor) {
                        PsiElement psiElement = ((ProblemDescriptor)this.myCurrentDescriptor).getPsiElement();
                        if (psiElement == null) {
                            return;
                        }
                        VirtualFile vFile = psiElement.getContainingFile().getVirtualFile();
                        if (vFile != null) {
                            TextRange range = ((ProblemDescriptorBase)this.myCurrentDescriptor).getTextRange();
                            this.fireClickEvent(vFile, range.getStartOffset(), range.getEndOffset());
                        }
                    }
                } else if (ref.startsWith("invoke:")) {
                    int actionNumber = Integer.parseInt(ref.substring("invoke:".length()));
                    InspectionToolWrapper toolWrapper = this.getToolWrapper();
                    InspectionToolPresentation presentation = this.myView.getGlobalInspectionContext().getPresentation(toolWrapper);
                    QuickFixAction fixAction = presentation.getQuickFixes((RefEntity[])new RefElement[]{(RefElement)this.myCurrentEntity})[actionNumber];
                    fixAction.doApplyFix((RefEntity[])new RefElement[]{(RefElement)this.myCurrentEntity}, this.myView);
                } else if (ref.startsWith("invokelocal:")) {
                    int actionNumber = Integer.parseInt(ref.substring("invokelocal:".length()));
                    if (actionNumber > -1) {
                        this.invokeLocalFix(actionNumber);
                    }
                } else if (ref.startsWith("suppress:")) {
                    int actionNumber;
                    SuppressActionWrapper.SuppressTreeAction[] suppressTreeActions = new SuppressActionWrapper(this.myView.getProject(), this.getToolWrapper(), this.myView.getTree().getSelectionPaths()).getChildren(null);
                    ArrayList<SuppressActionWrapper.SuppressTreeAction> activeActions = new ArrayList<SuppressActionWrapper.SuppressTreeAction>();
                    for (SuppressActionWrapper.SuppressTreeAction suppressTreeAction : suppressTreeActions) {
                        if (!suppressTreeAction.isAvailable()) continue;
                        activeActions.add(suppressTreeAction);
                    }
                    if (!activeActions.isEmpty() && (actionNumber = Integer.parseInt(ref.substring("suppress:".length()))) > -1 && activeActions.size() > actionNumber) {
                        ((AnAction)activeActions.get(actionNumber)).actionPerformed(null);
                    }
                } else {
                    int offset = Integer.parseInt(ref);
                    String fileURL = url.toExternalForm();
                    fileURL = fileURL.substring(0, fileURL.indexOf(35));
                    VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                    if (vFile == null) {
                        vFile = VfsUtil.findFileByURL((URL)url);
                    }
                    if (vFile != null) {
                        this.fireClickEvent(vFile, offset, offset);
                    }
                }
            }
            catch (Throwable t) {
                if (url == null) break block23;
                BrowserUtil.browse((URL)url);
            }
        }
    }

    private void setupStyle() {
        Document document = this.myHTMLViewer.getDocument();
        if (!(document instanceof StyledDocument)) {
            return;
        }
        StyledDocument styledDocument = (StyledDocument)document;
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        Style style = styledDocument.addStyle("active", null);
        StyleConstants.setFontFamily(style, scheme.getEditorFontName());
        StyleConstants.setFontSize(style, scheme.getEditorFontSize());
        styledDocument.setCharacterAttributes(0, document.getLength(), style, false);
    }

    public void addClickListener(ClickListener listener2) {
        this.myClickListeners.add(listener2);
    }

    private void fireClickEvent(VirtualFile file2, int startPosition, int endPosition) {
        ClickEvent e = new ClickEvent(file2, startPosition, endPosition);
        for (ClickListener listener2 : this.myClickListeners) {
            listener2.referenceClicked(e);
        }
    }

    private String generateHTML(final RefEntity refEntity, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ui/Browser", "generateHTML"));
        }
        final StringBuffer buf = new StringBuffer();
        final HTMLComposerImpl htmlComposer = this.getPresentation(toolWrapper).getComposer();
        if (refEntity instanceof RefElement) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    htmlComposer.compose(buf, refEntity);
                }
            });
        } else {
            htmlComposer.compose(buf, refEntity);
        }
        Browser.uppercaseFirstLetter(buf);
        if (refEntity instanceof RefElement) {
            this.appendSuppressSection(buf);
        }
        Browser.insertHeaderFooter(buf);
        return buf.toString();
    }

    private InspectionToolPresentation getPresentation(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ui/Browser", "getPresentation"));
        }
        return this.myView.getGlobalInspectionContext().getPresentation(toolWrapper);
    }

    private static void insertHeaderFooter(StringBuffer buf) {
        buf.insert(0, "<HTML><BODY>");
        buf.append("</BODY></HTML>");
    }

    private String generateHTML(final RefEntity refEntity, final CommonProblemDescriptor descriptor) {
        final StringBuffer buf = new StringBuffer();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                InspectionToolWrapper toolWrapper = Browser.this.getToolWrapper(refEntity);
                Browser.this.getPresentation(toolWrapper).getComposer().compose(buf, refEntity, descriptor);
            }
        };
        ApplicationManager.getApplication().runReadAction(action);
        Browser.uppercaseFirstLetter(buf);
        if (refEntity instanceof RefElement) {
            this.appendSuppressSection(buf);
        }
        Browser.insertHeaderFooter(buf);
        return buf.toString();
    }

    private InspectionToolWrapper getToolWrapper(RefEntity refEntity) {
        InspectionToolWrapper toolWrapper = this.getToolWrapper();
        assert (toolWrapper != null);
        GlobalInspectionContextImpl context = this.myView.getGlobalInspectionContext();
        if (refEntity instanceof RefElement) {
            PsiElement element = ((RefElement)refEntity).getElement();
            if (element == null) {
                return toolWrapper;
            }
            InspectionProfileWrapper profileWrapper = InspectionProjectProfileManagerImpl.getInstanceImpl(context.getProject()).getProfileWrapper();
            toolWrapper = profileWrapper.getInspectionTool(toolWrapper.getShortName(), element);
        }
        return toolWrapper;
    }

    private void appendSuppressSection(StringBuffer buf) {
        SuppressActionWrapper.SuppressTreeAction[] suppressActions;
        HighlightDisplayKey key;
        InspectionToolWrapper toolWrapper = this.getToolWrapper();
        if (toolWrapper != null && (key = HighlightDisplayKey.find((String)toolWrapper.getShortName())) != null && (suppressActions = new SuppressActionWrapper(this.myView.getProject(), toolWrapper, this.myView.getTree().getSelectionPaths()).getChildren(null)).length > 0) {
            ArrayList<SuppressActionWrapper.SuppressTreeAction> activeSuppressActions = new ArrayList<SuppressActionWrapper.SuppressTreeAction>();
            for (SuppressActionWrapper.SuppressTreeAction suppressAction : suppressActions) {
                if (!suppressAction.isAvailable()) continue;
                activeSuppressActions.add(suppressAction);
            }
            if (!activeSuppressActions.isEmpty()) {
                int idx = 0;
                String br = "<br>";
                buf.append("<br>");
                HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.suppress", (Object[])new Object[0]));
                for (SuppressActionWrapper.SuppressTreeAction suppressAction : activeSuppressActions) {
                    buf.append("<br>");
                    if (idx == activeSuppressActions.size() - 1) {
                        buf.append("<br>");
                    }
                    HTMLComposer.appendAfterHeaderIndention((StringBuffer)buf);
                    String href = "<a HREF=\"file://bred.txt#suppress:" + idx + "\">" + suppressAction.getTemplatePresentation().getText() + "</a>";
                    buf.append(href);
                    ++idx;
                }
            }
        }
    }

    private static void uppercaseFirstLetter(StringBuffer buf) {
        if (buf.length() > 1) {
            char[] firstLetter = new char[1];
            buf.getChars(0, 1, firstLetter, 0);
            buf.setCharAt(0, Character.toUpperCase(firstLetter[0]));
        }
    }

    public void showEmpty() {
        this.myCurrentEntity = null;
        try {
            this.myHTMLViewer.read(new StringReader(InspectionsBundle.message((String)"inspection.offline.view.empty.browser.text", (Object[])new Object[0])), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDescription(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ui/Browser", "showDescription"));
        }
        if (toolWrapper.getShortName().isEmpty()) {
            this.showEmpty();
            return;
        }
        StringBuffer page = new StringBuffer();
        page.append("<table border='0' cellspacing='0' cellpadding='0' width='100%'>");
        page.append("<tr><td colspan='2'>");
        HTMLComposer.appendHeading((StringBuffer)page, (String)InspectionsBundle.message((String)"inspection.tool.in.browser.id.title", (Object[])new Object[0]));
        page.append("</td></tr>");
        page.append("<tr><td width='37'></td><td>");
        page.append(toolWrapper.getShortName());
        page.append("</td></tr>");
        page.append("<tr height='10'></tr>");
        page.append("<tr><td colspan='2'>");
        HTMLComposer.appendHeading((StringBuffer)page, (String)InspectionsBundle.message((String)"inspection.tool.in.browser.description.title", (Object[])new Object[0]));
        page.append("</td></tr>");
        page.append("<tr><td width='37'></td><td>");
        String underConstruction = "<b>" + UNDER_CONSTRUCTION + "</b></html>";
        try {
            String description = toolWrapper.loadDescription();
            if (description == null) {
                description = underConstruction;
            }
            page.append(DefaultInspectionToolPresentation.stripUIRefsFromInspectionDescription(UIUtil.getHtmlBody((String)description)));
            page.append("</td></tr></table>");
            this.myHTMLViewer.setText(XmlStringUtil.wrapInHtml((CharSequence)page));
            this.setupStyle();
        }
        finally {
            this.myCurrentEntity = null;
        }
    }

    @Nullable
    private InspectionToolWrapper getToolWrapper() {
        return this.myView.getTree().getSelectedToolWrapper();
    }

    public void invokeLocalFix(int idx) {
        if (this.myView.getTree().getSelectionCount() != 1) {
            return;
        }
        InspectionTreeNode node = (InspectionTreeNode)this.myView.getTree().getSelectionPath().getLastPathComponent();
        if (node instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
            CommonProblemDescriptor descriptor = problemNode.getDescriptor();
            RefEntity element = problemNode.getElement();
            this.invokeFix(element, descriptor, idx);
        } else if (node instanceof RefElementNode) {
            RefElementNode elementNode = (RefElementNode)node;
            RefEntity element = elementNode.getElement();
            CommonProblemDescriptor descriptor = elementNode.getProblem();
            if (descriptor != null) {
                this.invokeFix(element, descriptor, idx);
            }
        }
    }

    private void invokeFix(RefEntity element, CommonProblemDescriptor descriptor, int idx) {
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > idx && fixes[idx] != null) {
            if (element instanceof RefElement) {
                PsiElement psiElement = ((RefElement)element).getElement();
                if (psiElement != null && psiElement.isValid()) {
                    if (!FileModificationService.getInstance().preparePsiElementForWrite(psiElement)) {
                        return;
                    }
                    this.performFix(element, descriptor, idx, fixes[idx]);
                }
            } else {
                this.performFix(element, descriptor, idx, fixes[idx]);
            }
        }
    }

    private void performFix(final RefEntity element, final CommonProblemDescriptor descriptor, final int idx, final QuickFix fix) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiModificationTracker tracker = PsiManager.getInstance((Project)Browser.this.myView.getProject()).getModificationTracker();
                        long startCount = tracker.getModificationCount();
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(Browser.this.myView.getProject());
                        fix.applyFix(Browser.this.myView.getProject(), descriptor);
                        if (startCount != tracker.getModificationCount()) {
                            InspectionToolWrapper toolWrapper = Browser.this.myView.getTree().getSelectedToolWrapper();
                            if (toolWrapper != null) {
                                InspectionToolPresentation presentation = Browser.this.myView.getGlobalInspectionContext().getPresentation(toolWrapper);
                                presentation.ignoreProblem(element, descriptor, idx);
                            }
                            Browser.this.myView.updateView(false);
                        }
                    }
                });
            }
        };
        CommandProcessor.getInstance().executeCommand(this.myView.getProject(), command, fix.getName(), null);
    }

    public static interface ClickListener {
        public void referenceClicked(ClickEvent var1);
    }

    public static class ClickEvent {
        public static final int REF_ELEMENT = 1;
        public static final int FILE_OFFSET = 2;
        private final VirtualFile myFile;
        private final int myStartPosition;
        private final int myEndPosition;
        private final RefElement refElement;
        private final int myEventType;

        public ClickEvent(VirtualFile myFile, int myStartPosition, int myEndPosition) {
            this.myFile = myFile;
            this.myStartPosition = myStartPosition;
            this.myEndPosition = myEndPosition;
            this.myEventType = 2;
            this.refElement = null;
        }

        public int getEventType() {
            return this.myEventType;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getStartOffset() {
            return this.myStartPosition;
        }

        public int getEndOffset() {
            return this.myEndPosition;
        }

        public RefElement getClickedElement() {
            return this.refElement;
        }
    }
}

