/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies;

import com.intellij.util.Chunk;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CyclicDependenciesUtil {
    public static <Node> List<Chunk<Node>> buildChunks(Graph<Node> graph) {
        final DFSTBuilder dfstBuilder = new DFSTBuilder(graph);
        TIntArrayList sccs = dfstBuilder.getSCCs();
        final ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>();
        sccs.forEach(new TIntProcedure(){
            int myTNumber = 0;

            public boolean execute(int size) {
                LinkedHashSet<Object> packs = new LinkedHashSet<Object>();
                for (int j = 0; j < size; ++j) {
                    packs.add(dfstBuilder.getNodeByTNumber(this.myTNumber + j));
                }
                chunks.add(new Chunk(packs));
                this.myTNumber += size;
                return true;
            }
        });
        return chunks;
    }

    public static class GraphTraverser<Node> {
        private final List<Path<Node>> myCurrentPaths = new ArrayList<Path<Node>>();
        private final Node myBegin;
        private final Chunk<Node> myChunk;
        private final int myMaxPathsCount;
        private final Graph<Node> myGraph;

        public GraphTraverser(Node begin, Chunk<Node> chunk, int maxPathsCount, Graph<Node> graph) {
            this.myBegin = begin;
            this.myChunk = chunk;
            this.myMaxPathsCount = maxPathsCount;
            this.myGraph = graph;
        }

        public Set<Path<Node>> traverse() {
            HashSet<Path<Node>> result = new HashSet<Path<Node>>();
            Path<Node> firstPath = new Path<Node>();
            firstPath.add(this.myBegin);
            this.myCurrentPaths.add(firstPath);
            while (!this.myCurrentPaths.isEmpty() && result.size() < this.myMaxPathsCount) {
                Path<Node> path = this.myCurrentPaths.get(0);
                Set<Node> nextNodes = this.getNextNodes(path.getEnd());
                this.nextStep(nextNodes, path, result);
            }
            return result;
        }

        public Set<ArrayList<Node>> convert(Set<Path<Node>> paths) {
            HashSet<ArrayList<Node>> result = new HashSet<ArrayList<Node>>();
            for (Path<Node> path : paths) {
                result.add(path.getPath());
            }
            return result;
        }

        private void nextStep(Set<Node> nextNodes, Path<Node> path, Set<Path<Node>> result) {
            this.myCurrentPaths.remove(path);
            for (Node node : nextNodes) {
                if (path.getEnd() == node) continue;
                if (path.getBeg() == node) {
                    result.add(path);
                    continue;
                }
                Path<Node> newPath = new Path<Node>(path);
                newPath.add(node);
                if (path.contains(node)) {
                    Set<Node> nodesAfterInnerCycle = this.getNextNodes(node);
                    nodesAfterInnerCycle.removeAll(path.getNextNodes(node));
                    this.nextStep(nodesAfterInnerCycle, newPath, result);
                    continue;
                }
                this.myCurrentPaths.add(newPath);
            }
        }

        private Set<Node> getNextNodes(Node node) {
            HashSet result = new HashSet();
            Iterator in = this.myGraph.getIn(node);
            while (in.hasNext()) {
                Object inNode = in.next();
                if (!this.myChunk.containsNode(inNode)) continue;
                result.add(inNode);
            }
            return result;
        }
    }

    public static class Path<Node> {
        private ArrayList<Node> myPath = new ArrayList();

        public Path() {
        }

        public Path(Path<Node> path) {
            this.myPath = new ArrayList<Node>(path.myPath);
        }

        public Node getBeg() {
            return this.myPath.get(0);
        }

        public Node getEnd() {
            return this.myPath.get(this.myPath.size() - 1);
        }

        public boolean contains(Node node) {
            return this.myPath.contains(node);
        }

        public List<Node> getNextNodes(Node node) {
            ArrayList<Node> result = new ArrayList<Node>();
            for (int i = 0; i < this.myPath.size() - 1; ++i) {
                Node nodeN = this.myPath.get(i);
                if (nodeN != node) continue;
                result.add(this.myPath.get(i + 1));
            }
            return result;
        }

        public void add(Node node) {
            this.myPath.add(node);
        }

        public ArrayList<Node> getPath() {
            return this.myPath;
        }
    }
}

