/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.concurrency.JobScheduler;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadBlockedMonitor {
    private static final Logger LOG = Logger.getInstance(ThreadBlockedMonitor.class);
    private final Collection<ThreadReferenceProxy> myWatchedThreads = new HashSet<ThreadReferenceProxy>();
    private ScheduledFuture<?> myTask;
    private final DebugProcessImpl myProcess;

    public ThreadBlockedMonitor(DebugProcessImpl process, Disposable disposable) {
        this.myProcess = process;
        Disposer.register((Disposable)disposable, this::cancelTask);
    }

    public void startWatching(@Nullable ThreadReferenceProxy thread) {
        if (!Registry.is((String)"debugger.monitor.blocked.threads")) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread != null) {
            this.myWatchedThreads.add(thread);
            if (this.myTask == null) {
                this.myTask = JobScheduler.getScheduler().scheduleWithFixedDelay(this::checkBlockingThread, 5L, 5L, TimeUnit.SECONDS);
            }
        }
    }

    public void stopWatching(@Nullable ThreadReferenceProxy thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread != null) {
            this.myWatchedThreads.remove(thread);
        } else {
            this.myWatchedThreads.clear();
        }
        if (this.myWatchedThreads.isEmpty()) {
            this.cancelTask();
        }
    }

    private void cancelTask() {
        if (this.myTask != null) {
            this.myTask.cancel(true);
            this.myTask = null;
        }
    }

    private static void onThreadBlocked(@NotNull ThreadReference blockedThread, final @NotNull ThreadReference blockingThread, final DebugProcessImpl process) {
        if (blockedThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockedThread", "com/intellij/debugger/engine/ThreadBlockedMonitor", "onThreadBlocked"));
        }
        if (blockingThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockingThread", "com/intellij/debugger/engine/ThreadBlockedMonitor", "onThreadBlocked"));
        }
        XDebugSessionImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.thread.blocked.by", (Object[])new Object[]{blockedThread.name(), blockingThread.name()}), DebuggerBundle.message((String)"status.thread.blocked.by.resume", (Object[])new Object[]{blockingThread.name()}), NotificationType.INFORMATION, (notification, event) -> {
            if (blockingThread == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockingThread", "com/intellij/debugger/engine/ThreadBlockedMonitor", "lambda$onThreadBlocked$0"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                notification.expire();
                process.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        ThreadReferenceProxyImpl threadProxy = process.getVirtualMachineProxy().getThreadReferenceProxy(blockingThread);
                        SuspendContextImpl suspendingContext = SuspendManagerUtil.getSuspendingContext(process.getSuspendManager(), threadProxy);
                        process.getManagerThread().invoke(process.createResumeThreadCommand(suspendingContext, threadProxy));
                    }
                });
            }
        }).notify(process.getProject());
    }

    private ThreadReference getCurrentThread() {
        ThreadReferenceProxyImpl threadProxy = this.myProcess.getDebuggerContext().getThreadProxy();
        return threadProxy != null ? threadProxy.getThreadReference() : null;
    }

    private void checkBlockingThread() {
        this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() throws Exception {
                if (ThreadBlockedMonitor.this.myWatchedThreads.isEmpty()) {
                    return;
                }
                VirtualMachineProxyImpl vmProxy = ThreadBlockedMonitor.this.myProcess.getVirtualMachineProxy();
                vmProxy.getVirtualMachine().suspend();
                try {
                    for (ThreadReferenceProxy thread : ThreadBlockedMonitor.this.myWatchedThreads) {
                        ThreadReference blockingThread;
                        ObjectReference waitedMonitor = vmProxy.canGetCurrentContendedMonitor() ? thread.getThreadReference().currentContendedMonitor() : null;
                        if (waitedMonitor == null || !vmProxy.canGetMonitorInfo() || (blockingThread = waitedMonitor.owningThread()) == null || blockingThread.suspendCount() <= 1 || ThreadBlockedMonitor.this.getCurrentThread() == blockingThread) continue;
                        ThreadBlockedMonitor.onThreadBlocked(thread.getThreadReference(), blockingThread, ThreadBlockedMonitor.this.myProcess);
                    }
                }
                catch (IncompatibleThreadStateException e) {
                    LOG.info((Throwable)e);
                }
                finally {
                    vmProxy.getVirtualMachine().resume();
                }
            }
        });
    }
}

