/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListenerDiffViewerBase
extends DiffViewerBase {
    @NotNull
    private final DocumentListener myDocumentListener;
    @Nullable
    private final VirtualFileListener myFileListener;

    public ListenerDiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "<init>"));
        }
        super(context, request);
        this.myDocumentListener = this.createDocumentListener();
        this.myFileListener = this.createFileListener(request);
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.myFileListener != null) {
            VirtualFileManager.getInstance().addVirtualFileListener(this.myFileListener);
        }
        for (Document document : this.getDocuments()) {
            document.addDocumentListener(this.myDocumentListener);
        }
    }

    @Override
    protected void onDispose() {
        if (this.myFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(this.myFileListener);
        }
        for (Document document : this.getDocuments()) {
            document.removeDocumentListener(this.myDocumentListener);
        }
        super.onDispose();
    }

    @NotNull
    protected DocumentListener createDocumentListener() {
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent event) {
                ListenerDiffViewerBase.this.onBeforeDocumentChange(event);
            }

            public void documentChanged(DocumentEvent event) {
                ListenerDiffViewerBase.this.onDocumentChange(event);
            }
        };
        if (documentAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "createDocumentListener"));
        }
        return documentAdapter;
    }

    @Nullable
    protected VirtualFileListener createFileListener(@NotNull ContentDiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "createFileListener"));
        }
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(0);
        for (DiffContent content : request.getContents()) {
            if (!(content instanceof FileContent) || content instanceof DocumentContent) continue;
            files.add(((FileContent)content).getFile());
        }
        if (files.isEmpty()) {
            return null;
        }
        return new VirtualFileAdapter(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase$2", "contentsChanged"));
                }
                if (files.contains(event.getFile())) {
                    ListenerDiffViewerBase.this.onFileChange(event);
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase$2", "propertyChanged"));
                }
                if (files.contains(event.getFile())) {
                    ListenerDiffViewerBase.this.onFileChange((VirtualFileEvent)event);
                }
            }
        };
    }

    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "onDocumentChange"));
        }
        this.scheduleRediff();
    }

    protected void onBeforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "onBeforeDocumentChange"));
        }
    }

    protected void onFileChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "onFileChange"));
        }
        this.scheduleRediff();
    }

    @NotNull
    private Set<Document> getDocuments() {
        HashSet documents = new HashSet();
        for (DiffContent content : this.myRequest.getContents()) {
            if (!(content instanceof DocumentContent)) continue;
            documents.add(((DocumentContent)content).getDocument());
        }
        HashSet hashSet = documents;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "getDocuments"));
        }
        return hashSet;
    }
}

