/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.ProjectTopics;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.UnknownBeforeRunTaskProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RunManager", defaultStateAsResource=true, storages={@Storage(value="$WORKSPACE_FILE$")})
public class RunManagerImpl
extends RunManagerEx
implements PersistentStateComponent<Element>,
NamedComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance(RunManagerImpl.class);
    private final Project myProject;
    private final Map<String, ConfigurationType> myTypesByName;
    private final Map<String, RunnerAndConfigurationSettings> myTemplateConfigurationsMap;
    private final Map<String, RunnerAndConfigurationSettings> myConfigurations;
    private final Map<String, Boolean> mySharedConfigurations;
    private final Map<RunConfiguration, List<BeforeRunTask>> myConfigurationToBeforeTasksMap;
    @Nullable
    private String myLoadedSelectedConfigurationUniqueName;
    @Nullable
    private String mySelectedConfigurationId;
    private final Map<String, Icon> myIdToIcon;
    private final Map<String, Long> myIconCheckTimes;
    private final Map<String, Long> myIconCalcTime;
    @NonNls
    protected static final String CONFIGURATION = "configuration";
    protected static final String RECENT = "recent_temporary";
    private ConfigurationType[] myTypes;
    private final RunManagerConfig myConfig;
    @NonNls
    protected static final String NAME_ATTR = "name";
    @NonNls
    protected static final String SELECTED_ATTR = "selected";
    @NonNls
    private static final String METHOD = "method";
    @NonNls
    private static final String OPTION = "option";
    private List<Element> myUnknownElements;
    private final JDOMExternalizableStringList myOrder;
    private final ArrayList<RunConfiguration> myRecentlyUsedTemporaries;
    private boolean myOrdered;
    private final EventDispatcher<RunManagerListener> myDispatcher;
    private Map<Key<? extends BeforeRunTask>, BeforeRunTaskProvider> myBeforeStepsMap;
    private Map<String, Key<? extends BeforeRunTask>> myProviderKeysMap;

    public RunManagerImpl(@NotNull Project project2, @NotNull PropertiesComponent propertiesComponent) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/RunManagerImpl", "<init>"));
        }
        if (propertiesComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesComponent", "com/intellij/execution/impl/RunManagerImpl", "<init>"));
        }
        this.myTypesByName = new LinkedHashMap<String, ConfigurationType>();
        this.myTemplateConfigurationsMap = new TreeMap<String, RunnerAndConfigurationSettings>();
        this.myConfigurations = new LinkedHashMap<String, RunnerAndConfigurationSettings>();
        this.mySharedConfigurations = new THashMap();
        this.myConfigurationToBeforeTasksMap = new WeakHashMap();
        this.myLoadedSelectedConfigurationUniqueName = null;
        this.mySelectedConfigurationId = null;
        this.myIdToIcon = new HashMap();
        this.myIconCheckTimes = new HashMap();
        this.myIconCalcTime = Collections.synchronizedMap(new HashMap());
        this.myUnknownElements = null;
        this.myOrder = new JDOMExternalizableStringList();
        this.myRecentlyUsedTemporaries = new ArrayList();
        this.myOrdered = true;
        this.myDispatcher = EventDispatcher.create(RunManagerListener.class);
        this.myConfig = new RunManagerConfig(propertiesComponent);
        this.myProject = project2;
        this.initializeConfigurationTypes((ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions());
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                RunnerAndConfigurationSettings configuration = RunManagerImpl.this.getSelectedConfiguration();
                if (configuration != null) {
                    RunManagerImpl.this.myIconCheckTimes.remove(configuration.getUniqueID());
                }
            }
        });
    }

    public final void initializeConfigurationTypes(@NotNull ConfigurationType[] factories) {
        if (factories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factories", "com/intellij/execution/impl/RunManagerImpl", "initializeConfigurationTypes"));
        }
        Arrays.sort(factories, new Comparator<ConfigurationType>(){

            @Override
            public int compare(@NotNull ConfigurationType o1, @NotNull ConfigurationType o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/execution/impl/RunManagerImpl$2", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/execution/impl/RunManagerImpl$2", "compare"));
                }
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        ArrayList<ConfigurationType> types = new ArrayList<ConfigurationType>(Arrays.asList(factories));
        types.add((ConfigurationType)UnknownConfigurationType.INSTANCE);
        this.myTypes = types.toArray(new ConfigurationType[types.size()]);
        for (ConfigurationType type : factories) {
            this.myTypesByName.put(type.getId(), type);
        }
        UnknownConfigurationType broken = UnknownConfigurationType.INSTANCE;
        this.myTypesByName.put(broken.getId(), (ConfigurationType)broken);
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettings createConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.createConfiguration(this.doCreateConfiguration(name, factory, true), factory);
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        return runnerAndConfigurationSettings;
    }

    protected RunConfiguration doCreateConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory, boolean fromTemplate) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/execution/impl/RunManagerImpl", "doCreateConfiguration"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/impl/RunManagerImpl", "doCreateConfiguration"));
        }
        if (fromTemplate) {
            return factory.createConfiguration(name, this.getConfigurationTemplate(factory).getConfiguration());
        }
        RunConfiguration configuration = factory.createTemplateConfiguration(this.myProject, (RunManager)this);
        configuration.setName(name);
        return configuration;
    }

    @NotNull
    public RunnerAndConfigurationSettings createConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull ConfigurationFactory factory) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        RunnerAndConfigurationSettings template = this.getConfigurationTemplate(factory);
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this, runConfiguration, false);
        settings.importRunnerAndConfigurationSettings((RunnerAndConfigurationSettingsImpl)template);
        if (!this.mySharedConfigurations.containsKey(settings.getUniqueID())) {
            this.shareConfiguration(settings, this.isConfigurationShared(template));
        }
        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = settings;
        if (runnerAndConfigurationSettingsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        return runnerAndConfigurationSettingsImpl;
    }

    public void dispose() {
        this.myTemplateConfigurationsMap.clear();
    }

    @Override
    public RunManagerConfig getConfig() {
        return this.myConfig;
    }

    @NotNull
    public ConfigurationType[] getConfigurationFactories() {
        ConfigurationType[] configurationTypeArray = (ConfigurationType[])this.myTypes.clone();
        if (configurationTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationFactories"));
        }
        return configurationTypeArray;
    }

    public ConfigurationType[] getConfigurationFactories(boolean includeUnknown) {
        ConfigurationType[] configurationTypes = (ConfigurationType[])this.myTypes.clone();
        if (!includeUnknown) {
            ArrayList<ConfigurationType> types = new ArrayList<ConfigurationType>();
            for (ConfigurationType configurationType : configurationTypes) {
                if (configurationType instanceof UnknownConfigurationType) continue;
                types.add(configurationType);
            }
            return types.toArray(new ConfigurationType[types.size()]);
        }
        return configurationTypes;
    }

    @NotNull
    public List<RunConfiguration> getConfigurationsList(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationsList"));
        }
        List result = null;
        for (RunnerAndConfigurationSettings settings : this.getSortedConfigurations()) {
            RunConfiguration configuration = settings.getConfiguration();
            if (!type.getId().equals(configuration.getType().getId())) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(configuration);
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationsList"));
        }
        return list;
    }

    @NotNull
    public List<RunConfiguration> getAllConfigurationsList() {
        Collection<RunnerAndConfigurationSettings> sortedConfigurations = this.getSortedConfigurations();
        if (sortedConfigurations.isEmpty()) {
            List<RunConfiguration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getAllConfigurationsList"));
            }
            return list;
        }
        ArrayList<RunConfiguration> result = new ArrayList<RunConfiguration>(sortedConfigurations.size());
        for (RunnerAndConfigurationSettings settings : sortedConfigurations) {
            result.add(settings.getConfiguration());
        }
        ArrayList<RunConfiguration> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getAllConfigurationsList"));
        }
        return arrayList;
    }

    @NotNull
    public RunConfiguration[] getAllConfigurations() {
        List<RunConfiguration> list = this.getAllConfigurationsList();
        RunConfiguration[] runConfigurationArray = list.toArray(new RunConfiguration[list.size()]);
        if (runConfigurationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getAllConfigurations"));
        }
        return runConfigurationArray;
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getAllSettings() {
        ArrayList<RunnerAndConfigurationSettings> arrayList = new ArrayList<RunnerAndConfigurationSettings>(this.getSortedConfigurations());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getAllSettings"));
        }
        return arrayList;
    }

    @Nullable
    public RunnerAndConfigurationSettings getSettings(@Nullable RunConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        for (RunnerAndConfigurationSettings settings : this.getSortedConfigurations()) {
            if (settings.getConfiguration() != configuration) continue;
            return settings;
        }
        return null;
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettingsList"));
        }
        SmartList result = new SmartList();
        for (RunnerAndConfigurationSettings configuration : this.getSortedConfigurations()) {
            ConfigurationType configurationType = configuration.getType();
            if (configurationType == null || !type.getId().equals(configurationType.getId())) continue;
            result.add(configuration);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettingsList"));
        }
        return smartList;
    }

    @NotNull
    public RunnerAndConfigurationSettings[] getConfigurationSettings(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettings"));
        }
        List<RunnerAndConfigurationSettings> list = this.getConfigurationSettingsList(type);
        RunnerAndConfigurationSettings[] runnerAndConfigurationSettingsArray = list.toArray(new RunnerAndConfigurationSettings[list.size()]);
        if (runnerAndConfigurationSettingsArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettings"));
        }
        return runnerAndConfigurationSettingsArray;
    }

    @NotNull
    public RunConfiguration[] getConfigurations(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/impl/RunManagerImpl", "getConfigurations"));
        }
        RunnerAndConfigurationSettings[] settings = this.getConfigurationSettings(type);
        RunConfiguration[] result = new RunConfiguration[settings.length];
        for (int i = 0; i < settings.length; ++i) {
            result[i] = settings[i].getConfiguration();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurations"));
        }
        return result;
    }

    @Override
    @NotNull
    public Map<String, List<RunnerAndConfigurationSettings>> getStructure(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/impl/RunManagerImpl", "getStructure"));
        }
        LinkedHashMap<String, ArrayList<RunnerAndConfigurationSettings>> map = new LinkedHashMap<String, ArrayList<RunnerAndConfigurationSettings>>();
        ArrayList<RunnerAndConfigurationSettings> typeList = new ArrayList<RunnerAndConfigurationSettings>();
        List<RunnerAndConfigurationSettings> settings = this.getConfigurationSettingsList(type);
        for (RunnerAndConfigurationSettings setting : settings) {
            String folderName = setting.getFolderName();
            if (folderName == null) {
                typeList.add(setting);
                continue;
            }
            ArrayList<RunnerAndConfigurationSettings> list = (ArrayList<RunnerAndConfigurationSettings>)map.get(folderName);
            if (list == null) {
                list = new ArrayList<RunnerAndConfigurationSettings>();
                map.put(folderName, list);
            }
            list.add(setting);
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        result.put(null, Collections.unmodifiableList(typeList));
        Map<String, List<RunnerAndConfigurationSettings>> map2 = Collections.unmodifiableMap(result);
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getStructure"));
        }
        return map2;
    }

    @NotNull
    public RunnerAndConfigurationSettings getConfigurationTemplate(@NotNull ConfigurationFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationTemplate"));
        }
        RunnerAndConfigurationSettings template = this.myTemplateConfigurationsMap.get(factory.getType().getId() + "." + factory.getName());
        if (template == null) {
            template = new RunnerAndConfigurationSettingsImpl(this, factory.createTemplateConfiguration(this.myProject, (RunManager)this), true);
            template.setSingleton(factory.isConfigurationSingletonByDefault());
            if (template.getConfiguration() instanceof UnknownRunConfiguration) {
                ((UnknownRunConfiguration)template.getConfiguration()).setDoNotStore(true);
            }
            this.myTemplateConfigurationsMap.put(factory.getType().getId() + "." + factory.getName(), template);
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = template;
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationTemplate"));
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    public void addConfiguration(RunnerAndConfigurationSettings settings, boolean shared, List<BeforeRunTask> tasks, boolean addEnabledTemplateTasksIfAbsent) {
        String existingId = this.findExistingConfigurationId(settings);
        String newId = settings.getUniqueID();
        RunnerAndConfigurationSettings existingSettings = null;
        if (existingId != null) {
            existingSettings = this.myConfigurations.remove(existingId);
            this.mySharedConfigurations.remove(existingId);
        }
        if (this.mySelectedConfigurationId != null && this.mySelectedConfigurationId.equals(existingId)) {
            this.setSelectedConfigurationId(newId);
        }
        this.myConfigurations.put(newId, settings);
        RunConfiguration configuration = settings.getConfiguration();
        if (existingId == null) {
            this.refreshUsagesList((RunProfile)configuration);
        }
        this.checkRecentsLimit();
        this.mySharedConfigurations.put(newId, shared);
        this.setBeforeRunTasks(configuration, tasks, addEnabledTemplateTasksIfAbsent);
        if (existingSettings == settings) {
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationChanged(settings, existingId);
        } else {
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationAdded(settings);
        }
    }

    public void refreshUsagesList(RunProfile profile) {
        if (!(profile instanceof RunConfiguration)) {
            return;
        }
        RunnerAndConfigurationSettings settings = this.getSettings((RunConfiguration)profile);
        if (settings != null && settings.isTemporary()) {
            this.myRecentlyUsedTemporaries.remove((RunConfiguration)profile);
            this.myRecentlyUsedTemporaries.add(0, (RunConfiguration)profile);
            this.trimUsagesListToLimit();
        }
    }

    private void trimUsagesListToLimit() {
        while (this.myRecentlyUsedTemporaries.size() > this.getConfig().getRecentsLimit()) {
            this.myRecentlyUsedTemporaries.remove(this.myRecentlyUsedTemporaries.size() - 1);
        }
    }

    void checkRecentsLimit() {
        this.trimUsagesListToLimit();
        SmartList removed = new SmartList();
        block0: while (this.getTempConfigurationsList().size() > this.getConfig().getRecentsLimit()) {
            Iterator<RunnerAndConfigurationSettings> it = this.myConfigurations.values().iterator();
            while (it.hasNext()) {
                RunnerAndConfigurationSettings configuration = it.next();
                if (!configuration.isTemporary() || this.myRecentlyUsedTemporaries.contains(configuration.getConfiguration())) continue;
                removed.add(configuration);
                it.remove();
                continue block0;
            }
        }
        this.fireRunConfigurationsRemoved((List<RunnerAndConfigurationSettings>)removed);
    }

    public void setOrdered(boolean ordered) {
        this.myOrdered = ordered;
    }

    public void saveOrder() {
        this.myOrder.clear();
        for (RunnerAndConfigurationSettings each : this.myConfigurations.values()) {
            if (each.getType() instanceof UnknownConfigurationType) continue;
            this.myOrder.add((Object)each.getUniqueID());
        }
    }

    @Override
    public void removeConfiguration(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            return;
        }
        Iterator<RunnerAndConfigurationSettings> it = this.getSortedConfigurations().iterator();
        while (it.hasNext()) {
            RunnerAndConfigurationSettings configuration = it.next();
            if (!configuration.equals(settings)) continue;
            if (this.mySelectedConfigurationId != null && this.mySelectedConfigurationId == settings.getUniqueID()) {
                this.setSelectedConfiguration(null);
            }
            it.remove();
            this.mySharedConfigurations.remove(settings.getUniqueID());
            this.myConfigurationToBeforeTasksMap.remove(settings.getConfiguration());
            this.myRecentlyUsedTemporaries.remove(settings.getConfiguration());
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationRemoved(configuration);
            break;
        }
    }

    @Nullable
    public RunnerAndConfigurationSettings getSelectedConfiguration() {
        if (this.mySelectedConfigurationId == null && this.myLoadedSelectedConfigurationUniqueName != null) {
            this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        }
        return this.mySelectedConfigurationId == null ? null : this.myConfigurations.get(this.mySelectedConfigurationId);
    }

    public void setSelectedConfiguration(@Nullable RunnerAndConfigurationSettings settings) {
        this.setSelectedConfigurationId(settings == null ? null : settings.getUniqueID());
        this.fireRunConfigurationSelected();
    }

    private void setSelectedConfigurationId(@Nullable String id) {
        this.mySelectedConfigurationId = id;
        if (this.mySelectedConfigurationId != null) {
            this.myLoadedSelectedConfigurationUniqueName = null;
        }
    }

    @Override
    @NotNull
    public Collection<RunnerAndConfigurationSettings> getSortedConfigurations() {
        if (this.myOrdered) {
            Collection<RunnerAndConfigurationSettings> collection = this.myConfigurations.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getSortedConfigurations"));
            }
            return collection;
        }
        ArrayList<Pair> order = new ArrayList<Pair>(this.myConfigurations.size());
        SmartList folderNames = new SmartList();
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myConfigurations.values()) {
            order.add(Pair.create((Object)runnerAndConfigurationSettings.getUniqueID(), (Object)runnerAndConfigurationSettings));
            String folderName = runnerAndConfigurationSettings.getFolderName();
            if (folderName == null || folderNames.contains(folderName)) continue;
            folderNames.add(folderName);
        }
        folderNames.add(null);
        this.myConfigurations.clear();
        if (this.myOrder.isEmpty()) {
            Collections.sort(order, new Comparator<Pair<String, RunnerAndConfigurationSettings>>(){

                @Override
                public int compare(@NotNull Pair<String, RunnerAndConfigurationSettings> o1, @NotNull Pair<String, RunnerAndConfigurationSettings> o2) {
                    boolean temporary2;
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/execution/impl/RunManagerImpl$3", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/execution/impl/RunManagerImpl$3", "compare"));
                    }
                    boolean temporary1 = ((RunnerAndConfigurationSettings)o1.getSecond()).isTemporary();
                    if (temporary1 == (temporary2 = ((RunnerAndConfigurationSettings)o2.getSecond()).isTemporary())) {
                        return ((String)o1.first).compareTo((String)o2.first);
                    }
                    return temporary1 ? 1 : -1;
                }
            });
        } else {
            Collections.sort(order, new Comparator<Pair<String, RunnerAndConfigurationSettings>>((List)folderNames){
                final /* synthetic */ List val$folderNames;
                {
                    this.val$folderNames = list;
                }

                @Override
                public int compare(@NotNull Pair<String, RunnerAndConfigurationSettings> o1, @NotNull Pair<String, RunnerAndConfigurationSettings> o2) {
                    boolean temporary2;
                    int i2;
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/execution/impl/RunManagerImpl$4", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/execution/impl/RunManagerImpl$4", "compare"));
                    }
                    int i1 = this.val$folderNames.indexOf(((RunnerAndConfigurationSettings)o1.getSecond()).getFolderName());
                    if (i1 != (i2 = this.val$folderNames.indexOf(((RunnerAndConfigurationSettings)o2.getSecond()).getFolderName()))) {
                        return i1 - i2;
                    }
                    boolean temporary1 = ((RunnerAndConfigurationSettings)o1.getSecond()).isTemporary();
                    if (temporary1 == (temporary2 = ((RunnerAndConfigurationSettings)o2.getSecond()).isTemporary())) {
                        int index1 = RunManagerImpl.this.myOrder.indexOf(o1.first);
                        int index2 = RunManagerImpl.this.myOrder.indexOf(o2.first);
                        if (index1 == -1 && index2 == -1) {
                            return ((RunnerAndConfigurationSettings)o1.second).getName().compareTo(((RunnerAndConfigurationSettings)o2.second).getName());
                        }
                        return index1 - index2;
                    }
                    return temporary1 ? 1 : -1;
                }
            });
        }
        for (Pair pair : order) {
            RunnerAndConfigurationSettings setting = (RunnerAndConfigurationSettings)pair.second;
            this.myConfigurations.put(setting.getUniqueID(), setting);
        }
        this.myOrdered = true;
        Collection<RunnerAndConfigurationSettings> collection = this.myConfigurations.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getSortedConfigurations"));
        }
        return collection;
    }

    public static boolean canRunConfiguration(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/impl/RunManagerImpl", "canRunConfiguration"));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        return runnerAndConfigurationSettings != null && RunManagerImpl.canRunConfiguration(runnerAndConfigurationSettings, environment.getExecutor());
    }

    public static boolean canRunConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", CONFIGURATION, "com/intellij/execution/impl/RunManagerImpl", "canRunConfiguration"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/impl/RunManagerImpl", "canRunConfiguration"));
        }
        try {
            configuration.checkSettings(executor);
        }
        catch (IndexNotReadyException ignored) {
            return Registry.is((String)"dumb.aware.run.configurations");
        }
        catch (RuntimeConfigurationError ignored) {
            return false;
        }
        catch (RuntimeConfigurationException ignored) {
            return true;
        }
        return true;
    }

    @Nullable
    public Element getState() {
        Element parentNode = new Element("state");
        this.writeContext(parentNode);
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myTemplateConfigurationsMap.values()) {
            if (runnerAndConfigurationSettings.getConfiguration() instanceof UnknownRunConfiguration && ((UnknownRunConfiguration)runnerAndConfigurationSettings.getConfiguration()).isDoNotStore()) continue;
            this.addConfigurationElement(parentNode, runnerAndConfigurationSettings);
        }
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.getStableConfigurations(false)) {
            this.addConfigurationElement(parentNode, runnerAndConfigurationSettings);
        }
        JDOMExternalizableStringList order = null;
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myConfigurations.values()) {
            if (runnerAndConfigurationSettings.getType() instanceof UnknownConfigurationType) continue;
            if (order == null) {
                order = new JDOMExternalizableStringList();
            }
            order.add((Object)runnerAndConfigurationSettings.getUniqueID());
        }
        if (order != null) {
            order.writeExternal(parentNode);
        }
        JDOMExternalizableStringList jDOMExternalizableStringList = new JDOMExternalizableStringList();
        for (RunConfiguration each : this.myRecentlyUsedTemporaries) {
            RunnerAndConfigurationSettings settings;
            if (each.getType() instanceof UnknownConfigurationType || (settings = this.getSettings(each)) == null) continue;
            jDOMExternalizableStringList.add((Object)settings.getUniqueID());
        }
        if (!jDOMExternalizableStringList.isEmpty()) {
            Element element = new Element(RECENT);
            parentNode.addContent(element);
            jDOMExternalizableStringList.writeExternal(element);
        }
        if (this.myUnknownElements != null) {
            for (Element unloadedElement : this.myUnknownElements) {
                parentNode.addContent(unloadedElement.clone());
            }
        }
        return parentNode;
    }

    public void writeContext(@NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/execution/impl/RunManagerImpl", "writeContext"));
        }
        for (RunnerAndConfigurationSettings configurationSettings : this.myConfigurations.values()) {
            if (!configurationSettings.isTemporary()) continue;
            this.addConfigurationElement(parentNode, configurationSettings, CONFIGURATION);
        }
        RunnerAndConfigurationSettings selected = this.getSelectedConfiguration();
        if (selected != null) {
            parentNode.setAttribute(SELECTED_ATTR, selected.getUniqueID());
        }
    }

    void addConfigurationElement(@NotNull Element parentNode, RunnerAndConfigurationSettings template) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/execution/impl/RunManagerImpl", "addConfigurationElement"));
        }
        this.addConfigurationElement(parentNode, template, CONFIGURATION);
    }

    private void addConfigurationElement(@NotNull Element parentNode, RunnerAndConfigurationSettings settings, String elementType) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/execution/impl/RunManagerImpl", "addConfigurationElement"));
        }
        Element configurationElement = new Element(elementType);
        parentNode.addContent(configurationElement);
        try {
            ((RunnerAndConfigurationSettingsImpl)settings).writeExternal(configurationElement);
        }
        catch (WriteExternalException e) {
            throw new RuntimeException(e);
        }
        if (settings.getConfiguration() instanceof UnknownRunConfiguration) {
            return;
        }
        ArrayList<BeforeRunTask> tasks = new ArrayList<BeforeRunTask>(this.getBeforeRunTasks(settings.getConfiguration()));
        THashMap templateTasks = new THashMap();
        List<BeforeRunTask> beforeRunTasks = settings.isTemplate() ? this.getHardcodedBeforeRunTasks(settings.getConfiguration()) : this.getBeforeRunTasks(this.getConfigurationTemplate(settings.getFactory()).getConfiguration());
        for (BeforeRunTask templateTask : beforeRunTasks) {
            templateTasks.put(templateTask.getProviderId(), templateTask);
            if (!templateTask.isEnabled()) continue;
            boolean found = false;
            for (BeforeRunTask realTask : tasks) {
                if (realTask.getProviderId() != templateTask.getProviderId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            BeforeRunTask clone = templateTask.clone();
            clone.setEnabled(false);
            tasks.add(0, clone);
        }
        Element methodsElement = new Element(METHOD);
        int size = tasks.size();
        for (int i = 0; i < size; ++i) {
            BeforeRunTask task = (BeforeRunTask)tasks.get(i);
            int j = 0;
            BeforeRunTask templateTask = null;
            for (Map.Entry entry : templateTasks.entrySet()) {
                if (entry.getKey() == task.getProviderId()) {
                    templateTask = (BeforeRunTask)entry.getValue();
                    break;
                }
                ++j;
            }
            if (task.equals(templateTask) && i == j) continue;
            Element child = new Element(OPTION);
            child.setAttribute(NAME_ATTR, task.getProviderId().toString());
            task.writeExternal(child);
            methodsElement.addContent(child);
        }
        configurationElement.addContent(methodsElement);
    }

    public void loadState(Element parentNode) {
        this.clear(false);
        List children2 = parentNode.getChildren(CONFIGURATION);
        Element[] sortedElements = children2.toArray(new Element[children2.size()]);
        Arrays.sort(sortedElements, new Comparator<Element>(){

            @Override
            public int compare(@NotNull Element a, @NotNull Element b) {
                boolean bDefault;
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/execution/impl/RunManagerImpl$5", "compare"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/execution/impl/RunManagerImpl$5", "compare"));
                }
                boolean aDefault = Boolean.valueOf(a.getAttributeValue("default", "false"));
                return aDefault == (bDefault = Boolean.valueOf(b.getAttributeValue("default", "false")).booleanValue()) ? 0 : (aDefault ? -1 : 1);
            }
        });
        for (Element element : sortedElements) {
            RunnerAndConfigurationSettings configurationSettings;
            try {
                configurationSettings = this.loadConfiguration(element, false);
            }
            catch (ProcessCanceledException e) {
                configurationSettings = null;
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (configurationSettings != null) continue;
            if (this.myUnknownElements == null) {
                this.myUnknownElements = new SmartList();
            }
            this.myUnknownElements.add((Element)element.detach());
        }
        this.myOrder.readExternal(parentNode);
        this.readList(this.myOrder);
        this.myRecentlyUsedTemporaries.clear();
        Element recentNode = parentNode.getChild(RECENT);
        if (recentNode != null) {
            JDOMExternalizableStringList list = new JDOMExternalizableStringList();
            list.readExternal(recentNode);
            this.readList(list);
            for (String name : list) {
                RunnerAndConfigurationSettings settings = this.myConfigurations.get(name);
                if (settings == null) continue;
                this.myRecentlyUsedTemporaries.add(settings.getConfiguration());
            }
        }
        this.myOrdered = false;
        this.myLoadedSelectedConfigurationUniqueName = parentNode.getAttributeValue(SELECTED_ATTR);
        this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        this.fireBeforeRunTasksUpdated();
        this.fireRunConfigurationSelected();
    }

    private void readList(@NotNull JDOMExternalizableStringList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/impl/RunManagerImpl", "readList"));
        }
        block0: for (int i = 0; i < list.size(); ++i) {
            for (RunnerAndConfigurationSettings settings : this.myConfigurations.values()) {
                RunConfiguration configuration = settings.getConfiguration();
                if (configuration == null || !((String)list.get(i)).equals(configuration.getType().getDisplayName() + "." + configuration.getName() + (configuration instanceof UnknownRunConfiguration ? Integer.valueOf(configuration.getUniqueID()) : ""))) continue;
                list.set(i, (Object)settings.getUniqueID());
                continue block0;
            }
        }
    }

    public void readContext(Element parentNode) throws InvalidDataException {
        this.myLoadedSelectedConfigurationUniqueName = parentNode.getAttributeValue(SELECTED_ATTR);
        for (Object aChildren : parentNode.getChildren()) {
            Element element = (Element)aChildren;
            RunnerAndConfigurationSettings config = this.loadConfiguration(element, false);
            if (this.myLoadedSelectedConfigurationUniqueName != null || config == null || !Boolean.valueOf(element.getAttributeValue(SELECTED_ATTR)).booleanValue()) continue;
            this.myLoadedSelectedConfigurationUniqueName = config.getUniqueID();
        }
        this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        this.fireRunConfigurationSelected();
    }

    @Nullable
    private String findExistingConfigurationId(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null) {
            for (Map.Entry<String, RunnerAndConfigurationSettings> entry : this.myConfigurations.entrySet()) {
                if (entry.getValue() != settings) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void clearAll() {
        this.clear(true);
        this.myTypesByName.clear();
        this.initializeConfigurationTypes(new ConfigurationType[0]);
    }

    private void clear(boolean allConfigurations) {
        Object configurations;
        if (allConfigurations) {
            this.myConfigurations.clear();
            this.mySharedConfigurations.clear();
            this.myConfigurationToBeforeTasksMap.clear();
            this.mySelectedConfigurationId = null;
            configurations = new ArrayList<RunnerAndConfigurationSettings>(this.myConfigurations.values());
        } else {
            configurations = new SmartList();
            Iterator<RunnerAndConfigurationSettings> iterator = this.myConfigurations.values().iterator();
            while (iterator.hasNext()) {
                RunnerAndConfigurationSettings configuration = iterator.next();
                if (!configuration.isTemporary() && this.isConfigurationShared(configuration)) continue;
                iterator.remove();
                this.mySharedConfigurations.remove(configuration.getUniqueID());
                this.myConfigurationToBeforeTasksMap.remove(configuration.getConfiguration());
                configurations.add(configuration);
            }
            if (this.mySelectedConfigurationId != null && this.myConfigurations.containsKey(this.mySelectedConfigurationId)) {
                this.mySelectedConfigurationId = null;
            }
        }
        this.myUnknownElements = null;
        this.myTemplateConfigurationsMap.clear();
        this.myLoadedSelectedConfigurationUniqueName = null;
        this.myIdToIcon.clear();
        this.myIconCheckTimes.clear();
        this.myIconCalcTime.clear();
        this.myRecentlyUsedTemporaries.clear();
        this.fireRunConfigurationsRemoved((List<RunnerAndConfigurationSettings>)configurations);
    }

    @Nullable
    public RunnerAndConfigurationSettings loadConfiguration(@NotNull Element element, boolean isShared) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/RunManagerImpl", "loadConfiguration"));
        }
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this);
        try {
            settings.readExternal(element);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        ConfigurationFactory factory = settings.getFactory();
        if (factory == null) {
            return null;
        }
        List<BeforeRunTask> tasks = this.readStepsBeforeRun(element.getChild(METHOD), settings);
        if (settings.isTemplate()) {
            this.myTemplateConfigurationsMap.put(factory.getType().getId() + "." + factory.getName(), settings);
            this.setBeforeRunTasks(settings.getConfiguration(), tasks, true);
        } else {
            this.addConfiguration(settings, isShared, tasks, true);
            if (Boolean.valueOf(element.getAttributeValue(SELECTED_ATTR)).booleanValue()) {
                this.setSelectedConfiguration(settings);
            }
        }
        return settings;
    }

    @NotNull
    private List<BeforeRunTask> readStepsBeforeRun(@Nullable Element child, @NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/RunManagerImpl", "readStepsBeforeRun"));
        }
        List result = null;
        if (child != null) {
            for (Element methodElement : child.getChildren(OPTION)) {
                Key<? extends BeforeRunTask> id = this.getProviderKey(methodElement.getAttributeValue(NAME_ATTR));
                BeforeRunTask beforeRunTask = this.getProvider(id).createTask(settings.getConfiguration());
                if (beforeRunTask == null) continue;
                beforeRunTask.readExternal(methodElement);
                if (result == null) {
                    result = new SmartList();
                }
                result.add(beforeRunTask);
            }
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "readStepsBeforeRun"));
        }
        return list;
    }

    @Nullable
    public ConfigurationType getConfigurationType(String typeName) {
        return this.myTypesByName.get(typeName);
    }

    @Nullable
    public ConfigurationFactory getFactory(String typeName, String factoryName) {
        return this.getFactory(typeName, factoryName, false);
    }

    @Nullable
    public ConfigurationFactory getFactory(String typeName, String factoryName, boolean checkUnknown) {
        ConfigurationType type = this.myTypesByName.get(typeName);
        if (type == null && checkUnknown && typeName != null) {
            UnknownFeaturesCollector.getInstance(this.myProject).registerUnknownRunConfiguration(typeName);
        }
        if (factoryName == null) {
            factoryName = type != null ? type.getConfigurationFactories()[0].getName() : null;
        }
        return this.findFactoryOfTypeNameByName(typeName, factoryName);
    }

    @Nullable
    private ConfigurationFactory findFactoryOfTypeNameByName(String typeName, String factoryName) {
        ConfigurationType type = this.myTypesByName.get(typeName);
        if (type == null) {
            type = this.myTypesByName.get("Unknown");
        }
        return RunManagerImpl.findFactoryOfTypeByName(type, factoryName);
    }

    @Nullable
    private static ConfigurationFactory findFactoryOfTypeByName(ConfigurationType type, String factoryName) {
        ConfigurationFactory[] factories;
        if (factoryName == null) {
            return null;
        }
        if (type instanceof UnknownConfigurationType) {
            return type.getConfigurationFactories()[0];
        }
        for (ConfigurationFactory factory : factories = type.getConfigurationFactories()) {
            if (!factoryName.equals(factory.getName())) continue;
            return factory;
        }
        return null;
    }

    @NotNull
    public String getComponentName() {
        if ("RunManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getComponentName"));
        }
        return "RunManager";
    }

    @Override
    public void setTemporaryConfiguration(@Nullable RunnerAndConfigurationSettings tempConfiguration) {
        if (tempConfiguration == null) {
            return;
        }
        tempConfiguration.setTemporary(true);
        this.addConfiguration(tempConfiguration, this.isConfigurationShared(tempConfiguration), this.getBeforeRunTasks(tempConfiguration.getConfiguration()), false);
        this.setSelectedConfiguration(tempConfiguration);
    }

    @NotNull
    Collection<RunnerAndConfigurationSettings> getStableConfigurations(boolean shared) {
        List result = null;
        for (RunnerAndConfigurationSettings configuration : this.myConfigurations.values()) {
            if (configuration.isTemporary() || this.isConfigurationShared(configuration) != shared) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(configuration);
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getStableConfigurations"));
        }
        return list;
    }

    @NotNull
    Collection<? extends RunnerAndConfigurationSettings> getConfigurationSettings() {
        Collection<RunnerAndConfigurationSettings> collection = this.myConfigurations.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettings"));
        }
        return collection;
    }

    public boolean isTemporary(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", CONFIGURATION, "com/intellij/execution/impl/RunManagerImpl", "isTemporary"));
        }
        return Arrays.asList(this.getTempConfigurations()).contains(configuration);
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getTempConfigurationsList() {
        List configurations = ContainerUtil.filter(this.myConfigurations.values(), (Condition)new Condition<RunnerAndConfigurationSettings>(){

            public boolean value(RunnerAndConfigurationSettings settings) {
                return settings.isTemporary();
            }
        });
        List<RunnerAndConfigurationSettings> list = Collections.unmodifiableList(configurations);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getTempConfigurationsList"));
        }
        return list;
    }

    @NotNull
    public RunConfiguration[] getTempConfigurations() {
        List<RunnerAndConfigurationSettings> list = this.getTempConfigurationsList();
        RunConfiguration[] result = new RunConfiguration[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).getConfiguration();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getTempConfigurations"));
        }
        return result;
    }

    public void makeStable(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/RunManagerImpl", "makeStable"));
        }
        settings.setTemporary(false);
        this.myRecentlyUsedTemporaries.remove(settings.getConfiguration());
        if (!this.myOrder.isEmpty()) {
            this.setOrdered(false);
        }
        this.fireRunConfigurationChanged(settings);
    }

    public void makeStable(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", CONFIGURATION, "com/intellij/execution/impl/RunManagerImpl", "makeStable"));
        }
        RunnerAndConfigurationSettings settings = this.getSettings(configuration);
        if (settings != null) {
            this.makeStable(settings);
        }
    }

    @NotNull
    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationFactory type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/execution/impl/RunManagerImpl", "createRunConfiguration"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/impl/RunManagerImpl", "createRunConfiguration"));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.createConfiguration(name, type);
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "createRunConfiguration"));
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    public boolean isConfigurationShared(RunnerAndConfigurationSettings settings) {
        Boolean shared = this.mySharedConfigurations.get(settings.getUniqueID());
        if (shared == null) {
            RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
            shared = this.mySharedConfigurations.get(template.getUniqueID());
        }
        return shared != null && shared != false;
    }

    @Override
    @NotNull
    public <T extends BeforeRunTask> List<T> getBeforeRunTasks(Key<T> taskProviderID) {
        ArrayList<BeforeRunTask> tasks = new ArrayList<BeforeRunTask>();
        ArrayList<RunnerAndConfigurationSettings> checkedTemplates = new ArrayList<RunnerAndConfigurationSettings>();
        ArrayList<RunnerAndConfigurationSettings> settingsList = new ArrayList<RunnerAndConfigurationSettings>(this.myConfigurations.values());
        for (RunnerAndConfigurationSettings settings : settingsList) {
            List<BeforeRunTask> runTasks = this.getBeforeRunTasks(settings.getConfiguration());
            for (BeforeRunTask task : runTasks) {
                if (task != null && task.isEnabled() && task.getProviderId() == taskProviderID) {
                    tasks.add(task);
                    continue;
                }
                RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
                if (checkedTemplates.contains(template)) continue;
                checkedTemplates.add(template);
                List<BeforeRunTask> templateTasks = this.getBeforeRunTasks(template.getConfiguration());
                for (BeforeRunTask templateTask : templateTasks) {
                    if (templateTask == null || !templateTask.isEnabled() || templateTask.getProviderId() != taskProviderID) continue;
                    tasks.add(templateTask);
                }
            }
        }
        ArrayList<BeforeRunTask> arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
        }
        return arrayList;
    }

    @Override
    public Icon getConfigurationIcon(final @NotNull RunnerAndConfigurationSettings settings) {
        Icon icon;
        String selectedId;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationIcon"));
        }
        final String uniqueID = settings.getUniqueID();
        RunnerAndConfigurationSettings selectedConfiguration = this.getSelectedConfiguration();
        String string = selectedId = selectedConfiguration != null ? selectedConfiguration.getUniqueID() : "";
        if (selectedId.equals(uniqueID)) {
            Long lastCheckTime = this.myIconCheckTimes.get(uniqueID);
            Long calcTime = this.myIconCalcTime.get(uniqueID);
            if (calcTime == null || calcTime < 150L) {
                calcTime = 150L;
            }
            if (lastCheckTime == null || System.currentTimeMillis() - lastCheckTime > calcTime * 10L) {
                this.myIdToIcon.remove(uniqueID);
            }
        }
        if ((icon = this.myIdToIcon.get(uniqueID)) == null) {
            icon = IconDeferrer.getInstance().deferAutoUpdatable(settings.getConfiguration().getIcon(), (Object)(this.myProject.hashCode() ^ settings.hashCode()), (Function)new Function<Integer, Icon>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Icon fun(Integer param) {
                    Icon icon;
                    if (RunManagerImpl.this.myProject.isDisposed()) {
                        return null;
                    }
                    RunManagerImpl.this.myIconCalcTime.remove(uniqueID);
                    long startTime = System.currentTimeMillis();
                    if (DumbService.isDumb((Project)RunManagerImpl.this.myProject) && !Registry.is((String)"dumb.aware.run.configurations")) {
                        icon = IconLoader.getDisabledIcon((Icon)ProgramRunnerUtil.getRawIcon(settings));
                        if (settings.isTemporary()) {
                            icon = ProgramRunnerUtil.getTemporaryIcon(icon);
                        }
                    } else {
                        try {
                            DumbService.getInstance((Project)RunManagerImpl.this.myProject).setAlternativeResolveEnabled(true);
                            settings.checkSettings();
                            icon = ProgramRunnerUtil.getConfigurationIcon(settings, false);
                        }
                        catch (IndexNotReadyException e) {
                            icon = ProgramRunnerUtil.getConfigurationIcon(settings, !Registry.is((String)"dumb.aware.run.configurations"));
                        }
                        catch (RuntimeConfigurationException ignored) {
                            icon = ProgramRunnerUtil.getConfigurationIcon(settings, true);
                        }
                        finally {
                            DumbService.getInstance((Project)RunManagerImpl.this.myProject).setAlternativeResolveEnabled(false);
                        }
                    }
                    RunManagerImpl.this.myIconCalcTime.put(uniqueID, System.currentTimeMillis() - startTime);
                    return icon;
                }
            });
            this.myIdToIcon.put(uniqueID, icon);
            this.myIconCheckTimes.put(uniqueID, System.currentTimeMillis());
        }
        return icon;
    }

    public RunnerAndConfigurationSettings getConfigurationById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationById"));
        }
        return this.myConfigurations.get(id);
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings findConfigurationByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (RunnerAndConfigurationSettings each : this.myConfigurations.values()) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public RunnerAndConfigurationSettings findConfigurationByTypeAndName(@NotNull String typeId, @NotNull String name) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/execution/impl/RunManagerImpl", "findConfigurationByTypeAndName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/execution/impl/RunManagerImpl", "findConfigurationByTypeAndName"));
        }
        for (RunnerAndConfigurationSettings settings : this.getSortedConfigurations()) {
            ConfigurationType t = settings.getType();
            if (t == null || !typeId.equals(t.getId()) || !name.equals(settings.getName())) continue;
            return settings;
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends BeforeRunTask> List<T> getBeforeRunTasks(RunConfiguration settings, Key<T> taskProviderID) {
        if (settings instanceof WrappingRunConfiguration) {
            List<T> list = this.getBeforeRunTasks(((WrappingRunConfiguration)settings).getPeer(), taskProviderID);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
            }
            return list;
        }
        List<BeforeRunTask> tasks = this.myConfigurationToBeforeTasksMap.get(settings);
        if (tasks == null) {
            tasks = this.getBeforeRunTasks(settings);
            this.myConfigurationToBeforeTasksMap.put(settings, tasks);
        }
        SmartList result = new SmartList();
        for (BeforeRunTask task : tasks) {
            if (task.getProviderId() != taskProviderID) continue;
            result.add(task);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<BeforeRunTask> getBeforeRunTasks(RunConfiguration settings) {
        if (settings instanceof WrappingRunConfiguration) {
            List<BeforeRunTask> list = this.getBeforeRunTasks(((WrappingRunConfiguration)settings).getPeer());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
            }
            return list;
        }
        List<BeforeRunTask> tasks = this.myConfigurationToBeforeTasksMap.get(settings);
        List<BeforeRunTask> list = tasks == null ? this.getTemplateBeforeRunTasks(settings) : RunManagerImpl.getCopies(tasks);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
        }
        return list;
    }

    private List<BeforeRunTask> getTemplateBeforeRunTasks(@NotNull RunConfiguration settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/RunManagerImpl", "getTemplateBeforeRunTasks"));
        }
        RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
        List<BeforeRunTask> templateTasks = this.myConfigurationToBeforeTasksMap.get(template.getConfiguration());
        return templateTasks == null ? this.getHardcodedBeforeRunTasks(settings) : RunManagerImpl.getCopies(templateTasks);
    }

    @NotNull
    private List<BeforeRunTask> getHardcodedBeforeRunTasks(@NotNull RunConfiguration settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/RunManagerImpl", "getHardcodedBeforeRunTasks"));
        }
        SmartList _tasks = new SmartList();
        for (BeforeRunTaskProvider provider : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject)) {
            BeforeRunTask task = provider.createTask(settings);
            if (task == null || !task.isEnabled()) continue;
            Key providerID = provider.getId();
            settings.getFactory().configureBeforeRunTaskDefaults(providerID, task);
            if (!task.isEnabled()) continue;
            _tasks.add(task);
        }
        SmartList smartList = _tasks;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getHardcodedBeforeRunTasks"));
        }
        return smartList;
    }

    @NotNull
    private static List<BeforeRunTask> getCopies(@NotNull List<BeforeRunTask> original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/execution/impl/RunManagerImpl", "getCopies"));
        }
        SmartList result = new SmartList();
        for (BeforeRunTask task : original) {
            if (!task.isEnabled()) continue;
            result.add(task.clone());
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getCopies"));
        }
        return smartList;
    }

    public void shareConfiguration(RunnerAndConfigurationSettings settings, boolean shareConfiguration) {
        boolean shouldFire;
        boolean bl = shouldFire = settings != null && this.isConfigurationShared(settings) != shareConfiguration;
        if (shareConfiguration && settings.isTemporary()) {
            this.makeStable(settings);
        }
        this.mySharedConfigurations.put(settings.getUniqueID(), shareConfiguration);
        if (shouldFire) {
            this.fireRunConfigurationChanged(settings);
        }
    }

    @Override
    public final void setBeforeRunTasks(RunConfiguration runConfiguration, @NotNull List<BeforeRunTask> tasks, boolean addEnabledTemplateTasksIfAbsent) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/execution/impl/RunManagerImpl", "setBeforeRunTasks"));
        }
        SmartList result = new SmartList(tasks);
        if (addEnabledTemplateTasksIfAbsent) {
            List<BeforeRunTask> templates = this.getTemplateBeforeRunTasks(runConfiguration);
            THashSet idsToSet = new THashSet();
            for (BeforeRunTask task : tasks) {
                idsToSet.add(task.getProviderId());
            }
            int i = 0;
            for (BeforeRunTask template : templates) {
                if (idsToSet.contains(template.getProviderId())) continue;
                result.add(i, template);
                ++i;
            }
        }
        this.myConfigurationToBeforeTasksMap.put(runConfiguration, (List<BeforeRunTask>)(result.isEmpty() ? Collections.emptyList() : result));
        this.fireBeforeRunTasksUpdated();
    }

    public final void resetBeforeRunTasks(RunConfiguration runConfiguration) {
        this.myConfigurationToBeforeTasksMap.remove(runConfiguration);
        this.fireBeforeRunTasksUpdated();
    }

    public void addConfiguration(RunnerAndConfigurationSettings settings, boolean isShared) {
        this.addConfiguration(settings, isShared, this.getTemplateBeforeRunTasks(settings.getConfiguration()), false);
    }

    public static RunManagerImpl getInstanceImpl(Project project2) {
        return (RunManagerImpl)RunManager.getInstance((Project)project2);
    }

    void removeNotExistingSharedConfigurations(@NotNull Set<String> existing) {
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/execution/impl/RunManagerImpl", "removeNotExistingSharedConfigurations"));
        }
        List removed = null;
        Iterator<Map.Entry<String, RunnerAndConfigurationSettings>> it = this.myConfigurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RunnerAndConfigurationSettings> entry = it.next();
            RunnerAndConfigurationSettings settings = entry.getValue();
            if (settings.isTemplate() || !this.isConfigurationShared(settings) || existing.contains(settings.getUniqueID())) continue;
            if (removed == null) {
                removed = new SmartList();
            }
            removed.add(settings);
            it.remove();
        }
        this.fireRunConfigurationsRemoved(removed);
    }

    public void fireRunConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/RunManagerImpl", "fireRunConfigurationChanged"));
        }
        ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationChanged(settings, null);
    }

    private void fireRunConfigurationsRemoved(@Nullable List<RunnerAndConfigurationSettings> removed) {
        if (!ContainerUtil.isEmpty(removed)) {
            this.myRecentlyUsedTemporaries.removeAll(removed);
            for (RunnerAndConfigurationSettings settings : removed) {
                ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationRemoved(settings);
            }
        }
    }

    private void fireRunConfigurationSelected() {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationSelected();
    }

    @Override
    public void addRunManagerListener(RunManagerListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void removeRunManagerListener(RunManagerListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void fireBeforeRunTasksUpdated() {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).beforeRunTasksChanged();
    }

    @NotNull
    private synchronized BeforeRunTaskProvider getProvider(Key<? extends BeforeRunTask> providerId) {
        if (this.myBeforeStepsMap == null) {
            this.initProviderMaps();
        }
        BeforeRunTaskProvider beforeRunTaskProvider = this.myBeforeStepsMap.get(providerId);
        if (beforeRunTaskProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getProvider"));
        }
        return beforeRunTaskProvider;
    }

    @NotNull
    private synchronized Key<? extends BeforeRunTask> getProviderKey(String keyString) {
        Key<? extends BeforeRunTask> id;
        if (this.myProviderKeysMap == null) {
            this.initProviderMaps();
        }
        if ((id = this.myProviderKeysMap.get(keyString)) == null) {
            UnknownBeforeRunTaskProvider provider = new UnknownBeforeRunTaskProvider(keyString);
            id = provider.getId();
            this.myProviderKeysMap.put(keyString, id);
            this.myBeforeStepsMap.put(id, provider);
        }
        Key<? extends BeforeRunTask> key = id;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getProviderKey"));
        }
        return key;
    }

    private void initProviderMaps() {
        this.myBeforeStepsMap = new LinkedHashMap<Key<? extends BeforeRunTask>, BeforeRunTaskProvider>();
        this.myProviderKeysMap = new LinkedHashMap<String, Key<? extends BeforeRunTask>>();
        for (BeforeRunTaskProvider provider : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject)) {
            Key id = provider.getId();
            this.myBeforeStepsMap.put((Key<? extends BeforeRunTask>)id, provider);
            this.myProviderKeysMap.put(id.toString(), (Key<? extends BeforeRunTask>)id);
        }
    }
}

