/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractPatternBasedConfigurationProducer<T extends ModuleBasedConfiguration>
extends JavaRunConfigurationProducerBase<T>
implements Cloneable {
    protected abstract boolean isTestClass(PsiClass var1);

    protected abstract boolean isTestMethod(boolean var1, PsiElement var2);

    public AbstractPatternBasedConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public Module findModule(ModuleBasedConfiguration configuration, Module contextModule, Set<String> patterns) {
        return JavaExecutionUtil.findModule((Module)contextModule, patterns, (Project)configuration.getProject(), (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                return AbstractPatternBasedConfigurationProducer.this.isTestClass(psiClass);
            }
        });
    }

    public boolean isMultipleElementsSelected(ConfigurationContext context) {
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible(dataContext)) {
            return false;
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(2);
        PsiElement[] locationElements = AbstractPatternBasedConfigurationProducer.collectLocationElements(classes, dataContext);
        if (locationElements != null) {
            this.collectTestMembers(locationElements, false, false, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
        } else {
            this.collectContextElements(dataContext, false, false, classes, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
        }
        return processor2.getCollection().size() > 1;
    }

    public boolean isConfiguredFromContext(ConfigurationContext context, Set<String> patterns) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible(dataContext)) {
            return false;
        }
        PsiElement[] locationElements = AbstractPatternBasedConfigurationProducer.collectLocationElements(classes, dataContext);
        if (locationElements == null) {
            this.collectContextElements(dataContext, true, false, classes, (PsiElementProcessor.CollectElements<PsiElement>)new PsiElementProcessor.CollectElements());
        }
        if (Comparing.equal(classes, patterns)) {
            String pattern;
            if (patterns.size() == 1 && !(pattern = patterns.iterator().next()).contains(",")) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)), PsiMethod.class);
                return method != null && this.isTestMethod(false, (PsiElement)method);
            }
            return true;
        }
        return false;
    }

    public PsiElement checkPatterns(ConfigurationContext context, LinkedHashSet<String> classes) {
        PsiElement[] result;
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible(dataContext)) {
            return null;
        }
        PsiElement[] locationElements = AbstractPatternBasedConfigurationProducer.collectLocationElements(classes, dataContext);
        PsiElementProcessor.CollectElements processor2 = new PsiElementProcessor.CollectElements();
        if (locationElements != null) {
            this.collectTestMembers(locationElements, false, true, (PsiElementProcessor.CollectElements<PsiElement>)processor2);
            result = processor2.toArray();
        } else if (this.collectContextElements(dataContext, true, true, classes, (PsiElementProcessor.CollectElements<PsiElement>)processor2)) {
            result = processor2.toArray();
        } else {
            return null;
        }
        if (result.length <= 1) {
            return null;
        }
        return result[0];
    }

    public void collectTestMembers(PsiElement[] psiElements, boolean checkAbstract, boolean checkIsTest, PsiElementProcessor.CollectElements<PsiElement> collectingProcessor) {
        for (PsiElement psiElement : psiElements) {
            PsiPackage aPackage;
            if (psiElement instanceof PsiClassOwner) {
                PsiClass[] classes;
                for (PsiClass aClass : classes = ((PsiClassOwner)psiElement).getClasses()) {
                    if ((checkIsTest || !aClass.hasModifierProperty("public")) && (!checkIsTest || !this.isTestClass(aClass)) || collectingProcessor.execute((PsiElement)aClass)) continue;
                    return;
                }
                continue;
            }
            if (psiElement instanceof PsiClass) {
                if ((checkIsTest || !((PsiClass)psiElement).hasModifierProperty("public")) && (!checkIsTest || !this.isTestClass((PsiClass)psiElement)) || collectingProcessor.execute(psiElement)) continue;
                return;
            }
            if (psiElement instanceof PsiMethod) {
                PsiClass containingClass;
                if (checkIsTest && this.isTestMethod(checkAbstract, psiElement) && !collectingProcessor.execute(psiElement)) {
                    return;
                }
                if (checkIsTest || (containingClass = ((PsiMethod)psiElement).getContainingClass()) == null || !containingClass.hasModifierProperty("public") || collectingProcessor.execute(psiElement)) continue;
                return;
            }
            if (!(psiElement instanceof PsiDirectory) || (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement)) == null || collectingProcessor.execute((PsiElement)aPackage)) continue;
            return;
        }
    }

    private boolean collectContextElements(DataContext dataContext, boolean checkAbstract, boolean checkIsTest, LinkedHashSet<String> classes, PsiElementProcessor.CollectElements<PsiElement> processor2) {
        Project project2;
        PsiFile editorFile;
        List allCarets;
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            return this.collectTestMembers(elements, checkAbstract, checkIsTest, processor2, classes);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && (allCarets = editor.getCaretModel().getAllCarets()).size() > 1 && (editorFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null) {
            LinkedHashSet methods = new LinkedHashSet();
            for (Caret caret : allCarets) {
                ContainerUtil.addIfNotNull(methods, (Object)PsiTreeUtil.getParentOfType((PsiElement)editorFile.findElementAt(caret.getOffset()), PsiMethod.class));
            }
            if (!methods.isEmpty()) {
                return this.collectTestMembers(methods.toArray(new PsiElement[0]), checkAbstract, checkIsTest, processor2, classes);
            }
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files != null && (project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            for (VirtualFile file2 : files) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (!(psiFile instanceof PsiClassOwner)) continue;
                PsiClass[] psiClasses = ((PsiClassOwner)psiFile).getClasses();
                if (element != null && psiClasses.length > 0) {
                    for (PsiClass aClass : psiClasses) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)element, (boolean)false)) continue;
                        psiClasses = new PsiClass[]{aClass};
                        break;
                    }
                }
                this.collectTestMembers((PsiElement[])psiClasses, checkAbstract, checkIsTest, processor2);
                for (PsiElement psiMember : processor2.getCollection()) {
                    classes.add(((PsiClass)psiMember).getQualifiedName());
                }
            }
            return true;
        }
        return false;
    }

    private boolean collectTestMembers(PsiElement[] elements, boolean checkAbstract, boolean checkIsTest, PsiElementProcessor.CollectElements<PsiElement> processor2, LinkedHashSet<String> classes) {
        this.collectTestMembers(elements, checkAbstract, checkIsTest, processor2);
        for (PsiElement psiClass : processor2.getCollection()) {
            classes.add(AbstractPatternBasedConfigurationProducer.getQName(psiClass));
        }
        return classes.size() > 1;
    }

    private static PsiElement[] collectLocationElements(LinkedHashSet<String> classes, DataContext dataContext) {
        Location[] locations = (Location[])Location.DATA_KEYS.getData(dataContext);
        if (locations != null) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            for (Location location : locations) {
                PsiElement psiElement = location.getPsiElement();
                classes.add(AbstractPatternBasedConfigurationProducer.getQName(psiElement, location));
                elements.add(psiElement);
            }
            return elements.toArray(new PsiElement[elements.size()]);
        }
        return null;
    }

    public static String getQName(PsiElement psiMember) {
        return AbstractPatternBasedConfigurationProducer.getQName(psiMember, null);
    }

    public static String getQName(PsiElement psiMember, Location location) {
        if (psiMember instanceof PsiClass) {
            return ClassUtil.getJVMClassName((PsiClass)((PsiClass)psiMember));
        }
        if (psiMember instanceof PsiMember) {
            PsiClass containingClass;
            PsiClass psiClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : (containingClass = location instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)location).getContainingClass() : ((PsiMember)psiMember).getContainingClass());
            assert (containingClass != null);
            return ClassUtil.getJVMClassName((PsiClass)containingClass) + "," + ((PsiMember)psiMember).getName();
        }
        if (psiMember instanceof PsiPackage) {
            return ((PsiPackage)psiMember).getQualifiedName();
        }
        assert (false);
        return null;
    }
}

