/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.TitledSeparator;
import com.intellij.usageView.UsageViewManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFindUsagesDialog
extends DialogWrapper {
    private final Project myProject;
    protected final FindUsagesOptions myFindUsagesOptions;
    private final boolean myToShowInNewTab;
    private final boolean myIsShowInNewTabEnabled;
    private final boolean myIsShowInNewTabVisible;
    private final boolean mySearchForTextOccurrencesAvailable;
    private final boolean mySearchInLibrariesAvailable;
    private JCheckBox myCbToOpenInNewTab;
    protected StateRestoringCheckBox myCbToSearchForTextOccurrences;
    protected JCheckBox myCbToSkipResultsWhenOneUsage;
    private final ActionListener myUpdateAction;
    private ScopeChooserCombo myScopeCombo;

    protected AbstractFindUsagesDialog(@NotNull Project project2, @NotNull FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, boolean searchForTextOccurrencesAvailable, boolean searchInLibrariesAvailable) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/AbstractFindUsagesDialog", "<init>"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/AbstractFindUsagesDialog", "<init>"));
        }
        super(project2, true);
        this.myProject = project2;
        this.myFindUsagesOptions = findUsagesOptions;
        this.myToShowInNewTab = toShowInNewTab;
        this.myIsShowInNewTabEnabled = !mustOpenInNewTab && UsageViewManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        this.myIsShowInNewTabVisible = !isSingleFile;
        this.mySearchForTextOccurrencesAvailable = searchForTextOccurrencesAvailable;
        this.mySearchInLibrariesAvailable = searchInLibrariesAvailable;
        this.myUpdateAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractFindUsagesDialog.this.update();
            }
        };
        this.setButtonsMargin(null);
        this.setOKButtonText(FindBundle.message("find.dialog.find.button", new Object[0]));
        this.setTitle(isSingleFile ? FindBundle.message("find.usages.in.file.dialog.title", new Object[0]) : FindBundle.message("find.usages.dialog.title", new Object[0]));
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/AbstractFindUsagesDialog", "createActions"));
        }
        return actionArray;
    }

    protected boolean isInFileOnly() {
        return !this.myIsShowInNewTabVisible;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.fill = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 17;
        SimpleColoredComponent coloredComponent = new SimpleColoredComponent();
        coloredComponent.setIpad(new Insets(0, 0, 0, 0));
        coloredComponent.setMyBorder(null);
        this.configureLabelComponent(coloredComponent);
        panel.add((Component)coloredComponent, gbConstraints);
        return panel;
    }

    public abstract void configureLabelComponent(@NotNull SimpleColoredComponent var1);

    protected JComponent createCenterPanel() {
        JPanel allOptionsPanel;
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel _panel = new JPanel(new BorderLayout());
        panel.add((Component)_panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.myIsShowInNewTabVisible) {
            this.myCbToOpenInNewTab = new JCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]));
            this.myCbToOpenInNewTab.setSelected(this.myToShowInNewTab);
            this.myCbToOpenInNewTab.setEnabled(this.myIsShowInNewTabEnabled);
            _panel.add((Component)this.myCbToOpenInNewTab, "East");
        }
        if ((allOptionsPanel = this.createAllOptionsPanel()) != null) {
            panel.add((Component)allOptionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    @NotNull
    public final FindUsagesOptions calcFindUsagesOptions() {
        this.calcFindUsagesOptions(this.myFindUsagesOptions);
        FindUsagesOptions findUsagesOptions = this.myFindUsagesOptions;
        if (findUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/AbstractFindUsagesDialog", "calcFindUsagesOptions"));
        }
        return findUsagesOptions;
    }

    protected void init() {
        super.init();
        this.update();
    }

    public void calcFindUsagesOptions(FindUsagesOptions options) {
        options.searchScope = this.myScopeCombo == null ? GlobalSearchScope.allScope((Project)this.myProject) : this.myScopeCombo.getSelectedScope();
        options.isSearchForTextOccurrences = AbstractFindUsagesDialog.isToChange(this.myCbToSearchForTextOccurrences) && AbstractFindUsagesDialog.isSelected(this.myCbToSearchForTextOccurrences);
    }

    protected void update() {
    }

    public boolean isShowInSeparateWindow() {
        return this.myCbToOpenInNewTab != null && this.myCbToOpenInNewTab.isSelected();
    }

    public boolean isSkipResultsWhenOneUsage() {
        return this.myCbToSkipResultsWhenOneUsage != null && this.myCbToSkipResultsWhenOneUsage.isSelected();
    }

    protected void doOKAction() {
        if (!this.shouldDoOkAction()) {
            return;
        }
        FindSettings settings = FindSettings.getInstance();
        if (this.myScopeCombo != null) {
            settings.setDefaultScopeName(this.myScopeCombo.getSelectedScopeName());
        }
        if (this.mySearchForTextOccurrencesAvailable && this.myCbToSearchForTextOccurrences != null && this.myCbToSearchForTextOccurrences.isEnabled()) {
            this.myFindUsagesOptions.isSearchForTextOccurrences = this.myCbToSearchForTextOccurrences.isSelected();
        }
        if (this.myCbToSkipResultsWhenOneUsage != null) {
            settings.setSkipResultsWithOneUsage(this.isSkipResultsWhenOneUsage());
        }
        super.doOKAction();
    }

    protected boolean shouldDoOkAction() {
        return this.myScopeCombo == null || this.myScopeCombo.getSelectedScope() != null;
    }

    protected static boolean isToChange(JCheckBox cb) {
        return cb != null && cb.getParent() != null;
    }

    protected static boolean isSelected(JCheckBox cb) {
        return cb != null && cb.getParent() != null && cb.isSelected();
    }

    protected StateRestoringCheckBox addCheckboxToPanel(String name, boolean toSelect, JPanel panel, boolean toUpdate) {
        StateRestoringCheckBox cb = new StateRestoringCheckBox(name);
        cb.setSelected(toSelect);
        panel.add(cb);
        if (toUpdate) {
            cb.addActionListener(this.myUpdateAction);
        }
        return cb;
    }

    protected JPanel createAllOptionsPanel() {
        JComponent scopePanel;
        JPanel allOptionsPanel = new JPanel();
        JPanel findWhatPanel = this.createFindWhatPanel();
        JPanel usagesOptionsPanel = this.createUsagesOptionsPanel();
        int grids = 0;
        if (findWhatPanel != null) {
            ++grids;
        }
        if (usagesOptionsPanel != null) {
            ++grids;
        }
        if (grids != 0) {
            allOptionsPanel.setLayout(new GridLayout(1, grids, 8, 0));
            if (findWhatPanel != null) {
                allOptionsPanel.add(findWhatPanel);
            }
            if (usagesOptionsPanel != null) {
                allOptionsPanel.add(usagesOptionsPanel);
            }
        }
        if ((scopePanel = this.createSearchScopePanel()) != null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)allOptionsPanel, "North");
            panel.add((Component)scopePanel, "South");
            return panel;
        }
        return allOptionsPanel;
    }

    @Nullable
    protected abstract JPanel createFindWhatPanel();

    protected void addUsagesOptions(JPanel optionsPanel) {
        if (this.mySearchForTextOccurrencesAvailable) {
            this.myCbToSearchForTextOccurrences = this.addCheckboxToPanel(FindBundle.message("find.options.search.for.text.occurences.checkbox", new Object[0]), this.myFindUsagesOptions.isSearchForTextOccurrences, optionsPanel, false);
        }
        if (this.myIsShowInNewTabVisible) {
            this.myCbToSkipResultsWhenOneUsage = this.addCheckboxToPanel(FindBundle.message("find.options.skip.results.tab.with.one.usage.checkbox", new Object[0]), FindSettings.getInstance().isSkipResultsWithOneUsage(), optionsPanel, false);
        }
    }

    @Nullable
    protected JPanel createUsagesOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.options.group", new Object[0]), (boolean)true));
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        this.addUsagesOptions(optionsPanel);
        return optionsPanel.getComponents().length == 0 ? null : optionsPanel;
    }

    @Nullable
    private JComponent createSearchScopePanel() {
        if (this.isInFileOnly()) {
            return null;
        }
        JPanel optionsPanel = new JPanel(new BorderLayout());
        String scope = this.myFindUsagesOptions.searchScope.getDisplayName();
        this.myScopeCombo = new ScopeChooserCombo(this.myProject, this.mySearchInLibrariesAvailable, true, scope);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        optionsPanel.add((Component)((Object)this.myScopeCombo), "Center");
        TitledSeparator separator = SeparatorFactory.createSeparator((String)FindBundle.message("find.scope.label", new Object[0]), (JComponent)this.myScopeCombo.getComboBox());
        optionsPanel.add((Component)separator, "North");
        return optionsPanel;
    }

    @Nullable
    protected JComponent getPreferredFocusedControl() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myScopeCombo != null) {
            return this.myScopeCombo.getComboBox();
        }
        return this.getPreferredFocusedControl();
    }
}

