/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.impl.FacetBasedDetectedFrameworkDescriptionImpl;
import com.intellij.framework.detection.impl.FrameworkDetectionContextBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkDetectionContextImpl
extends FrameworkDetectionContextBase {
    private final Project myProject;

    public FrameworkDetectionContextImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/framework/detection/impl/FrameworkDetectionContextImpl", "<init>"));
        }
        this.myProject = project2;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> List<? extends DetectedFrameworkDescription> createDetectedFacetDescriptions(@NotNull FacetBasedFrameworkDetector<F, C> detector, @NotNull Collection<VirtualFile> files) {
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/framework/detection/impl/FrameworkDetectionContextImpl", "createDetectedFacetDescriptions"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/framework/detection/impl/FrameworkDetectionContextImpl", "createDetectedFacetDescriptions"));
        }
        MultiMap filesByModule = MultiMap.createSet();
        for (VirtualFile file2 : files) {
            Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject);
            if (module2 == null) continue;
            filesByModule.putValue((Object)module2, (Object)file2);
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>> result = new ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>>();
        FacetType facetType = detector.getFacetType();
        FacetsProvider provider = DefaultFacetsProvider.INSTANCE;
        for (Module module3 : filesByModule.keySet()) {
            Collection facets = provider.getFacetsByType(module3, facetType.getId());
            if (!facetType.isSuitableModuleType(ModuleType.get((Module)module3)) || facetType.isOnlyOneFacetAllowed() && !facets.isEmpty()) continue;
            ArrayList<FacetConfiguration> existentConfigurations = new ArrayList<FacetConfiguration>();
            for (Facet facet : facets) {
                existentConfigurations.add(facet.getConfiguration());
            }
            Collection moduleFiles = filesByModule.get((Object)module3);
            List pairs = detector.createConfigurations(moduleFiles, existentConfigurations);
            for (Pair pair : pairs) {
                result.add(new FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>(module3, detector, (FacetConfiguration)pair.getFirst(), new HashSet<VirtualFile>((Collection)pair.getSecond())));
            }
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionImpl<F, FacetConfiguration>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectionContextImpl", "createDetectedFacetDescriptions"));
        }
        return arrayList;
    }

    public VirtualFile getBaseDir() {
        return this.myProject.getBaseDir();
    }
}

