/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFileFromTemplateAction
extends CreateFromTemplateAction<PsiFile> {
    public CreateFileFromTemplateAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    protected PsiFile createFileFromTemplate(final String name, final FileTemplate template, final PsiDirectory dir) {
        final PsiFile[] file2 = new PsiFile[1];
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                file2[0] = CreateFileFromTemplateAction.createFileFromTemplate(name, template, dir, CreateFileFromTemplateAction.this.getDefaultTemplateProperty(), true);
            }
        });
        return file2[0];
    }

    @Nullable
    public static PsiFile createFileFromTemplate(@Nullable String name, @NotNull FileTemplate template, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty, boolean openFile) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ide/actions/CreateFileFromTemplateAction", "createFileFromTemplate"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/ide/actions/CreateFileFromTemplateAction", "createFileFromTemplate"));
        }
        if (name != null) {
            CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(name, dir);
            name = mkdirs.newName;
            dir = mkdirs.directory;
        }
        Project project2 = dir.getProject();
        try {
            PsiElement element = FileTemplateUtil.createFromTemplate(template, name, FileTemplateManager.getInstance(dir.getProject()).getDefaultProperties(), dir);
            PsiFile psiFile = element.getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                if (openFile) {
                    if (template.isLiveTemplateEnabled()) {
                        CreateFromTemplateActionBase.startLiveTemplate(psiFile);
                    } else {
                        FileEditorManager.getInstance((Project)project2).openFile(virtualFile, true);
                    }
                }
                if (defaultTemplateProperty != null) {
                    PropertiesComponent.getInstance((Project)project2).setValue(defaultTemplateProperty, template.getName());
                }
                return psiFile;
            }
        }
        catch (ParseException e) {
            Messages.showErrorDialog((Project)project2, (String)("Error parsing Velocity template: " + e.getMessage()), (String)"Create File from Template");
            return null;
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    protected PsiFile createFile(String name, String templateName, PsiDirectory dir) {
        FileTemplate template = FileTemplateManager.getInstance(dir.getProject()).getInternalTemplate(templateName);
        return this.createFileFromTemplate(name, template, dir);
    }
}

