/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryOptionsTopHitProvider
extends OptionsTopHitProvider {
    @Override
    @NotNull
    public Collection<BooleanOptionDescription> getOptions(@Nullable Project project2) {
        List list = Holder.ourValues;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/RegistryOptionsTopHitProvider", "getOptions"));
        }
        return list;
    }

    @Override
    public boolean isEnabled(@Nullable Project project2) {
        return ApplicationManager.getApplication().isInternal();
    }

    @Override
    public String getId() {
        return "registry";
    }

    private static class Holder {
        private static final List<BooleanOptionDescription> ourValues = Holder.initValues();

        private Holder() {
        }

        private static List<BooleanOptionDescription> initValues() {
            ArrayList<BooleanOptionDescription> result = new ArrayList<BooleanOptionDescription>();
            for (RegistryValue value : Registry.getAll()) {
                if (!value.isBoolean()) continue;
                String key = value.getKey();
                RegistryBooleanOptionDescriptor optionDescriptor = new RegistryBooleanOptionDescriptor(key, key);
                if (value.isChangedFromDefault()) {
                    result.add(0, optionDescriptor);
                    continue;
                }
                result.add(optionDescriptor);
            }
            return result;
        }
    }
}

