/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.TextFragment;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

class ComplexTextFragment
extends TextFragment {
    private static final double CLIP_MARGIN = 10000.0;
    @NotNull
    private final GlyphVector myGlyphVector;

    ComplexTextFragment(@NotNull char[] lineChars, int start, int end, boolean isRtl, @NotNull Font font, @NotNull FontRenderContext fontRenderContext) {
        float lastX;
        float totalWidth;
        if (lineChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineChars", "com/intellij/openapi/editor/impl/view/ComplexTextFragment", "<init>"));
        }
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/openapi/editor/impl/view/ComplexTextFragment", "<init>"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/ComplexTextFragment", "<init>"));
        }
        super(end - start);
        assert (start >= 0);
        assert (end <= lineChars.length);
        assert (start < end);
        this.myGlyphVector = FontLayoutService.getInstance().layoutGlyphVector(font, fontRenderContext, lineChars, start, end, isRtl);
        int numChars = end - start;
        int numGlyphs = this.myGlyphVector.getNumGlyphs();
        this.myCharPositions[numChars - 1] = totalWidth = (float)this.myGlyphVector.getGlyphPosition(numGlyphs).getX();
        int lastCharIndex = -1;
        int ligatureStartCharIndex = 0;
        float prevX = lastX = isRtl ? totalWidth : 0.0f;
        for (int i = 0; i < numGlyphs; ++i) {
            int visualGlyphIndex = isRtl ? numGlyphs - 1 - i : i;
            int charIndex = this.myGlyphVector.getGlyphCharIndex(visualGlyphIndex);
            if (charIndex <= lastCharIndex) continue;
            Rectangle2D bounds = this.myGlyphVector.getGlyphLogicalBounds(visualGlyphIndex).getBounds2D();
            if (bounds.isEmpty()) {
                for (int j = ligatureStartCharIndex; j <= charIndex; ++j) {
                    this.setCharPosition(j, prevX + (lastX - prevX) * (float)(j - ligatureStartCharIndex + 1) / (float)(charIndex - ligatureStartCharIndex + 1), isRtl, numChars);
                }
            } else {
                float newX = isRtl ? Math.min(lastX, (float)bounds.getMinX()) : Math.max(lastX, (float)bounds.getMaxX());
                newX = Math.max(0.0f, Math.min(totalWidth, newX));
                for (int j = ligatureStartCharIndex = lastCharIndex + 1; j <= charIndex; ++j) {
                    this.setCharPosition(j, newX, isRtl, numChars);
                }
                prevX = lastX;
                lastX = newX;
            }
            lastCharIndex = charIndex;
        }
    }

    private void setCharPosition(int logicalCharIndex, float x, boolean isRtl, int numChars) {
        int charPosition;
        int n = charPosition = isRtl ? numChars - logicalCharIndex - 2 : logicalCharIndex;
        if (charPosition >= 0 && charPosition < numChars - 1) {
            this.myCharPositions[charPosition] = x;
        }
    }

    @Override
    public void draw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
        assert (startColumn >= 0);
        assert (endColumn <= this.myCharPositions.length);
        assert (startColumn < endColumn);
        if (startColumn == 0 && endColumn == this.myCharPositions.length) {
            g.drawGlyphVector(this.myGlyphVector, x, y);
        } else {
            Shape savedClip = g.getClip();
            float startX = x - this.getX(startColumn);
            double xMin = (double)x - (startColumn == 0 ? 10000.0 : 0.0);
            double xMax = (double)(startX + this.getX(endColumn)) + (endColumn == this.myCharPositions.length ? 10000.0 : 0.0);
            double yMin = (double)y - 10000.0;
            double yMax = (double)y + 10000.0;
            g.clip(new Rectangle2D.Double(xMin, yMin, xMax - xMin, yMax - yMin));
            g.drawGlyphVector(this.myGlyphVector, startX, y);
            g.setClip(savedClip);
        }
    }

    @Override
    boolean isRtl() {
        return (this.myGlyphVector.getLayoutFlags() & 4) != 0;
    }
}

