/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.swing.SwingUtilities;

public class StatusBarProgress
extends ProgressIndicatorBase {
    private final Map<StatusBar, Pair<String, String>> myStatusBar2SavedText = ContainerUtil.newHashMap();

    public StatusBarProgress() {
        super(true);
    }

    @Override
    public void start() {
        super.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    return;
                }
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                if (projects.length == 0) {
                    projects = new Project[]{null};
                }
                for (Project project2 : projects) {
                    StatusBar statusBar = windowManager.getStatusBar(project2);
                    if (statusBar == null) continue;
                    String info = (String)ObjectUtils.notNull((Object)statusBar.getInfo(), (Object)"");
                    StatusBarProgress.this.myStatusBar2SavedText.put(statusBar, Pair.pair((Object)info, (Object)info));
                }
            }
        });
    }

    @Override
    public void stop() {
        super.stop();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (StatusBar statusBar : StatusBarProgress.this.myStatusBar2SavedText.keySet()) {
                    String textToRestore = StatusBarProgress.this.updateRestoreText(statusBar);
                    statusBar.setInfo(textToRestore);
                }
                StatusBarProgress.this.myStatusBar2SavedText.clear();
            }
        });
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.update();
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.update();
    }

    private void update() {
        String text;
        if (!this.isRunning()) {
            text = "";
        } else {
            text = this.getText();
            double fraction = this.getFraction();
            if (fraction > 0.0) {
                text = text + " " + (int)(fraction * 100.0 + 0.5) + "%";
            }
        }
        final String _text = text;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (StatusBar statusBarEx : StatusBarProgress.this.myStatusBar2SavedText.keySet()) {
                    StatusBarProgress.this.setStatusBarText(statusBarEx, _text);
                }
            }
        });
    }

    private void setStatusBarText(StatusBar statusBar, String text) {
        this.updateRestoreText(statusBar);
        Pair<String, String> textsPair = this.myStatusBar2SavedText.get(statusBar);
        this.myStatusBar2SavedText.put(statusBar, (Pair<String, String>)Pair.pair((Object)textsPair.first, (Object)text));
        statusBar.setInfo(text);
    }

    private String updateRestoreText(StatusBar statusBar) {
        Pair<String, String> textsPair = this.myStatusBar2SavedText.get(statusBar);
        String info = (String)ObjectUtils.notNull((Object)statusBar.getInfo(), (Object)"");
        if (!((String)textsPair.getSecond()).equals(info)) {
            this.myStatusBar2SavedText.put(statusBar, (Pair<String, String>)Pair.pair((Object)info, (Object)textsPair.second));
        }
        return (String)textsPair.getFirst();
    }
}

