/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMergeRequest;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchMergeTool
implements MergeTool {
    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool", "createComponent"));
        }
        MyViewer myViewer = new MyViewer(context, (ApplyPatchMergeRequest)request);
        if (myViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool", "createComponent"));
        }
        return myViewer;
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool", "canShow"));
        }
        return request instanceof ApplyPatchMergeRequest;
    }

    public static class DiffIsApproximateNotification
    extends EditorNotificationPanel {
        public DiffIsApproximateNotification() {
            this.myLabel.setText("<html>Couldn't find context for patch. Some fragments were applied at the best possible place. <b>Please check carefully.</b></html>");
        }
    }

    private static class MyViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final ApplyPatchMergeRequest myMergeRequest;
        @NotNull
        private final SimpleDiffViewer myViewer;

        public MyViewer(@NotNull MergeContext context, @NotNull ApplyPatchMergeRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool$MyViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool$MyViewer", "<init>"));
            }
            this.myMergeContext = context;
            this.myMergeRequest = request;
            MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(this.myMergeRequest.getDocument());
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            DocumentContent localContent = contentFactory.create(this.myMergeRequest.getLocalContent(), file2);
            DocumentContent mergedContent = contentFactory.create(this.myMergeRequest.getProject(), this.myMergeRequest.getDocument());
            SimpleDiffRequest diffRequest = new SimpleDiffRequest(this.myMergeRequest.getTitle(), (DiffContent)localContent, (DiffContent)mergedContent, this.myMergeRequest.getLocalTitle(), this.myMergeRequest.getPatchedTitle());
            DiffUtil.addNotification((JComponent)((Object)new DiffIsApproximateNotification()), (UserDataHolder)diffRequest);
            this.myViewer = new SimpleDiffViewer((DiffContext)diffContext, (DiffRequest)diffRequest);
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myViewer.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool$MyViewer", "getComponent"));
            }
            return jComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            final Project project2 = this.myMergeContext.getProject();
            final Document document = this.myMergeRequest.getDocument();
            DiffUtil.executeWriteCommand(document, project2, "Init merge content", new Runnable(){

                @Override
                public void run() {
                    UndoManager undoManager;
                    document.setText((CharSequence)myMergeRequest.getPatchedContent());
                    UndoManager undoManager2 = undoManager = project2 != null ? UndoManager.getInstance((Project)project2) : UndoManager.getGlobalInstance();
                    if (undoManager != null) {
                        DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
                        undoManager.nonundoableActionPerformed(ref, false);
                    }
                }
            });
            MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
            FrameDiffTool.ToolbarComponents init = this.myViewer.init();
            components.statusPanel = init.statusPanel;
            components.toolbarActions = init.toolbarActions;
            components.closeHandler = new BooleanGetter(){

                public boolean get() {
                    return MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)myMergeRequest, myMergeContext);
                }
            };
            MergeTool.ToolbarComponents toolbarComponents = components;
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool$MyViewer", "init"));
            }
            return toolbarComponents;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/ApplyPatchMergeTool$MyViewer", "getResolveAction"));
            }
            if (result == MergeResult.LEFT || result == MergeResult.RIGHT) {
                return null;
            }
            String caption = MergeUtil.getResolveActionTitle(result, this.myMergeRequest, this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (result == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)myMergeRequest, myMergeContext)) {
                        return;
                    }
                    myMergeContext.finishMerge(result);
                }
            };
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myViewer);
        }
    }
}

