/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.platform.DirectoryProjectConfigurator;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PlatformProjectViewOpener
implements DirectoryProjectConfigurator {
    @Override
    public void configureProject(final Project project2, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/platform/PlatformProjectViewOpener", "configureProject"));
        }
        StartupManager.getInstance((Project)project2).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (project2.isDisposed()) {
                                    return;
                                }
                                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.PROJECT_VIEW);
                                if (toolWindow != null && toolWindow.getType() != ToolWindowType.SLIDING) {
                                    toolWindow.activate(null);
                                }
                            }
                        }, ModalityState.NON_MODAL);
                    }
                });
            }
        });
    }
}

