/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.CachedValuesFactory;
import org.jetbrains.annotations.NotNull;

public class PsiCachedValuesFactory
implements CachedValuesFactory {
    private final Project myProject;
    private final PsiManager myManager;

    public PsiCachedValuesFactory(PsiManager manager) {
        this.myManager = manager;
        this.myProject = manager.getProject();
    }

    @Override
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/PsiCachedValuesFactory", "createCachedValue"));
        }
        return trackValue ? new PsiCachedValueImpl<T>(this.myManager, provider){

            @Override
            protected Object[] getDependencies(CachedValueProvider.Result<T> result) {
                return this.getDependenciesPlusValue(result);
            }
        } : new PsiCachedValueImpl<T>(this.myManager, provider);
    }

    @Override
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/PsiCachedValuesFactory", "createParameterizedCachedValue"));
        }
        return trackValue ? new PsiParameterizedCachedValue<T, P>(this.myManager, provider){

            @Override
            public boolean isFromMyProject(Project project2) {
                return PsiCachedValuesFactory.this.myProject == project2;
            }

            @Override
            protected Object[] getDependencies(CachedValueProvider.Result<T> tResult) {
                return this.getDependenciesPlusValue(tResult);
            }
        } : new PsiParameterizedCachedValue<T, P>(this.myManager, provider){

            @Override
            public boolean isFromMyProject(Project project2) {
                return PsiCachedValuesFactory.this.myProject == project2;
            }
        };
    }
}

