/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.ImportSchemeChooserDialog;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeXmlImporter
implements SchemeImporter<CodeStyleScheme> {
    @NotNull
    public String[] getSourceExtensions() {
        String[] stringArray = new String[]{"xml"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getSourceExtensions"));
        }
        return stringArray;
    }

    @Nullable
    public CodeStyleScheme importScheme(@NotNull Project project2, @NotNull VirtualFile selectedFile, @NotNull CodeStyleScheme currentScheme, @NotNull SchemeFactory<CodeStyleScheme> schemeFactory) throws SchemeImportException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "importScheme"));
        }
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "importScheme"));
        }
        if (currentScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentScheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "importScheme"));
        }
        if (schemeFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeFactory", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "importScheme"));
        }
        Element rootElement = CodeStyleSchemeXmlImporter.loadScheme(selectedFile);
        Pair<String, CodeStyleScheme> importPair = ImportSchemeChooserDialog.selectOrCreateTargetScheme(project2, currentScheme, schemeFactory, CodeStyleSchemeXmlImporter.getSchemeName(rootElement));
        if (importPair != null) {
            return CodeStyleSchemeXmlImporter.readSchemeFromDom(rootElement, (CodeStyleScheme)importPair.second);
        }
        return null;
    }

    @NotNull
    private static Element loadScheme(@NotNull VirtualFile selectedFile) throws SchemeImportException {
        Element element;
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "loadScheme"));
        }
        InputStream inputStream = null;
        try {
            inputStream = selectedFile.getInputStream();
            Document document = JDOMUtil.loadDocument((InputStream)inputStream);
            Element root = document.getRootElement();
            inputStream.close();
            Element element2 = root;
            element = element2;
        }
        catch (IOException e) {
            throw new SchemeImportException(CodeStyleSchemeXmlImporter.getErrorMessage(e, selectedFile));
        }
        catch (JDOMException e) {
            throw new SchemeImportException(CodeStyleSchemeXmlImporter.getErrorMessage((Exception)((Object)e), selectedFile));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "loadScheme"));
        }
        return element;
    }

    @NotNull
    private static String getSchemeName(@NotNull Element rootElement) throws SchemeImportException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getSchemeName"));
        }
        String rootName = rootElement.getName();
        if (!"code_scheme".equals(rootName)) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.invalid.file", (Object[])new Object[]{rootName}));
        }
        Attribute schemeNameAttr = rootElement.getAttribute("name");
        if (schemeNameAttr == null) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.missing.scheme.name", (Object[])new Object[0]));
        }
        String string = schemeNameAttr.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getSchemeName"));
        }
        return string;
    }

    private static String getErrorMessage(@NotNull Exception e, @NotNull VirtualFile file2) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getErrorMessage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getErrorMessage"));
        }
        return "Can't read from" + file2.getName() + ", " + e.getMessage();
    }

    private static CodeStyleScheme readSchemeFromDom(@NotNull Element rootElement, @NotNull CodeStyleScheme scheme) throws SchemeImportException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "readSchemeFromDom"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "readSchemeFromDom"));
        }
        try {
            CodeStyleSettings defaultSettings = new CodeStyleSettings();
            scheme.getCodeStyleSettings().setParentSettings(defaultSettings);
            scheme.getCodeStyleSettings().readExternal(rootElement);
            return scheme;
        }
        catch (InvalidDataException e) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.can.not.load", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @Nullable
    public String getAdditionalImportInfo(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getAdditionalImportInfo"));
        }
        return null;
    }
}

