/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.InplaceIntroduceConstantPopup;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class LocalToFieldHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceField.LocalToFieldHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"convert.local.to.field.title");
    private final Project myProject;
    private final boolean myIsConstant;

    public LocalToFieldHandler(Project project2, boolean isConstant) {
        this.myProject = project2;
        this.myIsConstant = isConstant;
    }

    protected abstract BaseExpressionToFieldHandler.Settings showRefactoringDialog(PsiClass var1, PsiLocalVariable var2, PsiExpression[] var3, boolean var4);

    public boolean convertLocalToField(final PsiLocalVariable local, final Editor editor) {
        boolean shouldSuggestDialog;
        boolean tempIsStatic = this.myIsConstant;
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        for (PsiElement parent = local.getParent(); parent != null && parent.getContainingFile() != null; parent = parent.getParent()) {
            if (!(!(parent instanceof PsiClass) || this.myIsConstant && parent instanceof PsiAnonymousClass)) {
                classes.add((PsiClass)parent);
            }
            if (parent instanceof PsiFile && FileTypeUtils.isInServerPageFile((PsiElement)parent)) {
                String message = RefactoringBundle.message((String)"error.not.supported.for.jsp", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.convertLocal");
                return false;
            }
            if (!(parent instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent).hasModifierProperty("static")) continue;
            tempIsStatic = true;
        }
        if (classes.isEmpty()) {
            return false;
        }
        AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(editor);
        boolean bl = shouldSuggestDialog = activeIntroducer instanceof InplaceIntroduceConstantPopup && activeIntroducer.startsOnTheSameElement(null, local);
        if (classes.size() == 1 || ApplicationManager.getApplication().isUnitTestMode() || shouldSuggestDialog) {
            if (this.convertLocalToField(local, (PsiClass)classes.get(this.getChosenClassIndex(classes)), editor, tempIsStatic)) {
                return false;
            }
        } else {
            final boolean isStatic = tempIsStatic;
            PsiClass firstClass = (PsiClass)classes.get(0);
            PsiClass preselection = AnonymousTargetClassPreselectionUtil.getPreselection(classes, firstClass);
            NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])classes.toArray(new PsiClass[classes.size()])), (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)("Choose class to introduce " + (this.myIsConstant ? "constant" : "field")), (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass aClass) {
                    if (aClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/introduceField/LocalToFieldHandler$1", "execute"));
                    }
                    AnonymousTargetClassPreselectionUtil.rememberSelection(aClass, aClass);
                    LocalToFieldHandler.this.convertLocalToField(local, aClass, editor, isStatic);
                    return false;
                }
            }, (PsiElement)preselection).showInBestPositionFor(editor);
        }
        return true;
    }

    protected int getChosenClassIndex(List<PsiClass> classes) {
        return classes.size() - 1;
    }

    private boolean convertLocalToField(PsiLocalVariable local, PsiClass aClass, Editor editor, boolean isStatic) {
        BaseExpressionToFieldHandler.Settings settings;
        PsiExpression[] occurences = CodeInsightUtil.findReferenceExpressions(RefactoringUtil.getVariableScope(local), (PsiElement)local);
        if (editor != null) {
            RefactoringUtil.highlightAllOccurrences(this.myProject, (PsiElement[])occurences, editor);
        }
        if ((settings = this.showRefactoringDialog(aClass, local, occurences, isStatic)) == null) {
            return true;
        }
        PsiClass destinationClass = settings.getDestinationClass();
        boolean rebindNeeded = false;
        if (destinationClass != null) {
            aClass = destinationClass;
            rebindNeeded = true;
        }
        PsiClass aaClass = aClass;
        boolean rebindNeeded1 = rebindNeeded;
        final IntroduceFieldRunnable runnable2 = new IntroduceFieldRunnable(rebindNeeded1, local, aaClass, settings, isStatic, occurences);
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable2);
            }
        }, REFACTORING_NAME, null);
        return false;
    }

    private static PsiField createField(PsiLocalVariable local, PsiType forcedType, String fieldName, boolean includeInitializer) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("private int ");
        pattern.append(fieldName);
        if (local.getInitializer() == null) {
            includeInitializer = false;
        }
        if (includeInitializer) {
            pattern.append("=0");
        }
        pattern.append(";");
        Project project2 = local.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        try {
            PsiField field = factory.createFieldFromText(pattern.toString(), null);
            field.getTypeElement().replace((PsiElement)factory.createTypeElement(forcedType));
            if (includeInitializer) {
                PsiExpression initializer = RefactoringUtil.convertInitializerToNormalExpression(local.getInitializer(), forcedType);
                field.getInitializer().replace((PsiElement)initializer);
            }
            for (PsiAnnotation annotation : local.getModifierList().getAnnotations()) {
                field.getModifierList().add(annotation.copy());
            }
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiExpressionStatement createAssignment(PsiLocalVariable local, String fieldname, PsiElementFactory factory) {
        try {
            String pattern = fieldname + "=0;";
            PsiExpressionStatement statement2 = (PsiExpressionStatement)factory.createStatementFromText(pattern, null);
            statement2 = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)local.getProject()).reformat((PsiElement)statement2);
            PsiAssignmentExpression expr = (PsiAssignmentExpression)statement2.getExpression();
            PsiExpression initializer = RefactoringUtil.convertInitializerToNormalExpression(local.getInitializer(), local.getType());
            expr.getRExpression().replace((PsiElement)initializer);
            return statement2;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiStatement addInitializationToSetUp(PsiLocalVariable local, PsiField field, PsiElementFactory factory) throws IncorrectOperationException {
        PsiMethod inClass = TestFrameworks.getInstance().findOrCreateSetUpMethod(field.getContainingClass());
        assert (inClass != null);
        PsiExpressionStatement assignment = LocalToFieldHandler.createAssignment(local, field.getName(), factory);
        PsiCodeBlock body = inClass.getBody();
        assert (body != null);
        assignment = PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)local, (boolean)false) ? (PsiStatement)body.addBefore((PsiElement)assignment, PsiTreeUtil.getParentOfType((PsiElement)local, PsiStatement.class)) : (PsiStatement)body.add((PsiElement)assignment);
        LocalToFieldHandler.appendComments((PsiElement)local, (PsiElement)assignment);
        local.delete();
        return assignment;
    }

    private static PsiStatement addInitializationToConstructors(PsiLocalVariable local, PsiField field, PsiMethod enclosingConstructor, PsiElementFactory factory) throws IncorrectOperationException {
        PsiClass aClass = field.getContainingClass();
        PsiMethod[] constructors = aClass.getConstructors();
        PsiExpressionStatement assignment = LocalToFieldHandler.createAssignment(local, field.getName(), factory);
        boolean added = false;
        for (PsiMethod constructor : constructors) {
            PsiCodeBlock body;
            if (constructor == enclosingConstructor || (body = constructor.getBody()) == null) continue;
            PsiStatement[] statements = body.getStatements();
            if (statements.length > 0) {
                PsiExpression expression;
                PsiStatement first = statements[0];
                if (first instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression) {
                    String text = ((PsiMethodCallExpression)expression).getMethodExpression().getText();
                    if ("this".equals(text)) continue;
                    if ("super".equals(text) && enclosingConstructor == null && PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)local, (boolean)false)) {
                        PsiStatement statement2 = (PsiStatement)body.addAfter((PsiElement)assignment, (PsiElement)first);
                        LocalToFieldHandler.appendComments((PsiElement)local, (PsiElement)statement2);
                        local.delete();
                        return statement2;
                    }
                }
                if (enclosingConstructor == null && PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)local, (boolean)false)) {
                    PsiStatement statement3 = (PsiStatement)body.addBefore((PsiElement)assignment, (PsiElement)first);
                    LocalToFieldHandler.appendComments((PsiElement)local, (PsiElement)statement3);
                    local.delete();
                    return statement3;
                }
            }
            assignment = (PsiStatement)body.add((PsiElement)assignment);
            added = true;
        }
        if (!added && enclosingConstructor == null) {
            if (aClass instanceof PsiAnonymousClass) {
                PsiClassInitializer classInitializer = (PsiClassInitializer)aClass.addAfter((PsiElement)factory.createClassInitializer(), (PsiElement)field);
                assignment = (PsiStatement)classInitializer.getBody().add((PsiElement)assignment);
            } else {
                PsiMethod constructor = (PsiMethod)aClass.add((PsiElement)factory.createConstructor());
                assignment = (PsiStatement)constructor.getBody().add((PsiElement)assignment);
            }
        }
        if (enclosingConstructor == null) {
            LocalToFieldHandler.appendComments((PsiElement)assignment, (PsiElement)local);
            local.delete();
        }
        return assignment;
    }

    private static void appendComments(PsiElement declarationStatement, PsiElement element) {
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)declarationStatement, PsiComment.class);
        PsiElement parent = element.getParent();
        for (PsiComment comment : comments) {
            parent.addBefore((PsiElement)comment, element);
        }
    }

    static class IntroduceFieldRunnable
    implements Runnable {
        private final String myVariableName;
        private final String myFieldName;
        private final boolean myRebindNeeded;
        private final PsiLocalVariable myLocal;
        private final Project myProject;
        private final PsiClass myDestinationClass;
        private final BaseExpressionToFieldHandler.Settings mySettings;
        private final BaseExpressionToFieldHandler.InitializationPlace myInitializerPlace;
        private final PsiExpression[] myOccurences;
        private PsiField myField;

        public IntroduceFieldRunnable(boolean rebindNeeded, PsiLocalVariable local, PsiClass aClass, BaseExpressionToFieldHandler.Settings settings, boolean isStatic, PsiExpression[] occurrences) {
            this.myVariableName = local.getName();
            this.myFieldName = settings.getFieldName();
            this.myRebindNeeded = rebindNeeded;
            this.myLocal = local;
            this.myProject = local.getProject();
            this.myDestinationClass = aClass;
            this.mySettings = settings;
            this.myInitializerPlace = settings.getInitializerPlace();
            this.myOccurences = occurrences;
        }

        @Override
        public void run() {
            try {
                PsiExpressionStatement statement2;
                ChangeContextUtil.encodeContextInfo((PsiElement)this.myDestinationClass, true);
                boolean rebindNeeded2 = !this.myVariableName.equals(this.myFieldName) || this.myRebindNeeded;
                PsiReference[] refs = rebindNeeded2 ? (PsiReference[])ReferencesSearch.search((PsiElement)this.myLocal, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])new PsiReference[0]) : null;
                PsiMethod enclosingConstructor = BaseExpressionToFieldHandler.getEnclosingConstructor(this.myDestinationClass, (PsiElement)this.myLocal);
                this.myField = this.mySettings.isIntroduceEnumConstant() ? EnumConstantsUtil.createEnumConstant(this.myDestinationClass, this.myLocal, this.myFieldName) : LocalToFieldHandler.createField(this.myLocal, this.mySettings.getForcedType(), this.myFieldName, this.myInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
                this.myField = (PsiField)this.myDestinationClass.add((PsiElement)this.myField);
                BaseExpressionToFieldHandler.setModifiers(this.myField, this.mySettings);
                if (!this.mySettings.isIntroduceEnumConstant()) {
                    VisibilityUtil.fixVisibility((PsiExpression[])this.myOccurences, (PsiMember)this.myField, (String)this.mySettings.getFieldVisibility());
                }
                this.myLocal.normalizeDeclaration();
                PsiElement declarationStatement = this.myLocal.getParent();
                BaseExpressionToFieldHandler.InitializationPlace finalInitializerPlace = this.myLocal.getInitializer() == null ? BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION : this.myInitializerPlace;
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
                switch (finalInitializerPlace) {
                    case IN_FIELD_DECLARATION: {
                        LocalToFieldHandler.appendComments(declarationStatement, (PsiElement)this.myField);
                        declarationStatement.delete();
                        break;
                    }
                    case IN_CURRENT_METHOD: {
                        statement2 = LocalToFieldHandler.createAssignment(this.myLocal, this.myFieldName, factory);
                        LocalToFieldHandler.appendComments(declarationStatement, declarationStatement);
                        if (declarationStatement instanceof PsiDeclarationStatement) {
                            declarationStatement.replace((PsiElement)statement2);
                            break;
                        }
                        this.myLocal.replace((PsiElement)statement2.getExpression());
                        break;
                    }
                    case IN_CONSTRUCTOR: {
                        LocalToFieldHandler.addInitializationToConstructors(this.myLocal, this.myField, enclosingConstructor, factory);
                        break;
                    }
                    case IN_SETUP_METHOD: {
                        LocalToFieldHandler.addInitializationToSetUp(this.myLocal, this.myField, factory);
                    }
                }
                if (enclosingConstructor != null && this.myInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) {
                    statement2 = LocalToFieldHandler.createAssignment(this.myLocal, this.myFieldName, factory);
                    declarationStatement.replace((PsiElement)statement2);
                }
                if (rebindNeeded2) {
                    for (PsiReference reference : refs) {
                        if (reference == null) continue;
                        RefactoringUtil.replaceOccurenceWithFieldRef((PsiExpression)reference, this.myField, this.myDestinationClass);
                    }
                    ChangeContextUtil.decodeContextInfo((PsiElement)this.myDestinationClass, this.myDestinationClass, null);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        public PsiField getField() {
            return this.myField;
        }
    }
}

