/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingMoveDestination;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutocreatingSingleSourceRootMoveDestination
extends AutocreatingMoveDestination {
    private final VirtualFile mySourceRoot;
    PsiDirectory myTargetDirectory;

    public AutocreatingSingleSourceRootMoveDestination(PackageWrapper targetPackage, @NotNull VirtualFile sourceRoot) {
        if (sourceRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/refactoring/move/moveClassesOrPackages/AutocreatingSingleSourceRootMoveDestination", "<init>"));
        }
        super(targetPackage);
        this.myTargetDirectory = null;
        this.mySourceRoot = sourceRoot;
    }

    @Override
    public PackageWrapper getTargetPackage() {
        return this.myPackage;
    }

    public PsiDirectory getTargetIfExists(PsiDirectory source) {
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
    }

    public PsiDirectory getTargetIfExists(PsiFile source) {
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiDirectory source) throws IncorrectOperationException {
        return this.getDirectory();
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiFile source) throws IncorrectOperationException {
        return this.getDirectory();
    }

    @Nullable
    public String verify(PsiFile source) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public String verify(PsiDirectory source) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public String verify(PsiPackage aPackage) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public void analyzeModuleConflicts(Collection<PsiElement> elements, MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
        RefactoringConflictsUtil.analyzeModuleConflicts(this.getTargetPackage().getManager().getProject(), elements, usages, this.mySourceRoot, conflicts);
    }

    public boolean isTargetAccessible(Project project2, VirtualFile place) {
        boolean inTestSourceContent = ProjectRootManager.getInstance((Project)project2).getFileIndex().isInTestSourceContent(place);
        Module module2 = ModuleUtil.findModuleForFile((VirtualFile)place, (Project)project2);
        return this.mySourceRoot == null || module2 == null || GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2, (boolean)inTestSourceContent).contains(this.mySourceRoot);
    }

    private PsiDirectory getDirectory() throws IncorrectOperationException {
        if (this.myTargetDirectory == null) {
            this.myTargetDirectory = RefactoringUtil.createPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
        }
        return this.myTargetDirectory;
    }
}

