/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsLogColorManagerImpl
implements VcsLogColorManager {
    private static final Logger LOG = Logger.getInstance(VcsLogColorManagerImpl.class);
    private static Color[] ROOT_COLORS = new Color[]{JBColor.RED, JBColor.GREEN, JBColor.BLUE, JBColor.ORANGE, JBColor.CYAN, JBColor.YELLOW, JBColor.MAGENTA, JBColor.PINK};
    @NotNull
    private final List<VirtualFile> myRoots;
    @NotNull
    private final Map<VirtualFile, Color> myRoots2Colors;

    public VcsLogColorManagerImpl(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "<init>"));
        }
        this.myRoots = new ArrayList<VirtualFile>(roots);
        Collections.sort(this.myRoots, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.myRoots2Colors = ContainerUtil.newHashMap();
        int i = 0;
        for (VirtualFile root : this.myRoots) {
            Color color;
            if (i >= ROOT_COLORS.length) {
                double balance = (double)(i / ROOT_COLORS.length) / (double)(roots.size() / ROOT_COLORS.length);
                Color mix = ColorUtil.mix((Color)ROOT_COLORS[i % ROOT_COLORS.length], (Color)ROOT_COLORS[(i + 1) % ROOT_COLORS.length], (double)balance);
                int tones = (int)(Math.abs(balance - 0.5) * 2.0 * (double)(roots.size() / ROOT_COLORS.length) + 1.0);
                color = new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)));
            } else {
                color = ROOT_COLORS[i];
            }
            ++i;
            this.myRoots2Colors.put(root, color);
        }
    }

    @NotNull
    public static JBColor getBackgroundColor(final @NotNull Color baseRootColor) {
        if (baseRootColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRootColor", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getBackgroundColor"));
        }
        JBColor jBColor = new JBColor((NotNullProducer)new NotNullProducer<Color>(){

            @NotNull
            public Color produce() {
                Color color = ColorUtil.mix((Color)baseRootColor, (Color)UIUtil.getTableBackground(), (double)0.75);
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl$2", "produce"));
                }
                return color;
            }
        });
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getBackgroundColor"));
        }
        return jBColor;
    }

    @NotNull
    public static JBColor getIndicatorColor(final @NotNull Color baseRootColor) {
        if (baseRootColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRootColor", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getIndicatorColor"));
        }
        if (Registry.is((String)"vcs.log.square.labels")) {
            JBColor jBColor = VcsLogColorManagerImpl.getBackgroundColor(baseRootColor);
            if (jBColor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getIndicatorColor"));
            }
            return jBColor;
        }
        JBColor jBColor = new JBColor((NotNullProducer)new NotNullProducer<Color>(){

            @NotNull
            public Color produce() {
                if (UIUtil.isUnderDarcula()) {
                    Color color = baseRootColor;
                    if (color == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl$3", "produce"));
                    }
                    return color;
                }
                Color color = ColorUtil.darker((Color)ColorUtil.softer((Color)baseRootColor), (int)2);
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl$3", "produce"));
                }
                return color;
            }
        });
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getIndicatorColor"));
        }
        return jBColor;
    }

    @Override
    public boolean isMultipleRoots() {
        return this.myRoots.size() > 1;
    }

    @Override
    @NotNull
    public Color getRootColor(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getRootColor"));
        }
        Color color = this.myRoots2Colors.get(root);
        if (color == null) {
            LOG.error("No color record for root " + root + ". All roots: " + this.myRoots2Colors);
            color = VcsLogColorManagerImpl.getDefaultRootColor();
        }
        Color color2 = color;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogColorManagerImpl", "getRootColor"));
        }
        return color2;
    }

    private static Color getDefaultRootColor() {
        return UIUtil.getTableBackground();
    }
}

