/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowablePairConsumer;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReader {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.jsonSchema.impl.JsonSchemaReader");
    public static final NotificationGroup ERRORS_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"JSON Schema");

    public JsonSchemaObject read(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "read"));
        }
        JsonReader in = new JsonReader(reader);
        in.setLenient(true);
        in.beginObject();
        JsonSchemaObject object = new JsonSchemaObject();
        JsonSchemaGeneralObjectTypeAdapter adapter = new JsonSchemaGeneralObjectTypeAdapter();
        while (in.peek() == JsonToken.NAME) {
            String name = in.nextName();
            adapter.readSomeProperty(in, name, object);
        }
        this.processReferences(object, adapter.getAllObjects(), adapter.getIds());
        ArrayList<JsonSchemaObject> withoutDefinitions = new ArrayList<JsonSchemaObject>(adapter.getAllObjects());
        JsonSchemaReader.removeDefinitions(object, withoutDefinitions);
        return object;
    }

    public static boolean isJsonSchema(@NotNull String string, Consumer<String> errorConsumer) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "isJsonSchema"));
        }
        try {
            new JsonSchemaReader().read(new StringReader(string));
            return true;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            errorConsumer.consume((Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            errorConsumer.consume((Object)e.getMessage());
            return false;
        }
    }

    private static void removeDefinitions(JsonSchemaObject root, ArrayList<JsonSchemaObject> objects) {
        ArrayList<JsonSchemaObject> queue = new ArrayList<JsonSchemaObject>(objects.size() + 1);
        queue.addAll(objects);
        queue.add(root);
        for (JsonSchemaObject object : queue) {
            Map<String, JsonSchemaObject> definitions = object.getDefinitions();
            if (definitions == null) continue;
            objects.removeAll(definitions.values());
        }
    }

    private void processReferences(JsonSchemaObject root, Set<JsonSchemaObject> objects, Map<String, JsonSchemaObject> ids) {
        ArrayDeque<JsonSchemaObject> queue = new ArrayDeque<JsonSchemaObject>();
        queue.addAll(objects);
        int control = 10000;
        while (!queue.isEmpty()) {
            if (--control == 0) {
                throw new RuntimeException("cyclic definitions search");
            }
            JsonSchemaObject current = (JsonSchemaObject)queue.removeFirst();
            if ("#".equals(current.getRef()) || current.getRef() == null) continue;
            JsonSchemaObject definition = this.findDefinition(current.getRef(), root, ids);
            if (definition == null) {
                current.setRef(null);
                continue;
            }
            if (definition.getRef() != null && !"#".equals(definition.getRef())) {
                queue.addFirst(current);
                queue.addFirst(definition);
                continue;
            }
            JsonSchemaObject copy = new JsonSchemaObject();
            copy.mergeValues(definition);
            copy.mergeValues(current);
            current.copyValues(copy);
            current.setRef(null);
        }
    }

    @Nullable
    private JsonSchemaObject findDefinition(String ref, JsonSchemaObject root, Map<String, JsonSchemaObject> ids) {
        if ("#".equals(ref)) {
            return root;
        }
        JsonSchemaObject found = ids.get(ref);
        if (found != null) {
            return found;
        }
        if (ref.indexOf("#/") > 0) {
            return null;
        }
        if (!ref.startsWith("#/")) {
            throw new RuntimeException("Non-relative reference: " + ref);
        }
        ref = ref.substring(2);
        String[] parts = ref.split("/");
        JsonSchemaObject current = root;
        for (int i = 0; i < parts.length; ++i) {
            if (current == null) {
                throw new RuntimeException("Incorrect reference: " + ref);
            }
            String part = parts[i];
            if ("definitions".equals(part)) {
                if (i == parts.length - 1) {
                    throw new RuntimeException("Incorrect definition reference: " + ref);
                }
                current = current.getDefinitions().get(parts[++i]);
                continue;
            }
            if ("properties".equals(part)) {
                if (i == parts.length - 1) {
                    throw new RuntimeException("Incorrect properties reference: " + ref);
                }
                current = current.getProperties().get(parts[++i]);
                continue;
            }
            current = current.getDefinitions().get(part);
        }
        if (current == null) {
            throw new RuntimeException("Incorrect reference: " + ref);
        }
        return current;
    }

    private static class JsonSchemaGeneralObjectTypeAdapter
    extends TypeAdapter<JsonSchemaObject> {
        private final Set<JsonSchemaObject> myAllObjects = new HashSet<JsonSchemaObject>();
        private final Map<String, JsonSchemaObject> myIds = new HashMap<String, JsonSchemaObject>();
        private final Map<String, ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>> myMap = new HashMap<String, ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>>();

        public JsonSchemaGeneralObjectTypeAdapter() {
            this.myMap.put("id", new StringReader(){

                @Override
                protected void assign(String s, JsonSchemaObject object) throws IOException {
                    object.setId(s);
                }
            });
            this.myMap.put("$schema", new StringReader(){

                @Override
                protected void assign(String s, JsonSchemaObject object) throws IOException {
                    object.setSchema(s);
                }
            });
            this.myMap.put("description", new StringReader(){

                @Override
                protected void assign(String s, JsonSchemaObject object) throws IOException {
                    object.setDescription(s);
                }
            });
            this.myMap.put("title", new StringReader(){

                @Override
                protected void assign(String s, JsonSchemaObject object) throws IOException {
                    object.setTitle(s);
                }
            });
            this.myMap.put("$ref", this.createRef());
            this.myMap.put("default", this.createDefault());
            this.myMap.put("format", this.createFormat());
            this.myMap.put("definitions", this.createDefinitionsConsumer());
            this.myMap.put("properties", this.createPropertiesConsumer());
            this.myMap.put("multipleOf", this.createMultipleOf());
            this.myMap.put("maximum", this.createMaximum());
            this.myMap.put("minimum", this.createMinimum());
            this.myMap.put("exclusiveMaximum", this.createExclusiveMaximum());
            this.myMap.put("exclusiveMinimum", this.createExclusiveMinimum());
            this.myMap.put("maxLength", this.createMaxLength());
            this.myMap.put("minLength", this.createMinLength());
            this.myMap.put("pattern", this.createPattern());
            this.myMap.put("additionalItems", this.createAdditionalItems());
            this.myMap.put("items", this.createItems());
            this.myMap.put("maxItems", this.createMaxItems());
            this.myMap.put("minItems", this.createMinItems());
            this.myMap.put("uniqueItems", this.createUniqueItems());
            this.myMap.put("maxProperties", this.createMaxProperties());
            this.myMap.put("minProperties", this.createMinProperties());
            this.myMap.put("required", this.createRequired());
            this.myMap.put("additionalProperties", this.createAdditionalProperties());
            this.myMap.put("patternProperties", this.createPatternProperties());
            this.myMap.put("dependencies", this.createDependencies());
            this.myMap.put("enum", this.createEnum());
            this.myMap.put("type", this.createType());
            this.myMap.put("allOf", new SchemaArrayConsumer(){

                @Override
                protected void assign(ArrayList<JsonSchemaObject> list, JsonSchemaObject object) {
                    object.setAllOf(list);
                }
            });
            this.myMap.put("anyOf", new SchemaArrayConsumer(){

                @Override
                protected void assign(ArrayList<JsonSchemaObject> list, JsonSchemaObject object) {
                    object.setAnyOf(list);
                }
            });
            this.myMap.put("oneOf", new SchemaArrayConsumer(){

                @Override
                protected void assign(ArrayList<JsonSchemaObject> list, JsonSchemaObject object) {
                    object.setOneOf(list);
                }
            });
            this.myMap.put("not", this.createNot());
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createFormat() {
            return new StringReader(){

                @Override
                protected void assign(String s, JsonSchemaObject object) throws IOException {
                    object.setFormat(s);
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createDefault() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() == JsonToken.BEGIN_OBJECT) {
                        object.setDefault(this.readInnerObject(in));
                    } else if (in.peek() == JsonToken.NUMBER) {
                        object.setDefault(in.nextDouble());
                    } else if (in.peek() == JsonToken.STRING) {
                        object.setDefault(in.nextString());
                    } else if (in.peek() == JsonToken.BOOLEAN) {
                        object.setDefault(in.nextBoolean());
                    } else {
                        in.skipValue();
                    }
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createRef() {
            return new StringReader(){

                @Override
                protected void assign(String s, JsonSchemaObject object) throws IOException {
                    object.setRef(s);
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createNot() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() == JsonToken.BEGIN_OBJECT) {
                        object.setNot(this.readInnerObject(in));
                    } else {
                        in.skipValue();
                    }
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createType() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() == JsonToken.STRING) {
                        object.setType(this.parseType(in));
                    } else if (in.peek() == JsonToken.BEGIN_ARRAY) {
                        ArrayList<JsonSchemaType> variants = new ArrayList<JsonSchemaType>();
                        in.beginArray();
                        while (in.peek() != JsonToken.END_ARRAY) {
                            if (in.peek() == JsonToken.STRING) {
                                variants.add(this.parseType(in));
                                continue;
                            }
                            in.skipValue();
                        }
                        in.endArray();
                        object.setTypeVariants(variants);
                    } else {
                        in.skipValue();
                    }
                }

                private JsonSchemaType parseType(JsonReader in) throws IOException {
                    String typeString = in.nextString();
                    try {
                        return JsonSchemaType.valueOf("_" + typeString);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Wrong type value: " + typeString + "\"");
                    }
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createEnum() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() != JsonToken.BEGIN_ARRAY) {
                        in.skipValue();
                        return;
                    }
                    ArrayList<Object> objects = new ArrayList<Object>();
                    in.beginArray();
                    while (in.peek() != JsonToken.END_ARRAY) {
                        if (in.peek() == JsonToken.STRING) {
                            objects.add("\"" + in.nextString() + "\"");
                            continue;
                        }
                        if (in.peek() == JsonToken.NUMBER) {
                            objects.add(in.nextInt());
                            continue;
                        }
                        if (in.peek() == JsonToken.BOOLEAN) {
                            objects.add(in.nextBoolean());
                            continue;
                        }
                        in.skipValue();
                    }
                    in.endArray();
                    object.setEnum(objects);
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createDependencies() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() != JsonToken.BEGIN_OBJECT) {
                        in.skipValue();
                        return;
                    }
                    HashMap<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();
                    HashMap<String, JsonSchemaObject> schemaDependencies = new HashMap<String, JsonSchemaObject>();
                    in.beginObject();
                    while (in.peek() != JsonToken.END_OBJECT) {
                        if (in.peek() != JsonToken.NAME) {
                            in.skipValue();
                            continue;
                        }
                        String name = in.nextName();
                        if (in.peek() == JsonToken.BEGIN_ARRAY) {
                            ArrayList<String> members = new ArrayList<String>();
                            in.beginArray();
                            while (in.peek() != JsonToken.END_ARRAY) {
                                if (in.peek() == JsonToken.STRING) {
                                    members.add(in.nextString());
                                    continue;
                                }
                                in.skipValue();
                            }
                            in.endArray();
                            propertyDependencies.put(name, members);
                            continue;
                        }
                        if (in.peek() == JsonToken.BEGIN_OBJECT) {
                            schemaDependencies.put(name, this.readInnerObject(in));
                            continue;
                        }
                        in.skipValue();
                    }
                    in.endObject();
                    if (!propertyDependencies.isEmpty()) {
                        object.setPropertyDependencies(propertyDependencies);
                    }
                    if (!schemaDependencies.isEmpty()) {
                        object.setSchemaDependencies(schemaDependencies);
                    }
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createPatternProperties() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() != JsonToken.BEGIN_OBJECT) {
                        in.skipValue();
                        return;
                    }
                    in.beginObject();
                    HashMap<String, JsonSchemaObject> properties = new HashMap<String, JsonSchemaObject>();
                    while (in.peek() != JsonToken.END_OBJECT) {
                        if (in.peek() == JsonToken.NAME) {
                            String name = in.nextName();
                            if (in.peek() == JsonToken.BEGIN_OBJECT) {
                                properties.put(name, this.readInnerObject(in));
                                continue;
                            }
                            in.skipValue();
                            continue;
                        }
                        in.skipValue();
                    }
                    object.setPatternProperties(properties);
                    in.endObject();
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createAdditionalProperties() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() == JsonToken.BOOLEAN) {
                        object.setAdditionalPropertiesAllowed(in.nextBoolean());
                    } else if (in.peek() == JsonToken.BEGIN_OBJECT) {
                        object.setAdditionalPropertiesSchema(this.readInnerObject(in));
                    } else {
                        in.skipValue();
                    }
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createRequired() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() == JsonToken.BEGIN_ARRAY) {
                        ArrayList<String> required = new ArrayList<String>();
                        in.beginArray();
                        while (in.peek() != JsonToken.END_ARRAY) {
                            if (in.peek() == JsonToken.STRING) {
                                required.add(in.nextString());
                                continue;
                            }
                            in.skipValue();
                        }
                        in.endArray();
                        object.setRequired(required);
                    } else {
                        in.skipValue();
                    }
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMinProperties() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMinProperties(in.nextInt());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMaxProperties() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMaxProperties(in.nextInt());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createUniqueItems() {
            return new BooleanReader(){

                @Override
                protected void assign(boolean b, JsonSchemaObject object) throws IOException {
                    object.setUniqueItems(b);
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMinItems() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMinItems(in.nextInt());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMaxItems() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMaxItems(in.nextInt());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createItems() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() == JsonToken.BEGIN_OBJECT) {
                        object.setItemsSchema(this.readInnerObject(in));
                    } else if (in.peek() == JsonToken.BEGIN_ARRAY) {
                        in.beginArray();
                        ArrayList<JsonSchemaObject> list = new ArrayList<JsonSchemaObject>();
                        while (in.peek() != JsonToken.END_ARRAY) {
                            if (in.peek() == JsonToken.BEGIN_OBJECT) {
                                list.add(this.readInnerObject(in));
                                continue;
                            }
                            in.skipValue();
                        }
                        in.endArray();
                        object.setItemsSchemaList(list);
                    }
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createAdditionalItems() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    if (in.peek() == JsonToken.BOOLEAN) {
                        object.setAdditionalItemsAllowed(in.nextBoolean());
                    } else if (in.peek() == JsonToken.BEGIN_OBJECT) {
                        object.setAdditionalItemsSchema(this.readInnerObject(in));
                    } else {
                        in.skipValue();
                    }
                }
            };
        }

        private JsonSchemaObject readInnerObject(JsonReader in) throws IOException {
            return this.read(in);
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createPattern() {
            return new StringReader(){

                @Override
                protected void assign(String s, JsonSchemaObject object) throws IOException {
                    object.setPattern(s);
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMinLength() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMinLength(in.nextInt());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMaxLength() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMaxLength(in.nextInt());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createExclusiveMinimum() {
            return new BooleanReader(){

                @Override
                protected void assign(boolean b, JsonSchemaObject object) throws IOException {
                    object.setExclusiveMinimum(b);
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createExclusiveMaximum() {
            return new BooleanReader(){

                @Override
                protected void assign(boolean b, JsonSchemaObject object) throws IOException {
                    object.setExclusiveMaximum(b);
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMinimum() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMinimum(in.nextDouble());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMaximum() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMaximum(in.nextDouble());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createMultipleOf() {
            return new NumberReader(){

                @Override
                protected void readNumber(JsonReader in, JsonSchemaObject object) throws IOException {
                    object.setMultipleOf(in.nextDouble());
                }
            };
        }

        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createPropertiesConsumer() {
            return new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    in.beginObject();
                    while (in.peek() == JsonToken.NAME) {
                        String name = in.nextName();
                        object.getProperties().put(name, this.readInnerObject(in));
                    }
                    in.endObject();
                }
            };
        }

        @NotNull
        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> createDefinitionsConsumer() {
            ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> throwablePairConsumer = new ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException>(){

                public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                    HashMap<String, JsonSchemaObject> map = new HashMap<String, JsonSchemaObject>();
                    in.beginObject();
                    while (in.peek() == JsonToken.NAME) {
                        String name = in.nextName();
                        map.put(name, this.readInnerObject(in));
                    }
                    in.endObject();
                    if (!map.isEmpty()) {
                        object.setDefinitions(map);
                    }
                }
            };
            if (throwablePairConsumer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaReader$JsonSchemaGeneralObjectTypeAdapter", "createDefinitionsConsumer"));
            }
            return throwablePairConsumer;
        }

        @Nullable
        private ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> getPropertyConsumer(String name) {
            return this.myMap.get(name);
        }

        public void write(JsonWriter out, JsonSchemaObject value) throws IOException {
            throw new IllegalStateException(" no intention to implement writing");
        }

        public JsonSchemaObject read(JsonReader in) throws IOException {
            in.beginObject();
            JsonSchemaObject object = new JsonSchemaObject();
            while (in.peek() == JsonToken.NAME) {
                String name = in.nextName();
                this.readSomeProperty(in, name, object);
            }
            in.endObject();
            this.myAllObjects.add(object);
            if (object.getId() != null) {
                this.myIds.put(object.getId(), object);
            }
            return object;
        }

        void readSomeProperty(JsonReader in, String name, JsonSchemaObject object) throws IOException {
            ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> consumer = this.myMap.get(name);
            if (consumer != null) {
                consumer.consume((Object)in, (Object)object);
            } else {
                this.readSingleDefinition(in, name, object);
            }
        }

        void readSingleDefinition(JsonReader in, String name, JsonSchemaObject object) throws IOException {
            if (in.peek() != JsonToken.BEGIN_OBJECT) {
                in.skipValue();
                return;
            }
            JsonSchemaObject defined = this.read(in);
            if (defined == null) {
                return;
            }
            Map<String, JsonSchemaObject> definitions = object.getDefinitions();
            if (definitions == null) {
                definitions = new HashMap<String, JsonSchemaObject>();
                object.setDefinitions(definitions);
            }
            definitions.put(name, defined);
        }

        public Set<JsonSchemaObject> getAllObjects() {
            return this.myAllObjects;
        }

        public Map<String, JsonSchemaObject> getIds() {
            return this.myIds;
        }

        private abstract class NumberReader
        implements ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> {
            private NumberReader() {
            }

            public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                if (in.peek() == JsonToken.NUMBER) {
                    this.readNumber(in, object);
                } else {
                    in.skipValue();
                }
            }

            protected abstract void readNumber(JsonReader var1, JsonSchemaObject var2) throws IOException;
        }

        private abstract class BooleanReader
        implements ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> {
            private BooleanReader() {
            }

            public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                if (in.peek() == JsonToken.BOOLEAN) {
                    this.assign(in.nextBoolean(), object);
                } else {
                    in.skipValue();
                }
            }

            protected abstract void assign(boolean var1, JsonSchemaObject var2) throws IOException;
        }

        private abstract class StringReader
        implements ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> {
            private StringReader() {
            }

            public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                if (in.peek() == JsonToken.STRING) {
                    this.assign(in.nextString(), object);
                } else {
                    in.skipValue();
                }
            }

            protected abstract void assign(String var1, JsonSchemaObject var2) throws IOException;
        }

        private abstract class SchemaArrayConsumer
        implements ThrowablePairConsumer<JsonReader, JsonSchemaObject, IOException> {
            private SchemaArrayConsumer() {
            }

            public void consume(JsonReader in, JsonSchemaObject object) throws IOException {
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    ArrayList<JsonSchemaObject> list = new ArrayList<JsonSchemaObject>();
                    while (in.peek() != JsonToken.END_ARRAY) {
                        if (in.peek() == JsonToken.BEGIN_OBJECT) {
                            list.add(JsonSchemaGeneralObjectTypeAdapter.this.readInnerObject(in));
                            continue;
                        }
                        in.skipValue();
                    }
                    this.assign(list, object);
                    in.endArray();
                } else {
                    in.skipValue();
                }
            }

            protected abstract void assign(ArrayList<JsonSchemaObject> var1, JsonSchemaObject var2);
        }
    }
}

