/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DoubleLiteralMayBeFloatLiteralInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.literal.may.be.float.literal.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/DoubleLiteralMayBeFloatLiteralInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        String string = InspectionGadgetsBundle.message("double.literal.may.be.float.literal.problem.descriptor", replacementText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/DoubleLiteralMayBeFloatLiteralInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        return new DoubleLiteralMayBeFloatLiteralFix(replacementText.toString());
    }

    private static StringBuilder buildReplacementText(PsiExpression expression, StringBuilder out) {
        if (expression instanceof PsiLiteralExpression) {
            out.append(expression.getText());
            out.append('f');
        } else {
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiJavaToken sign = prefixExpression.getOperationSign();
                out.append(sign.getText());
                return DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText(prefixExpression.getOperand(), out);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                out.append('(');
                DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText(parenthesizedExpression.getExpression(), out);
                out.append(')');
            } else if (expression instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
                PsiExpression operand = typeCastExpression.getOperand();
                DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText(operand, out);
            } else assert (false);
        }
        return out;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleLiteralMayBeFloatLiteralVisitor();
    }

    private static class DoubleLiteralMayBeFloatLiteralVisitor
    extends BaseInspectionVisitor {
        private DoubleLiteralMayBeFloatLiteralVisitor() {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!PsiType.DOUBLE.equals((Object)type)) {
                return;
            }
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiPrefixExpression || parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiType castType = typeCastExpression.getType();
            if (!PsiType.FLOAT.equals((Object)castType)) {
                return;
            }
            this.registerError((PsiElement)typeCastExpression, typeCastExpression);
        }
    }

    private static class DoubleLiteralMayBeFloatLiteralFix
    extends InspectionGadgetsFix {
        private final String replacementString;

        public DoubleLiteralMayBeFloatLiteralFix(String replacementString) {
            this.replacementString = replacementString;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("double.literal.may.be.float.literal.quickfix", this.replacementString);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/DoubleLiteralMayBeFloatLiteralInspection$DoubleLiteralMayBeFloatLiteralFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with 'float'" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/DoubleLiteralMayBeFloatLiteralInspection$DoubleLiteralMayBeFloatLiteralFix", "getFamilyName"));
            }
            return "Replace with 'float'";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, this.replacementString);
        }
    }
}

