/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class ControlFlowStatementWithoutBracesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ControlFlowStatementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ControlFlowStatementVisitor();
    }

    private static class ControlFlowStatementVisitor
    extends BaseInspectionVisitor {
        private ControlFlowStatementVisitor() {
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            super.visitDoWhileStatement(statement2);
            PsiStatement body = statement2.getBody();
            if (body == null || body instanceof PsiBlockStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            PsiStatement body = statement2.getBody();
            if (body == null || body instanceof PsiBlockStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiStatement body = statement2.getBody();
            if (body == null || body instanceof PsiBlockStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiStatement elseBranch;
            super.visitIfStatement(statement2);
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (!(thenBranch instanceof PsiBlockStatement)) {
                this.registerStatementError((PsiStatement)statement2, new Object[0]);
            }
            if ((elseBranch = statement2.getElseBranch()) == null) {
                return;
            }
            if (!(elseBranch instanceof PsiBlockStatement) && !(elseBranch instanceof PsiIfStatement)) {
                PsiKeyword elseKeyword = statement2.getElseElement();
                if (elseKeyword == null) {
                    return;
                }
                this.registerError((PsiElement)elseKeyword, new Object[0]);
            }
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiStatement body = statement2.getBody();
            if (body == null || body instanceof PsiBlockStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }

    private static class ControlFlowStatementFix
    extends InspectionGadgetsFix {
        private ControlFlowStatementFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection$ControlFlowStatementFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection$ControlFlowStatementFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiStatement statementWithoutBraces;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiStatement)) {
                return;
            }
            PsiStatement statement2 = (PsiStatement)parent;
            String elementText = element.getText();
            if (statement2 instanceof PsiLoopStatement) {
                PsiLoopStatement loopStatement = (PsiLoopStatement)statement2;
                statementWithoutBraces = loopStatement.getBody();
            } else if (statement2 instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement2;
                if ("if".equals(elementText)) {
                    statementWithoutBraces = ifStatement.getThenBranch();
                    if (statementWithoutBraces == null) {
                        return;
                    }
                    PsiElement nextSibling = statementWithoutBraces.getNextSibling();
                    if (nextSibling instanceof PsiWhiteSpace) {
                        nextSibling.delete();
                    }
                } else {
                    statementWithoutBraces = ifStatement.getElseBranch();
                }
            } else {
                return;
            }
            if (statementWithoutBraces == null) {
                return;
            }
            String newStatementText = "{\n" + statementWithoutBraces.getText() + "\n}";
            PsiReplacementUtil.replaceStatement(statementWithoutBraces, newStatementText);
        }
    }
}

