/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.javaee.UriUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.thaiopensource.datatype.xsd.DatatypeLibraryFactoryImpl;
import com.thaiopensource.relaxng.impl.SchemaReaderImpl;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.xml.sax.Sax2XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.StringReader;
import java.util.concurrent.ConcurrentMap;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.rngom.ast.builder.BuildException;
import org.kohsuke.rngom.ast.builder.IncludedGrammar;
import org.kohsuke.rngom.ast.builder.SchemaBuilder;
import org.kohsuke.rngom.ast.om.ParsedPattern;
import org.kohsuke.rngom.binary.SchemaBuilderImpl;
import org.kohsuke.rngom.binary.SchemaPatternBuilder;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DSchemaBuilderImpl;
import org.kohsuke.rngom.dt.CachedDatatypeLibraryFactory;
import org.kohsuke.rngom.dt.CascadingDatatypeLibraryFactory;
import org.kohsuke.rngom.dt.DoNothingDatatypeLibraryFactoryImpl;
import org.kohsuke.rngom.dt.builtin.BuiltinDatatypeLibraryFactory;
import org.kohsuke.rngom.parse.IllegalSchemaException;
import org.kohsuke.rngom.parse.compact.CompactParseable;
import org.kohsuke.rngom.parse.xml.SAXParseable;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RngParser {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.plugins.relaxNG.validation.RngParser");
    private static final NotNullLazyValue<DatatypeLibraryFactory> DT_LIBRARY_FACTORY = new AtomicNotNullLazyValue<DatatypeLibraryFactory>(){

        @NotNull
        protected DatatypeLibraryFactory compute() {
            BuiltinDatatypeLibraryFactory builtinDatatypeLibraryFactory = new BuiltinDatatypeLibraryFactory((DatatypeLibraryFactory)new CachedDatatypeLibraryFactory((DatatypeLibraryFactory)new CascadingDatatypeLibraryFactory(RngParser.createXsdDatatypeFactory(), (DatatypeLibraryFactory)new DatatypeLibraryLoader())){

                public synchronized DatatypeLibrary createDatatypeLibrary(String namespaceURI) {
                    return super.createDatatypeLibrary(namespaceURI);
                }
            });
            if (builtinDatatypeLibraryFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/validation/RngParser$1", "compute"));
            }
            return builtinDatatypeLibraryFactory;
        }
    };
    private static final ConcurrentMap<String, DPattern> ourCache = ContainerUtil.createConcurrentSoftMap();
    static final Key<CachedValue<Schema>> SCHEMA_KEY = Key.create((String)"SCHEMA");
    public static final DefaultHandler DEFAULT_HANDLER = new DefaultHandler(){

        @Override
        public void error(SAXParseException e) throws SAXException {
            LOG.info("e.getMessage() = " + e.getMessage() + " [" + e.getSystemId() + "]");
            LOG.info((Throwable)e);
        }
    };
    static final PropertyMap EMPTY_PROPS = new PropertyMapBuilder().toPropertyMap();

    private static DatatypeLibraryFactory createXsdDatatypeFactory() {
        try {
            return new DatatypeLibraryFactoryImpl();
        }
        catch (Throwable e) {
            LOG.error("Could not create DT library implementation 'com.thaiopensource.datatype.xsd.DatatypeLibraryFactoryImpl'. Plugin's classpath seems to be broken.", e);
            return new DoNothingDatatypeLibraryFactoryImpl();
        }
    }

    public static DPattern getCachedPattern(PsiFile descriptorFile, ErrorHandler eh) {
        DPattern oldPattern;
        VirtualFile file2 = descriptorFile.getVirtualFile();
        if (file2 == null) {
            return RngParser.parsePattern(descriptorFile, eh, false);
        }
        String url = file2.getUrl();
        DPattern pattern = (DPattern)ourCache.get(url);
        if (pattern == null) {
            pattern = RngParser.parsePattern(descriptorFile, eh, false);
        }
        if (pattern != null && (oldPattern = ourCache.putIfAbsent(url, pattern)) != null) {
            return oldPattern;
        }
        return pattern;
    }

    public static DPattern parsePattern(PsiFile file2, ErrorHandler eh, boolean checking) {
        block5: {
            try {
                org.kohsuke.rngom.parse.Parseable p = RngParser.createParsable(file2, eh);
                if (!checking) {
                    return (DPattern)p.parse((SchemaBuilder)new DSchemaBuilderImpl());
                }
                p.parse((SchemaBuilder)new SchemaBuilderImpl(eh, (DatatypeLibraryFactory)DT_LIBRARY_FACTORY.getValue(), new SchemaPatternBuilder()));
            }
            catch (BuildException e) {
                LOG.info((Throwable)e);
            }
            catch (IllegalSchemaException e) {
                VirtualFile virtualFile = file2.getVirtualFile();
                if (virtualFile == null) break block5;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("invalid schema: " + virtualFile.getPresentableUrl(), (Throwable)e);
                }
                LOG.info("invalid schema: " + virtualFile.getPresentableUrl() + ". [" + e.getMessage() + "]");
            }
        }
        return null;
    }

    private static org.kohsuke.rngom.parse.Parseable createParsable(PsiFile file2, ErrorHandler eh) {
        InputSource source = RngParser.makeInputSource(file2);
        final VirtualFile virtualFile = file2.getVirtualFile();
        if (file2.getFileType() == RncFileType.getInstance()) {
            return new CompactParseable(source, eh){

                public ParsedPattern parseInclude(String uri, SchemaBuilder schemaBuilder, IncludedGrammar g, String inheritedNs) throws BuildException, IllegalSchemaException {
                    ProgressManager.checkCanceled();
                    return super.parseInclude(RngParser.resolveURI(virtualFile, uri), schemaBuilder, g, inheritedNs);
                }
            };
        }
        return new SAXParseable(source, eh){

            public ParsedPattern parseInclude(String uri, SchemaBuilder schemaBuilder, IncludedGrammar g, String inheritedNs) throws BuildException, IllegalSchemaException {
                ProgressManager.checkCanceled();
                return super.parseInclude(RngParser.resolveURI(virtualFile, uri), schemaBuilder, g, inheritedNs);
            }
        };
    }

    private static String resolveURI(VirtualFile descriptorFile, String s) {
        VirtualFile file2 = UriUtil.findRelativeFile((String)s, (VirtualFile)descriptorFile);
        if (file2 != null) {
            s = VfsUtilCore.fixIDEAUrl((String)file2.getUrl());
        }
        return s;
    }

    public static Schema getCachedSchema(final XmlFile descriptorFile) {
        CachedValue value = (CachedValue)descriptorFile.getUserData(SCHEMA_KEY);
        if (value == null) {
            CachedValueProvider<Schema> provider = new CachedValueProvider<Schema>(){

                public CachedValueProvider.Result<Schema> compute() {
                    InputSource inputSource = RngParser.makeInputSource((PsiFile)descriptorFile);
                    try {
                        Schema schema = new MySchemaReader((PsiFile)descriptorFile).createSchema(inputSource, EMPTY_PROPS);
                        PsiElementProcessor.CollectElements processor2 = new PsiElementProcessor.CollectElements();
                        RelaxIncludeIndex.processForwardDependencies(descriptorFile, (PsiElementProcessor<XmlFile>)processor2);
                        if (processor2.getCollection().size() > 0) {
                            return CachedValueProvider.Result.create((Object)schema, (Object[])new Object[]{processor2.toArray(), descriptorFile});
                        }
                        return CachedValueProvider.Result.createSingleDependency((Object)schema, (Object)descriptorFile);
                    }
                    catch (Exception e) {
                        LOG.info((Throwable)e);
                        return CachedValueProvider.Result.createSingleDependency(null, (Object)descriptorFile);
                    }
                }
            };
            CachedValuesManager mgr = CachedValuesManager.getManager((Project)descriptorFile.getProject());
            value = mgr.createCachedValue((CachedValueProvider)provider, false);
            descriptorFile.putUserData(SCHEMA_KEY, (Object)value);
        }
        return (Schema)value.getValue();
    }

    private static InputSource makeInputSource(PsiFile descriptorFile) {
        InputSource inputSource = new InputSource(new StringReader(descriptorFile.getText()));
        VirtualFile file2 = descriptorFile.getVirtualFile();
        if (file2 != null) {
            inputSource.setSystemId(VfsUtilCore.fixIDEAUrl((String)file2.getUrl()));
        }
        return inputSource;
    }

    static class MySchemaReader
    extends SchemaReaderImpl {
        private final PsiFile myDescriptorFile;

        public MySchemaReader(PsiFile descriptorFile) {
            this.myDescriptorFile = descriptorFile;
        }

        protected Parseable createParseable(XMLReaderCreator xmlReaderCreator, InputSource inputSource, ErrorHandler errorHandler) {
            if (this.myDescriptorFile.getFileType() == RncFileType.getInstance()) {
                return new com.thaiopensource.relaxng.parse.compact.CompactParseable(inputSource, errorHandler);
            }
            return new com.thaiopensource.relaxng.parse.sax.SAXParseable((XMLReaderCreator)new Sax2XMLReaderCreator(), inputSource, errorHandler);
        }
    }
}

